/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.chunkartifacts;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.CheckpointInfo;
import javax.batch.annotation.ItemReader;
import javax.batch.annotation.Open;
import javax.batch.annotation.ReadItem;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jsr352.tck.chunkartifacts.ConnectionHelper;
import jsr352.tck.chunktypes.InventoryCheckpointData;
import jsr352.tck.chunktypes.InventoryRecord;

@ItemReader(value="InventoryReader")
@Named(value="InventoryReader")
public class InventoryReader {
    private static final String CLASSNAME = InventoryReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    protected DataSource dataSource = null;
    @BatchContext
    JobContext<?> jobCtx;
    @BatchContext
    StepContext<?, ?> stepCtx;
    @BatchProperty(name="forced.fail.count")
    String forcedFailCountProp;
    @BatchProperty(name="dummy.delay.seconds")
    String dummyDelayProp;
    @BatchProperty(name="auto.commit")
    String autoCommitProp;
    boolean autoCommit = true;
    int forcedFailCount;
    int dummyDelay;
    int expectedReaderChkp = -1;
    int readerIndex = 0;
    InventoryCheckpointData inventoryCheckpoint = new InventoryCheckpointData();

    @Open
    public void openMe(InventoryCheckpointData cpd) throws NamingException {
        this.forcedFailCount = Integer.parseInt(this.forcedFailCountProp);
        this.dummyDelay = Integer.parseInt(this.dummyDelayProp);
        this.autoCommit = Boolean.parseBoolean(this.autoCommitProp);
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/orderDB");
        if (cpd != null) {
            this.readerIndex = cpd.getInventoryCount();
            this.stepCtx.getProperties().setProperty("init.checkpoint", this.readerIndex + "");
        }
    }

    @ReadItem
    public InventoryRecord readItem() throws Exception {
        InventoryRecord inventoryRecord;
        int quantity;
        ResultSet rs;
        PreparedStatement statement;
        Connection connection;
        block9: {
            if (this.forcedFailCount != 0 && this.readerIndex >= this.forcedFailCount) {
                if (this.dummyDelay > 0) {
                    Thread.sleep(this.dummyDelay);
                } else {
                    throw new Exception("Fail on purpose in InventoryRecord.readItem()");
                }
            }
            connection = null;
            statement = null;
            rs = null;
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select itemID, quantity from inventory where itemID = ?");
            statement.setInt(1, 1);
            rs = statement.executeQuery();
            quantity = -1;
            while (rs.next()) {
                quantity = rs.getInt("quantity");
            }
            if (quantity >= 1) break block9;
            InventoryRecord inventoryRecord2 = null;
            ConnectionHelper.cleanupConnection(connection, rs, statement);
            return inventoryRecord2;
        }
        try {
            ++this.readerIndex;
            this.inventoryCheckpoint.setInventoryCount(this.readerIndex);
            inventoryRecord = new InventoryRecord(1, quantity);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        ConnectionHelper.cleanupConnection(connection, rs, statement);
        return inventoryRecord;
    }

    @CheckpointInfo
    public InventoryCheckpointData getInventoryCheckpoint() {
        logger.finer("InventoryReader.getInventoryCheckpoint() index = " + this.inventoryCheckpoint.getInventoryCount());
        return this.inventoryCheckpoint;
    }
}

