/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.chunkartifacts;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.batch.annotation.ItemWriter;
import javax.batch.annotation.Open;
import javax.batch.annotation.WriteItems;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jsr352.tck.chunkartifacts.ConnectionHelper;
import jsr352.tck.chunktypes.InventoryCheckpointData;
import jsr352.tck.chunktypes.InventoryRecord;

@ItemWriter(value="InventoryInitWriter")
@Named(value="InventoryInitWriter")
public class InventoryInitWriter {
    protected DataSource dataSource = null;

    @Open
    public void openMe(InventoryCheckpointData cpd) throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/orderDB");
    }

    @WriteItems
    public void writeItem(List<InventoryRecord> records) throws SQLException {
        int itemID = -1;
        int quantity = -1;
        for (InventoryRecord record : records) {
            itemID = record.getItemID();
            quantity = record.getQuantity();
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("update inventory set quantity = ? where itemID = ?");
            statement.setInt(2, itemID);
            statement.setInt(1, quantity);
            int rs = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanupConnection(connection, null, statement);
                throw throwable;
            }
        }
        ConnectionHelper.cleanupConnection(connection, null, statement);
    }
}

