/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.chunkartifacts;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.batch.annotation.CheckpointInfo;
import javax.batch.annotation.ItemReader;
import javax.batch.annotation.Open;
import javax.batch.annotation.ReadItem;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jsr352.tck.chunkartifacts.ConnectionHelper;
import jsr352.tck.chunktypes.InventoryCheckpointData;
import jsr352.tck.chunktypes.InventoryRecord;

@ItemReader(value="InventoryInitReader")
public class InventoryInitReader {
    protected DataSource dataSource = null;
    private int count = 0;

    @Open
    public void openMe(InventoryCheckpointData cpd) throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/orderDB");
    }

    @ReadItem
    public InventoryRecord readItem() throws SQLException {
        InventoryRecord inventoryRecord;
        if (this.count > 0) {
            return null;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select itemID, quantity from inventory where itemID = ?");
            statement.setInt(1, 1);
            rs = statement.executeQuery();
            int quantity = -1;
            while (rs.next()) {
                quantity = rs.getInt("quantity");
                ++this.count;
            }
            inventoryRecord = new InventoryRecord(1, quantity);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        ConnectionHelper.cleanupConnection(connection, rs, statement);
        return inventoryRecord;
    }

    @CheckpointInfo
    public InventoryCheckpointData getCPD() {
        InventoryCheckpointData chkpData = new InventoryCheckpointData();
        chkpData.setInventoryCount(this.count);
        return chkpData;
    }
}

