/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.tck.bridge;

import com.ibm.batch.container.xjcl.ExecutionElement;
import com.ibm.batch.container.xjcl.ModelResolver;
import com.ibm.batch.container.xjcl.ModelResolverFactory;
import com.ibm.batch.container.xjcl.ModelSerializer;
import com.ibm.batch.container.xjcl.ModelSerializerFactory;
import com.ibm.batch.tck.spi.JSLInheritanceMerger;
import jsr352.batch.jsl.Chunk;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.JSLProperties;
import jsr352.batch.jsl.Listener;
import jsr352.batch.jsl.Listeners;
import jsr352.batch.jsl.ObjectFactory;
import jsr352.batch.jsl.Property;
import jsr352.batch.jsl.Step;

public class BatchContainerJSLMerger
implements JSLInheritanceMerger {
    public String mergeStep(String childJobXml, String parentStepXml, String childStepID) {
        JSLJob childJob = this.jobResolveHelper(childJobXml);
        Step parentStep = this.stepResolveHelper(parentStepXml);
        for (ExecutionElement elem : childJob.getExecutionElements()) {
            if (!(elem instanceof Step) || !parentStep.getId().equals(((Step)elem).getParent())) continue;
            childJob.getExecutionElements().remove(elem);
            childJob.getExecutionElements().add(this.mergeStep(parentStep, (Step)elem));
        }
        ModelSerializer serializer = ModelSerializerFactory.createJobModelSerializer();
        return serializer.serializeModel((Object)childJob);
    }

    public String mergeJob(String parentJobXML, String childJobXML) {
        JSLJob parentJob = this.jobResolveHelper(parentJobXML);
        JSLJob childJob = this.jobResolveHelper(childJobXML);
        if (parentJob != null && childJob != null) {
            JSLJob mergedJob = this.mergeJob(parentJob, childJob);
            ModelSerializer serializer = ModelSerializerFactory.createJobModelSerializer();
            return serializer.serializeModel((Object)mergedJob);
        }
        return childJobXML;
    }

    public JSLJob jobResolveHelper(String jobXML) {
        ModelResolver jobResolver = ModelResolverFactory.createJobResolver();
        JSLJob job = null;
        try {
            job = (JSLJob)jobResolver.resolveModel(jobXML);
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        return job;
    }

    public Step stepResolveHelper(String stepXML) {
        ModelResolver stepResolver = ModelResolverFactory.createStepResolver();
        Step step = null;
        try {
            step = (Step)stepResolver.resolveModel(stepXML);
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        return step;
    }

    public Step mergeStep(Step parent, Step child) {
        if (!parent.getId().equals(child.getParent())) {
            return child;
        }
        ObjectFactory factory = new ObjectFactory();
        Step merge = factory.createStep();
        merge.setId(child.getId());
        merge.setProperties(this.mergeProperties(parent.getProperties(), child.getProperties()));
        merge.setListeners(this.mergeListeners(parent.getListeners(), child.getListeners()));
        merge.getControlElements().addAll(parent.getControlElements());
        merge.setChunk(this.mergeChunk(parent.getChunk(), child.getChunk()));
        if (child.getBatchlet() != null && parent.getBatchlet() != null) {
            if ("true".equals(child.getBatchlet().getProperties().getMerge())) {
                // empty if block
            }
            merge.setBatchlet(parent.getBatchlet());
        }
        return merge;
    }

    public Chunk mergeChunk(Chunk parentChunk, Chunk childChunk) {
        if (parentChunk == null && childChunk != null) {
            return childChunk;
        }
        if (parentChunk != null && childChunk == null) {
            return parentChunk;
        }
        if (parentChunk == null && childChunk == null) {
            return null;
        }
        Chunk merge = new ObjectFactory().createChunk();
        merge.setProcessor(childChunk.getProcessor() == null ? parentChunk.getProcessor() : childChunk.getProcessor());
        merge.setReader(childChunk.getReader() == null ? parentChunk.getReader() : childChunk.getReader());
        merge.setRetryLimit(childChunk.getRetryLimit() == null ? parentChunk.getRetryLimit() : childChunk.getRetryLimit());
        merge.setSkipLimit(childChunk.getRetryLimit() == null ? parentChunk.getSkipLimit() : childChunk.getSkipLimit());
        merge.setWriter(childChunk.getWriter() == null ? parentChunk.getWriter() : childChunk.getWriter());
        merge.setCheckpointAlgorithm(childChunk.getCheckpointAlgorithm() == null ? parentChunk.getCheckpointAlgorithm() : childChunk.getCheckpointAlgorithm());
        merge.setSkippableExceptionClasses(childChunk.getSkippableExceptionClasses() == null ? parentChunk.getSkippableExceptionClasses() : childChunk.getSkippableExceptionClasses());
        merge.setRetryableExceptionClasses(childChunk.getRetryableExceptionClasses() == null ? parentChunk.getRetryableExceptionClasses() : childChunk.getRetryableExceptionClasses());
        merge.setNoRollbackExceptionClasses(childChunk.getNoRollbackExceptionClasses() == null ? parentChunk.getNoRollbackExceptionClasses() : childChunk.getNoRollbackExceptionClasses());
        return merge;
    }

    public JSLJob mergeJob(JSLJob parent, JSLJob child) {
        if (!parent.getId().equals(child.getParent())) {
            return child;
        }
        ObjectFactory factory = new ObjectFactory();
        JSLJob merge = factory.createJSLJob();
        merge.setId(child.getId());
        merge.setProperties(this.mergeProperties(parent.getProperties(), child.getProperties()));
        merge.setListeners(this.mergeListeners(parent.getListeners(), child.getListeners()));
        for (ExecutionElement pElem : parent.getExecutionElements()) {
            boolean hasCollidingId = false;
            ExecutionElement collidingChildElement = null;
            for (ExecutionElement cElem : child.getExecutionElements()) {
                if (!pElem.getId().equals(cElem.getId())) continue;
                hasCollidingId = true;
                collidingChildElement = cElem;
            }
            if (hasCollidingId) continue;
            child.getExecutionElements().add(pElem);
        }
        return merge;
    }

    private JSLProperties mergeProperties(JSLProperties parentProps, JSLProperties childProps) {
        if (parentProps == null) {
            return childProps;
        }
        if (childProps == null) {
            childProps = new JSLProperties();
        }
        if ("false".equals(childProps.getMerge())) {
            childProps.setMerge(null);
            return childProps;
        }
        JSLProperties mergedProps = new JSLProperties();
        mergedProps.getPropertyList().addAll(childProps.getPropertyList());
        for (Property parentProp : parentProps.getPropertyList()) {
            boolean foundParentProp = false;
            for (Property childProp : childProps.getPropertyList()) {
                if (parentProp.getName() == null || !parentProp.getName().equals(childProp.getName())) continue;
                foundParentProp = true;
            }
            if (foundParentProp) continue;
            mergedProps.getPropertyList().add(parentProp);
        }
        return mergedProps;
    }

    private Listeners mergeListeners(Listeners parentListeners, Listeners childListeners) {
        if (parentListeners == null) {
            return childListeners;
        }
        if (childListeners == null) {
            childListeners = new Listeners();
        }
        if ("false".equals(childListeners.getMerge())) {
            childListeners.setMerge(null);
            return childListeners;
        }
        Listeners mergedListeners = new Listeners();
        mergedListeners.getListenerList().addAll(childListeners.getListenerList());
        for (Listener parentListener : parentListeners.getListenerList()) {
            boolean foundParentListener = false;
            for (Listener childListener : childListeners.getListenerList()) {
                if (parentListener.getRef() == null || !parentListener.getRef().equals(childListener.getRef())) continue;
                foundParentListener = true;
            }
            if (foundParentListener) continue;
            mergedListeners.getListenerList().add(parentListener);
        }
        return mergedListeners;
    }
}

