/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services;

import com.ibm.batch.container.config.DatabaseConfigurationBean;
import com.ibm.batch.container.config.GlassfishThreadPoolConfigurationBean;
import com.ibm.batch.container.config.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.impl.BatchConfigImpl;
import com.ibm.batch.container.services.IBatchServiceBase;
import com.ibm.batch.container.services.IBatchThreadPoolService;
import com.ibm.batch.container.services.impl.GlassfishThreadPoolServiceImpl;
import com.ibm.batch.container.util.BatchContainerConstants;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServicesManager
implements BatchContainerConstants {
    private static final String sourceClass = ServicesManager.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private boolean isInited = false;
    private Properties batchContainerProps = null;
    private static ServicesManager servicesManager;
    private IBatchConfig batchRuntimeConfig = null;
    private static final String DEFAULT_PERSISTENCE_MGR_CLASS = "com.ibm.batch.container.services.impl.JDBCPersistenceManagerImpl";
    private static final String DEFAULT_BATCH_THREADPOOL_SERVICE = "com.ibm.batch.container.services.impl.JSEThreadPoolServiceImpl";
    private static final String DEFAULT_CONTAINER_ARTIFACT_FACTORY_SERVICE = "com.ibm.batch.container.services.impl.DelegatingBatchArtifactFactoryImpl";
    private static final String DEFAULT_BATCH_KERNEL_SERVICE = "com.ibm.batch.container.impl.BatchKernelImpl";
    private static final String DEFAULT_JOBSTATUS_MGR_SERVICE = "com.ibm.batch.container.services.impl.JobStatusManagerImpl";
    private static final String DEFAULT_JOBID_MGR_SERVICE = "com.ibm.batch.container.services.impl.JobIdManagerImpl";
    private static final String DEFAULT_CALLBACK_SERVICE = "com.ibm.batch.container.tck.bridge.JobEndCallbackManagerImpl";
    private static final String DEFAULT_TRANSACTION_SERVICE = "com.ibm.batch.container.services.impl.BatchTransactionServiceImpl";
    private static final String DEFAULT_JOBXML_LOADER_SERVICE = "com.ibm.batch.container.services.impl.DelegatingJobXMLLoaderServiceImpl";
    private static final String DEFAULT_JAVA_EDITION_IS_SE_DUMMY_SERVICE = "false";
    private ConcurrentHashMap<ServiceType, IBatchServiceBase> serviceRegistry = new ConcurrentHashMap();
    private Map<ServiceType, String> serviceImplClassNames = new ConcurrentHashMap<ServiceType, String>();
    private Map<String, ServiceType> propertyNameTable = new ConcurrentHashMap<String, ServiceType>();
    public static final String PERSISTENCE_MANAGEMENT_SERVICE = "PERSISTENCE_MANAGEMENT_SERVICE";
    public static final String JOB_STATUS_MANAGEMENT_SERVICE = "JOB_STATUS_MANAGEMENT_SERVICE";
    public static final String BATCH_THREADPOOL_SERVICE = "BATCH_THREADPOOL_SERVICE";
    public static final String CONFIGURATION_SERVICE = "CONFIGURATION_SERVICE";
    public static final String CONTAINER_LOGGER_CONFIG_SERVICE = "CONTAINER_LOGGER_CONFIG_SERVICE";
    public static final String CONTAINER_ARTIFACT_FACTORY_SERVICE = "CONTAINER_ARTIFACT_FACTORY_SERVICE";
    public static final String DELEGATING_ARTIFACT_FACTORY_SERVICE = "DELEGATING_ARTIFACT_FACTORY_SERVICE";
    public static final String BATCH_KERNEL_SERVICE = "BATCH_KERNEL_SERVICE";
    public static final String JOB_ID_MANAGEMENT_SERVICE = "JOB_ID_MANAGEMENT_SERVICE";
    public static final String CALLBACK_SERVICE = "CALLBACK_SERVICE";
    public static final String TRANSACTION_SERVICE = "TRANSACTION_SERVICE";
    public static final String JOBXML_LOADER_SERVICE = "JOBXML_LOADER_SERVICE";
    public static final String DELEGATING_JOBXML_LOADER_SERVICE = "DELEGATING_JOBXML_LOADER_SERVICE";
    public static final String J2SE_MODE = "J2SE_MODE";

    private ServicesManager() {
        this.init();
    }

    private void populateServicePropertyNameTable() {
        for (ServiceType s : ServiceType.values()) {
            if (s.equals((Object)ServiceType.TRANSACTION_SERVICE)) {
                this.propertyNameTable.put(TRANSACTION_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.PERSISTENCE_MANAGEMENT_SERVICE)) {
                this.propertyNameTable.put(PERSISTENCE_MANAGEMENT_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.JOB_STATUS_MANAGEMENT_SERVICE)) {
                this.propertyNameTable.put(JOB_STATUS_MANAGEMENT_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.BATCH_THREADPOOL_SERVICE)) {
                this.propertyNameTable.put(BATCH_THREADPOOL_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.CONTAINER_ARTIFACT_FACTORY_SERVICE)) {
                this.propertyNameTable.put(CONTAINER_ARTIFACT_FACTORY_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.DELEGATING_ARTIFACT_FACTORY_SERVICE)) {
                this.propertyNameTable.put(DELEGATING_ARTIFACT_FACTORY_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.BATCH_KERNEL_SERVICE)) {
                this.propertyNameTable.put(BATCH_KERNEL_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.JOB_ID_MANAGEMENT_SERVICE)) {
                this.propertyNameTable.put(JOB_ID_MANAGEMENT_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.CALLBACK_SERVICE)) {
                this.propertyNameTable.put(CALLBACK_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.JOBXML_LOADER_SERVICE)) {
                this.propertyNameTable.put(JOBXML_LOADER_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.DELEGATING_JOBXML_LOADER_SERVICE)) {
                this.propertyNameTable.put(DELEGATING_JOBXML_LOADER_SERVICE, s);
                continue;
            }
            if (s.equals((Object)ServiceType.JAVA_EDITION_IS_SE_DUMMY_SERVICE)) {
                this.propertyNameTable.put(J2SE_MODE, s);
                continue;
            }
            if (!logger.isLoggable(Level.WARNING)) continue;
            logger.warning("Configuration lacks a definition of property key for service type: " + (Object)((Object)s));
        }
    }

    private void registerDefaultServiceImpls() {
        for (ServiceType s : ServiceType.values()) {
            if (s.equals((Object)ServiceType.TRANSACTION_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_TRANSACTION_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.PERSISTENCE_MANAGEMENT_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_PERSISTENCE_MGR_CLASS);
                continue;
            }
            if (s.equals((Object)ServiceType.JOB_STATUS_MANAGEMENT_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_JOBSTATUS_MGR_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.BATCH_THREADPOOL_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_BATCH_THREADPOOL_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.CONTAINER_ARTIFACT_FACTORY_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_CONTAINER_ARTIFACT_FACTORY_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.DELEGATING_ARTIFACT_FACTORY_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_CONTAINER_ARTIFACT_FACTORY_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.BATCH_KERNEL_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_BATCH_KERNEL_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.JOB_ID_MANAGEMENT_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_JOBID_MGR_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.CALLBACK_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_CALLBACK_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.JOBXML_LOADER_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_JOBXML_LOADER_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.DELEGATING_JOBXML_LOADER_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_JOBXML_LOADER_SERVICE);
                continue;
            }
            if (s.equals((Object)ServiceType.JAVA_EDITION_IS_SE_DUMMY_SERVICE)) {
                this.serviceImplClassNames.put(s, DEFAULT_JAVA_EDITION_IS_SE_DUMMY_SERVICE);
                continue;
            }
            if (!logger.isLoggable(Level.WARNING)) continue;
            logger.warning("Configuration lacks a default value for service type: " + (Object)((Object)s));
        }
    }

    private void init() {
        String sourceMethod = "init";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod);
        }
        if (!this.isInited) {
            this.batchRuntimeConfig = new BatchConfigImpl();
            this.registerDefaultServiceImpls();
            this.populateServicePropertyNameTable();
            this.loadBatchConfigPropertiesFiles();
            this.loadServiceImplOverrides();
            this.loadDatabaseConfig();
            this.loadGlassfishThreadPoolConfig();
            this.loadOtherConfig();
            this.isInited = true;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    private void loadBatchConfigPropertiesFiles() {
        Properties serviceIntegratorProps = new Properties();
        InputStream batchServicesListInputStream = this.getClass().getResourceAsStream("/META-INF/services/batch-services.properties");
        if (batchServicesListInputStream != null) {
            try {
                logger.fine("Batch Integrator Config File exists! loading it..");
                serviceIntegratorProps.load(batchServicesListInputStream);
                batchServicesListInputStream.close();
            }
            catch (IOException e) {
                logger.info("Error loading /META-INF/services/batch-services.properties IOException=" + e.toString());
            }
            catch (Exception e) {
                logger.info("Error loading /META-INF/services/batch-services.properties Exception=" + e.toString());
            }
        } else {
            logger.info("Could not find batch integrator config file: /META-INF/services/batch-services.properties");
        }
        HashSet<String> removeThese = new HashSet<String>();
        for (Object key : serviceIntegratorProps.keySet()) {
            String keyStr = (String)key;
            if (this.propertyNameTable.containsKey(keyStr)) continue;
            logger.warning("Found property named: " + keyStr + " with value: " + serviceIntegratorProps.get(keyStr) + " in " + "batch-services.properties" + " , but did not find a corresponding service type " + "in the internal table of service types.\n Ignoring this property then.   Maybe this should have been set in batch-config.properties instead.");
            removeThese.add(keyStr);
        }
        for (String s : removeThese) {
            serviceIntegratorProps.remove(s);
        }
        Properties adminProps = new Properties();
        InputStream batchAdminConfigListInputStream = this.getClass().getResourceAsStream("/META-INF/services/batch-config.properties");
        if (batchServicesListInputStream != null) {
            try {
                logger.fine("Batch Admin Config File exists! loading it..");
                adminProps.load(batchAdminConfigListInputStream);
                batchAdminConfigListInputStream.close();
            }
            catch (IOException e) {
                logger.info("Error loading /META-INF/services/batch-config.properties IOException=" + e.toString());
            }
            catch (Exception e) {
                logger.info("Error loading /META-INF/services/batch-config.properties Exception=" + e.toString());
            }
        } else {
            logger.info("Could not find batch admin config file: /META-INF/services/batch-config.properties");
        }
        HashSet removeTheseToo = new HashSet();
        for (Object key : adminProps.keySet()) {
            String keyStr = (String)key;
            if (!this.propertyNameTable.containsKey(keyStr)) continue;
            logger.warning("Found property named: " + keyStr + " with value: " + adminProps.get(keyStr) + " in " + "batch-config.properties" + " , but this is a batch runtime service configuration.\n" + "Ignoring this property then, since this should have been set in batch-services.properties instead.");
            removeThese.add(keyStr);
        }
        for (String s : removeTheseToo) {
            adminProps.remove(s);
        }
        this.batchContainerProps = new Properties();
        this.batchContainerProps.putAll((Map<?, ?>)adminProps);
        this.batchContainerProps.putAll((Map<?, ?>)serviceIntegratorProps);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Dumping contents of batchContainerProps after reading properties files.");
            for (Object key : this.batchContainerProps.keySet()) {
                logger.fine("key = " + key);
                logger.fine("value = " + this.batchContainerProps.get(key));
            }
        }
    }

    private void loadServiceImplOverrides() {
        for (String propKey : this.propertyNameTable.keySet()) {
            String value = this.batchContainerProps.getProperty(propKey);
            if (value == null) continue;
            ServiceType serviceType = this.propertyNameTable.get(propKey);
            this.serviceImplClassNames.put(serviceType, value.trim());
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Overriding serviceType: " + (Object)((Object)serviceType) + " with impl class name: " + value.trim());
        }
    }

    private void loadDatabaseConfig() {
        DatabaseConfigurationBean databaseConfigBean = new DatabaseConfigurationBean();
        this.batchRuntimeConfig.setDatabaseConfigurationBean(databaseConfigBean);
        databaseConfigBean.setJndiName(this.batchContainerProps.getProperty("JNDI_NAME", "jdbc/batch"));
        databaseConfigBean.setJdbcDriver(this.batchContainerProps.getProperty("JDBC_DRIVER", "org.apache.derby.jdbc.EmbeddedDriver"));
        databaseConfigBean.setJdbcUrl(this.batchContainerProps.getProperty("JDBC_URL", "jdbc:derby:RUNTIMEDB;create=true"));
        databaseConfigBean.setDbUser(this.batchContainerProps.getProperty("DB_USER"));
        databaseConfigBean.setDbPassword(this.batchContainerProps.getProperty("DB_PWD"));
        databaseConfigBean.setSchema(this.batchContainerProps.getProperty("DB_SCHEMA", "JBATCH"));
    }

    private void loadGlassfishThreadPoolConfig() {
        GlassfishThreadPoolConfigurationBean threadPoolConfigBean = new GlassfishThreadPoolConfigurationBean();
        this.batchRuntimeConfig.setGlassfishThreadPoolConfigurationBean(threadPoolConfigBean);
        threadPoolConfigBean.setIdleThreadTimeout(Integer.parseInt(this.batchContainerProps.getProperty("GLASSFISH_THREADPOOL_IDLE_THREAD_TIMEOUT", "900")));
        threadPoolConfigBean.setMaxQueueSize(Integer.parseInt(this.batchContainerProps.getProperty("GLASSFISH_THREADPOOL_MAX_QUEUE_SIZE", "4096")));
        threadPoolConfigBean.setMaxThreadPoolSize(Integer.parseInt(this.batchContainerProps.getProperty("GLASSFISH_THREADPOOL_MAX_POOL_SIZE", "5")));
        threadPoolConfigBean.setMinThreadPoolSize(Integer.parseInt(this.batchContainerProps.getProperty("GLASSFISH_THREADPOOL_MIN_POOL_SIZE", "2")));
    }

    private void loadOtherConfig() {
        String workManagerJNDI;
        String seMode = this.serviceImplClassNames.get((Object)ServiceType.JAVA_EDITION_IS_SE_DUMMY_SERVICE);
        if (seMode.equalsIgnoreCase("true")) {
            this.batchRuntimeConfig.setJ2seMode(true);
        }
        if ((workManagerJNDI = this.batchContainerProps.getProperty("WORK_MANAGER_JNDI_NAME")) != null) {
            this.batchRuntimeConfig.setWorkManagerJndiName(workManagerJNDI.trim());
        }
    }

    public void shutdown() {
        String sourceMethod = "shutdown";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    public IBatchServiceBase getService(ServiceType serviceType) throws BatchContainerServiceException {
        String sourceMethod = "getService";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod + ", serviceType=" + (Object)((Object)serviceType));
        }
        IBatchServiceBase service = null;
        if (!this.isInited) {
            Exception e = new Exception("ServicesManager not inited!");
            throw new BatchContainerServiceException("ServicesManager not inited!", e);
        }
        service = this._getServiceHelper(serviceType);
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBatchServiceBase _getServiceHelper(ServiceType serviceType) {
        IBatchServiceBase service = this.serviceRegistry.get((Object)serviceType);
        if (service == null) {
            ServicesManager servicesManager = this;
            synchronized (servicesManager) {
                service = this.serviceRegistry.get((Object)serviceType);
                if (service == null) {
                    service = this._loadServiceHelper(serviceType);
                    service.init(this.batchRuntimeConfig);
                    this.serviceRegistry.putIfAbsent(serviceType, service);
                }
            }
        }
        return service;
    }

    private IBatchServiceBase _loadServiceHelper(ServiceType serviceType) {
        IBatchServiceBase service = null;
        Throwable e = null;
        String className = this.serviceImplClassNames.get((Object)serviceType);
        try {
            if (className != null) {
                service = this._loadService(className);
            }
        }
        catch (Throwable e1) {
            e = e1;
            if (logger != null) {
                logger.log(Level.WARNING, "Could not instantiate service: " + className + " due to exception:" + e);
            }
            throw new RuntimeException("Could not instantiate service " + className + " due to exception: " + e);
        }
        if (service == null) {
            throw new RuntimeException("Instantiate of service=: " + className + " returned null. Aborting...");
        }
        return service;
    }

    private IBatchServiceBase _loadService(String className) throws Exception {
        Constructor<?> ctor;
        IBatchServiceBase service = null;
        Class<?> cls = Class.forName(className);
        if (cls != null) {
            ctor = cls.getConstructor(new Class[0]);
            if (ctor == null) {
                throw new Exception("Service class " + className + " should  have a default constructor defined");
            }
        } else {
            throw new Exception("Exception loading Service class " + className + " make sure it exists");
        }
        service = (IBatchServiceBase)ctor.newInstance(new Object[0]);
        return service;
    }

    public IBatchConfig getBatchRuntimeConfiguration() {
        return this.batchRuntimeConfig;
    }

    public void updateGlassfishThreadPoolConfiguration(GlassfishThreadPoolConfigurationBean config) {
        IBatchThreadPoolService threadPoolService = (IBatchThreadPoolService)this.serviceRegistry.get((Object)ServiceType.BATCH_THREADPOOL_SERVICE);
        if (threadPoolService == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("In method: updateGlassfishThreadPoolConfiguration. Thread pool service not initialized yet, so simply updating the config.");
                logger.info("Glassfish thread pool settings: (" + config.getMinThreadPoolSize() + "," + config.getMaxThreadPoolSize() + "," + config.getIdleThreadTimeout() + "," + (Object)((Object)TimeUnit.SECONDS) + "," + config.getMaxQueueSize() + ")");
            }
            this.batchRuntimeConfig.setGlassfishThreadPoolConfigurationBean(config);
        } else if (threadPoolService instanceof GlassfishThreadPoolServiceImpl) {
            GlassfishThreadPoolServiceImpl tps = (GlassfishThreadPoolServiceImpl)threadPoolService;
            tps.updateConfig(config);
        }
    }

    public static synchronized ServicesManager getInstance() throws BatchContainerServiceException {
        if (servicesManager == null) {
            servicesManager = new ServicesManager();
        }
        return servicesManager;
    }

    public static enum ServiceType {
        TRANSACTION_SERVICE,
        PERSISTENCE_MANAGEMENT_SERVICE,
        JOB_STATUS_MANAGEMENT_SERVICE,
        BATCH_THREADPOOL_SERVICE,
        CONTAINER_ARTIFACT_FACTORY_SERVICE,
        DELEGATING_ARTIFACT_FACTORY_SERVICE,
        BATCH_KERNEL_SERVICE,
        JOB_ID_MANAGEMENT_SERVICE,
        CALLBACK_SERVICE,
        JAVA_EDITION_IS_SE_DUMMY_SERVICE,
        DELEGATING_JOBXML_LOADER_SERVICE,
        JOBXML_LOADER_SERVICE;

    }
}

