/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.persistence;

import com.ibm.batch.container.artifact.proxy.CheckpointAlgorithmProxy;
import com.ibm.batch.container.artifact.proxy.InjectionReferences;
import com.ibm.batch.container.artifact.proxy.ProxyFactory;
import com.ibm.batch.container.persistence.ItemCheckpointAlgorithm;
import com.ibm.batch.container.persistence.ItemTimeCheckpointAlgorithm;
import com.ibm.batch.container.persistence.TimeCheckpointAlgorithm;
import com.ibm.batch.container.validation.ArtifactValidationException;
import jsr352.batch.jsl.Chunk;
import jsr352.batch.jsl.Step;

public class CheckpointAlgorithmFactory {
    public static CheckpointAlgorithmProxy getCheckpointAlgorithmProxy(Step step, InjectionReferences injectionReferences) throws ArtifactValidationException {
        Chunk chunk = step.getChunk();
        CheckpointAlgorithmProxy proxy = null;
        String checkpointType = chunk.getCheckpointPolicy();
        if (checkpointType.equals("item")) {
            proxy = new CheckpointAlgorithmProxy(new ItemCheckpointAlgorithm());
        } else if (checkpointType.equalsIgnoreCase("time")) {
            proxy = new CheckpointAlgorithmProxy(new TimeCheckpointAlgorithm());
        } else if (checkpointType.equalsIgnoreCase("custom")) {
            proxy = chunk.getCheckpointAlgorithm().getRef() == null ? new CheckpointAlgorithmProxy(new ItemTimeCheckpointAlgorithm()) : ProxyFactory.createCheckpointAlgorithmProxy(chunk.getCheckpointAlgorithm().getRef(), injectionReferences);
        }
        return proxy;
    }
}

