/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.jobinstance;

import com.ibm.batch.container.context.impl.JobContextImpl;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.services.impl.JDBCPersistenceManagerImpl;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.JobExecution;

public class JobOperatorJobExecutionImpl
implements JobExecution {
    private static final String sourceClass = JobOperatorJobExecutionImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static ServicesManager servicesManager = ServicesManager.getInstance();
    private static IPersistenceManagerService _persistenceManagementService = (IPersistenceManagerService)servicesManager.getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
    private long executionID = 0L;
    private long instanceID = 0L;
    Timestamp createTime;
    Timestamp startTime;
    Timestamp endTime;
    Timestamp updateTime;
    Properties parameters;
    String batchStatus;
    String exitStatus;
    Properties jobProperties = null;
    private JobContextImpl<?> jobcontext = null;

    public JobOperatorJobExecutionImpl(long executionId, long instanceId, JobContextImpl<?> jobContext) {
        this.executionID = executionId;
        this.instanceID = instanceId;
        this.jobcontext = jobContext;
    }

    public JobOperator.BatchStatus getBatchStatus() {
        JobOperator.BatchStatus batchStatus = null;
        if (this.jobcontext != null) {
            batchStatus = this.jobcontext.getBatchStatus();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning batch status of: " + batchStatus + " from JobContext.");
            }
        } else {
            if (!(_persistenceManagementService instanceof JDBCPersistenceManagerImpl)) {
                throw new UnsupportedOperationException("Only JDBC-based persistence currently supported for this function.");
            }
            batchStatus = JobOperator.BatchStatus.valueOf((String)((JDBCPersistenceManagerImpl)_persistenceManagementService).jobOperatorQueryJobExecutionStatus(this.executionID, "batchstatus"));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning batch status of: " + batchStatus + " from JobContext.");
            }
        }
        return batchStatus;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getExecutionId() {
        return this.executionID;
    }

    public String getExitStatus() {
        if (this.jobcontext != null) {
            return this.jobcontext.getExitStatus();
        }
        if (_persistenceManagementService instanceof JDBCPersistenceManagerImpl) {
            this.exitStatus = ((JDBCPersistenceManagerImpl)_persistenceManagementService).jobOperatorQueryJobExecutionStatus(this.executionID, "exitstatus");
        }
        return this.exitStatus;
    }

    public long getInstanceId() {
        return this.instanceID;
    }

    public Date getLastUpdatedTime() {
        return this.updateTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Properties getJobParameters() {
        return this.jobProperties;
    }

    public void setBatchStatus(String status) {
        this.batchStatus = status;
    }

    public void setCreateTime(Timestamp ts) {
        this.createTime = ts;
    }

    public void setEndTime(Timestamp ts) {
        this.endTime = ts;
    }

    public void setExecutionId(long id) {
        this.executionID = id;
    }

    public void setJobInstanceId(long jobInstanceID) {
        this.instanceID = jobInstanceID;
    }

    public void setExitStatus(String status) {
        this.exitStatus = status;
    }

    public void setInstanceId(long id) {
        this.instanceID = id;
    }

    public void setLastUpdateTime(Timestamp ts) {
        this.updateTime = ts;
    }

    public void setStartTime(Timestamp ts) {
        this.startTime = ts;
    }

    public void setJobProperties(Properties jProps) {
        this.jobProperties = jProps;
    }
}

