/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.artifact.proxy.SkipProcessListenerProxy;
import com.ibm.batch.container.artifact.proxy.SkipReadListenerProxy;
import com.ibm.batch.container.artifact.proxy.SkipWriteListenerProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Chunk;
import jsr352.batch.jsl.ExceptionClassFilter;

public class SkipHandler<T> {
    private static final String className = SkipHandler.class.getName();
    private static Logger logger = Logger.getLogger(SkipHandler.class.getPackage().getName());
    public static final String SKIP_COUNT = "skip-limit";
    public static final String SKIP_INCLUDE_EX = "include class";
    public static final String SKIP_EXCLUDE_EX = "exclude class";
    private List<SkipProcessListenerProxy> _skipProcessListener = null;
    private List<SkipReadListenerProxy> _skipReadListener = null;
    private List<SkipWriteListenerProxy> _skipWriteListener = null;
    private long _jobId = 0L;
    private String _stepId = null;
    private Set<String> _skipIncludeExceptions = null;
    private Set<String> _skipExcludeExceptions = null;
    private int _skipLimit = 0;
    private long _skipCount = 0L;
    private Exception _skipException = null;

    public SkipHandler(Chunk chunk, long l, String stepId) {
        this._jobId = l;
        this._stepId = stepId;
        this.initialize(chunk);
    }

    public void addSkipReadListener(List<SkipReadListenerProxy> skipReadListener) {
        this._skipReadListener = skipReadListener;
    }

    public void addSkipWriteListener(List<SkipWriteListenerProxy> skipWriteListener) {
        this._skipWriteListener = skipWriteListener;
    }

    public void addSkipProcessListener(List<SkipProcessListenerProxy> skipProcessListener) {
        this._skipProcessListener = skipProcessListener;
    }

    private void initialize(Chunk chunk) {
        String mName = "initialize";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "initialize");
        }
        try {
            if (chunk.getSkipLimit() != null) {
                this._skipLimit = Integer.parseInt(chunk.getSkipLimit());
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("NumberFormatException reading skip-limit", nfe);
        }
        if (this._skipLimit > 0) {
            this._skipIncludeExceptions = new HashSet<String>();
            this._skipExcludeExceptions = new HashSet<String>();
            boolean done = false;
            String includeEx = null;
            String excludeEx = null;
            if (chunk.getSkippableExceptionClasses() != null && chunk.getSkippableExceptionClasses().getIncludeList() != null) {
                List includes = chunk.getSkippableExceptionClasses().getIncludeList();
                if (includes.size() > 1) {
                    String msg = "TODO: Do not currently support >1 <include> element, even though spec allows this.";
                    logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                if (includes.size() == 1) {
                    includeEx = ((ExceptionClassFilter.Include)includes.get(0)).getClazz();
                    logger.finer("SKIPHANDLE: include: " + includeEx);
                } else {
                    logger.finer("SKIPHANDLE: include element not present");
                }
            }
            if (chunk.getSkippableExceptionClasses() != null && chunk.getSkippableExceptionClasses().getExcludeList() != null) {
                List excludes = chunk.getSkippableExceptionClasses().getExcludeList();
                if (excludes.size() > 1) {
                    String msg = "TODO: Do not currently support >1 <exclude> element, even though spec allows this.";
                    logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                if (excludes.size() == 1) {
                    excludeEx = ((ExceptionClassFilter.Exclude)excludes.get(0)).getClazz();
                    logger.finer("SKIPHANDLE: exclude: " + excludeEx);
                } else {
                    logger.finer("SKIPHANDLE: exclude element not present");
                }
            }
            if (includeEx != null) {
                this._skipIncludeExceptions.add(includeEx.trim());
            }
            if (excludeEx != null) {
                this._skipExcludeExceptions.add(excludeEx.trim());
            }
            boolean bl = done = includeEx == null && excludeEx == null;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, className, "initialize", "added include exception " + includeEx + "; added exclude exception " + excludeEx);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "initialize", this.toString());
        }
    }

    public void handleExceptionRead(Exception e) {
        String mName = "handleException";
        logger.finer("SKIPHANDLE: in skiphandler handle exception on a read");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleException", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isSkipLimitReached() && this.isSkippable(e)) {
            ++this._skipCount;
            this.logSkip(e);
            if (this._skipReadListener != null) {
                for (SkipReadListenerProxy skipReadListenerProxy : this._skipReadListener) {
                    skipReadListenerProxy.onSkipReadItem(e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleException", "No skip.  Rethrow", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "handleException", e);
        }
    }

    public void handleExceptionWithRecordProcess(Exception e, Object w) {
        String mName = "handleExceptionWithRecordProcess";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionWithRecordProcess", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isSkipLimitReached() && this.isSkippable(e)) {
            ++this._skipCount;
            this.logSkip(e);
            if (this._skipProcessListener != null) {
                for (SkipProcessListenerProxy skipProcessListenerProxy : this._skipProcessListener) {
                    skipProcessListenerProxy.onSkipProcessItem(w, e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionWithRecordProcess", "No skip.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
    }

    public void handleExceptionWithRecordListWrite(Exception e, List<T> items) {
        String mName = "handleExceptionWithRecordListWrite(Exception, List<T>)";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionWithRecordListWrite(Exception, List<T>)", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isSkipLimitReached() && this.isSkippable(e)) {
            ++this._skipCount;
            this.logSkip(e);
            if (this._skipWriteListener != null) {
                for (SkipWriteListenerProxy skipWriteListenerProxy : this._skipWriteListener) {
                    skipWriteListenerProxy.onSkipWriteItem(items, e);
                }
            }
        } else {
            System.out.println("## NO SKIP");
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionWithRecordListWrite(Exception, List<T>)", "No skip.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
    }

    private boolean isSkippable(Exception e) {
        boolean retVal;
        String mName = "isSkippable";
        String exClassName = e.getClass().getName();
        boolean bl = retVal = (this._skipIncludeExceptions.isEmpty() || this.containsSkippable(this._skipIncludeExceptions, e)) && !this.containsSkippable(this._skipExcludeExceptions, e);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "isSkippable", "isSkippable: " + retVal + ": " + exClassName);
        }
        return retVal;
    }

    private boolean containsSkippable(Set<String> skipList, Exception e) {
        String mName = "containsSkippable";
        boolean retVal = false;
        for (String exClassName : skipList) {
            try {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                retVal = tccl.loadClass(exClassName).isInstance(e);
                if (!retVal) continue;
                break;
            }
            catch (ClassNotFoundException cnf) {
                logger.logp(Level.FINE, className, "containsSkippable", cnf.getLocalizedMessage());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "containsSkippable", "containsSkippable: " + retVal);
        }
        return retVal;
    }

    private boolean isSkipLimitReached() {
        return this._skipCount >= (long)this._skipLimit;
    }

    private void logSkip(Exception e) {
        String key = "record.skipped.by.batch.data.stream";
        Object[] details = new Object[]{this._jobId, this._stepId, e.getClass().getName() + ": " + e.getMessage()};
    }

    public long getSkipCount() {
        return this._skipCount;
    }

    public void setSkipCount(long skipCount) {
        String mName = "setSkipCount";
        this._skipCount = skipCount;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "setSkipCount", "setSkipCount: " + this._skipCount);
        }
    }

    public String toString() {
        return "SkipHandler{" + super.toString() + "}count:limit=" + this._skipCount + ":" + this._skipLimit;
    }
}

