/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.artifact.proxy.RetryProcessListenerProxy;
import com.ibm.batch.container.artifact.proxy.RetryReadListenerProxy;
import com.ibm.batch.container.artifact.proxy.RetryWriteListenerProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Chunk;
import jsr352.batch.jsl.ExceptionClassFilter;

public class RetryHandler {
    private static final String className = RetryHandler.class.getName();
    private static Logger logger = Logger.getLogger(RetryHandler.class.getPackage().getName());
    public static final String RETRY_COUNT = "retry-limit";
    public static final String RETRY_INCLUDE_EX = "include class";
    public static final String RETRY_EXCLUDE_EX = "exclude class";
    private static final int RETRY_NONE = 0;
    private static final int RETRY_READ = 1;
    private static final int RETRY_PROCESS = 2;
    private static final int RETRY_WRITE = 3;
    private int retryType = 0;
    List<RetryProcessListenerProxy> _retryProcessListeners = null;
    List<RetryReadListenerProxy> _retryReadListeners = null;
    List<RetryWriteListenerProxy> _retryWriteListeners = null;
    private long _jobId = 0L;
    private String _stepId = null;
    private Set<String> _retryNoRBIncludeExceptions = null;
    private Set<String> _retryNoRBExcludeExceptions = null;
    private Set<String> _retryIncludeExceptions = null;
    private Set<String> _retryExcludeExceptions = null;
    private int _retryLimit = 0;
    private long _retryCount = 0L;
    private Exception _retryException = null;

    public RetryHandler(Chunk chunk, long l, String stepId) {
        this._jobId = l;
        this._stepId = stepId;
        this.initialize(chunk);
    }

    public void addRetryProcessListener(List<RetryProcessListenerProxy> retryProcessListeners) {
        this._retryProcessListeners = retryProcessListeners;
    }

    public void addRetryReadListener(List<RetryReadListenerProxy> retryReadListeners) {
        this._retryReadListeners = retryReadListeners;
    }

    public void addRetryWriteListener(List<RetryWriteListenerProxy> retryWriteListeners) {
        this._retryWriteListeners = retryWriteListeners;
    }

    private void initialize(Chunk chunk) {
        String mName = "initialize";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "initialize");
        }
        try {
            if (chunk.getRetryLimit() != null) {
                this._retryLimit = Integer.parseInt(chunk.getRetryLimit());
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("NumberFormatException reading retry-limit", nfe);
        }
        if (this._retryLimit > 0) {
            List excludes;
            List includes;
            this._retryIncludeExceptions = new HashSet<String>();
            this._retryExcludeExceptions = new HashSet<String>();
            this._retryNoRBIncludeExceptions = new HashSet<String>();
            this._retryNoRBExcludeExceptions = new HashSet<String>();
            String includeEx = null;
            String excludeEx = null;
            String includeExNoRB = null;
            String excludeExNoRB = null;
            if (chunk.getRetryableExceptionClasses() != null) {
                if (chunk.getRetryableExceptionClasses().getIncludeList() != null) {
                    includes = chunk.getRetryableExceptionClasses().getIncludeList();
                    if (includes.size() > 1) {
                        String msg = "TODO: Do not currently support >1 <include> element, even though spec allows this.";
                        logger.severe(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    if (includes.size() == 1) {
                        includeEx = ((ExceptionClassFilter.Include)includes.get(0)).getClazz();
                        logger.finer("RETRYHANDLE: include: " + includeEx);
                    } else {
                        logger.finer("RETRYHANDLE: include element not present");
                    }
                }
                if (chunk.getRetryableExceptionClasses().getExcludeList() != null) {
                    excludes = chunk.getRetryableExceptionClasses().getExcludeList();
                    if (excludes.size() > 1) {
                        String msg = "TODO: Do not currently support >1 <exclude> element, even though spec allows this.";
                        logger.severe(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    if (excludes.size() == 1) {
                        excludeEx = ((ExceptionClassFilter.Exclude)excludes.get(0)).getClazz();
                        logger.finer("RETRYHANDLE: exclude: " + excludeEx);
                    } else {
                        logger.finer("RETRYHANDLE: exclude element not present");
                    }
                }
            }
            if (chunk.getNoRollbackExceptionClasses() != null) {
                if (chunk.getNoRollbackExceptionClasses().getIncludeList() != null) {
                    includes = chunk.getNoRollbackExceptionClasses().getIncludeList();
                    if (includes.size() > 1) {
                        String msg = "TODO: Do not currently support >1 <include> element, even though spec allows this.";
                        logger.severe(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    if (includes.size() == 1) {
                        includeExNoRB = ((ExceptionClassFilter.Include)includes.get(0)).getClazz();
                        logger.finer("RETRYHANDLE: include no rollback: " + includeExNoRB);
                    } else {
                        logger.finer("RETRYHANDLE: include element not present");
                    }
                }
                if (chunk.getNoRollbackExceptionClasses().getExcludeList() != null) {
                    excludes = chunk.getNoRollbackExceptionClasses().getExcludeList();
                    if (excludes.size() > 1) {
                        String msg = "TODO: Do not currently support >1 <exclude> element, even though spec allows this.";
                        logger.severe(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    if (excludes.size() == 1) {
                        excludeExNoRB = ((ExceptionClassFilter.Exclude)excludes.get(0)).getClazz();
                        logger.finer("RETRYHANDLE: exclude no rollback: " + excludeExNoRB);
                    } else {
                        logger.finer("RETRYHANDLE: include element not present");
                    }
                }
            }
            if (includeEx != null) {
                this._retryIncludeExceptions.add(includeEx.trim());
            }
            if (excludeEx != null) {
                this._retryExcludeExceptions.add(excludeEx.trim());
            }
            if (includeExNoRB != null) {
                this._retryNoRBIncludeExceptions.add(includeExNoRB.trim());
            }
            if (excludeExNoRB != null) {
                this._retryNoRBExcludeExceptions.add(excludeExNoRB.trim());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, className, "initialize", "added include exception " + includeEx + "; added exclude exception " + excludeEx);
                logger.logp(Level.FINE, className, "initialize", "added include no rollback exception " + includeExNoRB + "; added exclude no rollback exception " + excludeExNoRB);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "initialize", this.toString());
        }
    }

    public boolean isRollbackException(Exception e) {
        return !this.isNoRollbackException(e);
    }

    public void handleExceptionRead(Exception e) {
        String mName = "handleExceptionRead";
        logger.finer("RETRYHANDLE: in retryhandler handle exception on a read:" + e.toString());
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionRead", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isRetryLimitReached() && this.isRetryable(e)) {
            this.retryType = 1;
            this._retryException = e;
            ++this._retryCount;
            this.logRetry(e);
            if (this._retryReadListeners != null) {
                for (RetryReadListenerProxy retryReadListenerProxy : this._retryReadListeners) {
                    retryReadListenerProxy.onRetryReadException(e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionRead", "No retry.  Rethrow", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "handleExceptionRead", e);
        }
    }

    public void handleExceptionProcess(Exception e, Object w) {
        String mName = "handleExceptionProcess";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionProcess", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isRetryLimitReached() && this.isRetryable(e)) {
            this.retryType = 2;
            this._retryException = e;
            ++this._retryCount;
            this.logRetry(e);
            if (this._retryProcessListeners != null) {
                for (RetryProcessListenerProxy retryProcessListenerProxy : this._retryProcessListeners) {
                    retryProcessListenerProxy.onRetryProcessException(w, e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionProcess", "No retry.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
    }

    public void handleExceptionWrite(Exception e, List<Object> w) {
        String mName = "handleExceptionWrite";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionWrite", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isRetryLimitReached() && this.isRetryable(e)) {
            this.retryType = 3;
            this._retryException = e;
            ++this._retryCount;
            this.logRetry(e);
            if (this._retryWriteListeners != null) {
                for (RetryWriteListenerProxy retryWriteListenerProxy : this._retryWriteListeners) {
                    retryWriteListenerProxy.onRetryWriteException(w, e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionWrite", "No retry.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
    }

    private boolean isRetryable(Exception e) {
        boolean retVal;
        String mName = "isRetryable";
        String exClassName = e.getClass().getName();
        boolean bl = retVal = (this._retryIncludeExceptions.isEmpty() || this.containsException(this._retryIncludeExceptions, e)) && !this.containsException(this._retryExcludeExceptions, e);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "isRetryable", "isRetryable: " + retVal + ": " + exClassName);
        }
        return retVal;
    }

    private boolean isNoRollbackException(Exception e) {
        String mName = "isNoRollbackException";
        String exClassName = e.getClass().getName();
        boolean retVal = false;
        if (!this._retryNoRBIncludeExceptions.isEmpty()) {
            boolean bl = retVal = this.containsException(this._retryNoRBIncludeExceptions, e) && !this.containsException(this._retryNoRBExcludeExceptions, e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "isNoRollbackException", "isNoRollbackException: " + retVal + ": " + exClassName);
        }
        return retVal;
    }

    private boolean containsException(Set<String> retryList, Exception e) {
        String mName = "containsException";
        boolean retVal = false;
        for (String exClassName : retryList) {
            try {
                retVal = Thread.currentThread().getContextClassLoader().loadClass(exClassName).isInstance(e);
                if (!retVal) continue;
                break;
            }
            catch (ClassNotFoundException cnf) {
                logger.logp(Level.FINE, className, "containsException", cnf.getLocalizedMessage());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "containsException", "containsException: " + retVal);
        }
        return retVal;
    }

    private boolean containsRetryableNoRB(Set<String> retryList, Exception e) {
        String mName = "containsRetryableNoRB";
        boolean retVal = false;
        for (String exClassName : retryList) {
            try {
                retVal = Thread.currentThread().getContextClassLoader().loadClass(exClassName).isInstance(e);
                if (!retVal) continue;
                break;
            }
            catch (ClassNotFoundException cnf) {
                logger.logp(Level.FINE, className, "containsRetryableNoRB", cnf.getLocalizedMessage());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "containsRetryableNoRB", "containsRetryableNoRB: " + retVal);
        }
        return retVal;
    }

    private boolean isRetryLimitReached() {
        return this._retryCount >= (long)this._retryLimit;
    }

    private void logRetry(Exception e) {
        String key = "record.retried.norollback.by.batch.container";
        Object[] details = new Object[]{this._jobId, this._stepId, e.getClass().getName() + ": " + e.getMessage()};
    }

    public Exception getException() {
        return this._retryException;
    }

    public long getRetryCount() {
        return this._retryCount;
    }

    public void setRetryCount(long retryCount) {
        String mName = "setRetryCount";
        this._retryCount = retryCount;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "setRetryCount", "setRetryCount: " + this._retryCount);
        }
    }

    public String toString() {
        return "RetryHandler{" + super.toString() + "}count:limit=" + this._retryCount + ":" + this._retryLimit;
    }
}

