/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.AbortedBeforeStartException;
import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.impl.DecisionControllerImpl;
import com.ibm.batch.container.impl.ExecutionElementControllerFactory;
import com.ibm.batch.container.impl.PartitionedStepControllerImpl;
import com.ibm.batch.container.impl.SplitControllerImpl;
import com.ibm.batch.container.jobinstance.ParallelJobExecution;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.util.PartitionDataWrapper;
import com.ibm.batch.container.xjcl.ControlElement;
import com.ibm.batch.container.xjcl.ExecutionElement;
import com.ibm.batch.container.xjcl.Navigator;
import com.ibm.batch.container.xjcl.NavigatorFactory;
import com.ibm.batch.container.xjcl.Transition;
import java.io.Externalizable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.StepExecution;
import jsr352.batch.jsl.Decision;
import jsr352.batch.jsl.End;
import jsr352.batch.jsl.Fail;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;
import jsr352.batch.jsl.Stop;

public class FlowControllerImpl
implements IExecutionElementController {
    private static final String CLASSNAME = PartitionedStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private final RuntimeJobExecutionImpl jobExecutionImpl;
    private IPersistenceManagerService persistenceService = null;
    protected Flow flow;
    private final Navigator<Flow> flowNavigator;
    private volatile IExecutionElementController currentStoppableElementController = null;
    private PartitionAnalyzerProxy analyzerProxy;

    public FlowControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Flow flow) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.flow = flow;
        this.persistenceService = (IPersistenceManagerService)ServicesManager.getInstance().getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
        this.flowNavigator = NavigatorFactory.createFlowNavigator((Flow)flow);
    }

    @Override
    public String execute() throws AbortedBeforeStartException {
        String methodName = "execute";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASSNAME, "execute");
        }
        try {
            this.doExecutionLoop(this.flowNavigator);
            String string = "FLOW_CONTROLLER_RETURN_VALUE";
            return string;
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(CLASSNAME + ": caught exception/error: " + t.getMessage() + " : Stack trace: " + sw.toString());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Flow failed with exception/error: " + t.getMessage());
            }
            throw new BatchContainerRuntimeException(t);
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Flow complete for flow id=" + this.flow.getId() + ", executionId=" + this.jobExecutionImpl.getExecutionId());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASSNAME, "execute");
            }
        }
    }

    private void doExecutionLoop(Navigator<Flow> flowNavigator) throws Exception {
        Transition nextTransition;
        String methodName = "doExecutionLoop";
        ExecutionElement currentExecutionElement = null;
        try {
            currentExecutionElement = flowNavigator.getFirstExecutionElement(this.jobExecutionImpl.getRestartOn());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Flow doesn't contain a step.", e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("First execution element = " + currentExecutionElement.getId());
        }
        StepContextImpl stepContext = null;
        ExecutionElement previousExecutionElement = null;
        IExecutionElementController previousElementController = null;
        while (true) {
            if (!(currentExecutionElement instanceof Step || currentExecutionElement instanceof Decision || currentExecutionElement instanceof Flow || currentExecutionElement instanceof Split)) {
                throw new UnsupportedOperationException("Only support step, and decision within a flow");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Next execution element = " + currentExecutionElement.getId());
            }
            IExecutionElementController elementController = ExecutionElementControllerFactory.getExecutionElementController(this.jobExecutionImpl, currentExecutionElement);
            if (currentExecutionElement instanceof Decision) {
                if (previousExecutionElement == null) {
                    elementController.setStepContext(null);
                } else {
                    if (previousExecutionElement instanceof Decision) {
                        throw new BatchContainerRuntimeException("A decision cannot precede another decision...OR CAN IT???");
                    }
                    if (previousExecutionElement instanceof Step) {
                        elementController.setStepContext(stepContext);
                        StepExecution lastStepExecution = this.getLastStepExecution((Step)previousExecutionElement);
                        ((DecisionControllerImpl)elementController).setStepExecution((Step)previousExecutionElement, lastStepExecution);
                    } else if (previousExecutionElement instanceof Split) {
                        List<StepExecution> stepExecutions = this.getSplitStepExecutions(previousElementController);
                        ((DecisionControllerImpl)elementController).setStepExecutions((Split)previousExecutionElement, stepExecutions);
                    } else if (previousExecutionElement instanceof Flow) {
                        Step last = this.getLastStepInTheFlow(previousExecutionElement);
                        StepExecution lastStepExecution = this.getLastStepExecution(last);
                        ((DecisionControllerImpl)elementController).setStepExecution((Flow)previousExecutionElement, lastStepExecution);
                    }
                }
            } else if (currentExecutionElement instanceof Step) {
                String stepId = ((Step)currentExecutionElement).getId();
                stepContext = new StepContextImpl(stepId);
                elementController.setStepContext(stepContext);
            } else if (currentExecutionElement instanceof Flow || currentExecutionElement instanceof Split) {
                // empty if block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Start executing element = " + currentExecutionElement.getId());
            }
            this.currentStoppableElementController = elementController;
            String executionElementExitStatus = null;
            try {
                executionElementExitStatus = elementController.execute();
            }
            catch (AbortedBeforeStartException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId());
                }
                throw new IllegalStateException("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId() + "; breaking out of execution loop.");
            }
            this.currentStoppableElementController = null;
            previousElementController = elementController;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Done executing element=" + currentExecutionElement.getId() + ", exitStatus=" + executionElementExitStatus);
            }
            if ((nextTransition = flowNavigator.getNextTransition(currentExecutionElement, executionElementExitStatus)) == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop TODO: is this an expected state or not? ");
                }
                return;
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            previousExecutionElement = currentExecutionElement;
            currentExecutionElement = nextTransition.getNextExecutionElement();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("doExecutionLoop , Looping through to next execution element=" + currentExecutionElement.getId());
        }
        if (nextTransition.getControlElement() != null) {
            ControlElement controlElem = nextTransition.getControlElement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("doExecutionLoop , Looping through to next control element=" + controlElem);
            }
            if (controlElem instanceof Stop) {
                String newExitStatus;
                String restartOn = ((Stop)controlElem).getRestart();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <stop> : " + controlElem + " with restartOn=" + restartOn);
                }
                if ((newExitStatus = ((Stop)controlElem).getExitStatus()) != null && !newExitStatus.isEmpty() && logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , on stop, setting new JSL-specified exit status to: " + newExitStatus);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting stopped job");
                }
                return;
            }
            if (controlElem instanceof End) {
                String newExitStatus;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is an <end>: " + controlElem);
                }
                if ((newExitStatus = ((End)controlElem).getExitStatus()) != null && !newExitStatus.isEmpty() && logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , on end, setting new JSL-specified exit status to: " + newExitStatus);
                }
            } else if (controlElem instanceof Fail) {
                String newExitStatus;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <fail>: " + controlElem);
                }
                if ((newExitStatus = ((Fail)controlElem).getExitStatus()) != null && !newExitStatus.isEmpty() && logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , on fail, setting new JSL-specified exit status to: " + newExitStatus);
                }
            } else {
                throw new IllegalStateException("Not sure how we'd get here but better than looping.");
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("doExecutionLoop Exiting as there are no more execution elements= ");
        }
    }

    private List<StepExecution> getSplitStepExecutions(IExecutionElementController previousElementController) {
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>();
        if (previousElementController != null) {
            SplitControllerImpl controller = (SplitControllerImpl)previousElementController;
            for (ParallelJobExecution parallelJob : controller.getParallelJobExecs()) {
                StepExecution lastStepExecution = null;
                List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(parallelJob.getJobExecution().getExecutionId());
                Iterator<StepExecution> i$ = stepExecs.iterator();
                while (i$.hasNext()) {
                    StepExecution stepExecution;
                    lastStepExecution = stepExecution = i$.next();
                }
                stepExecutions.add(lastStepExecution);
            }
        }
        return stepExecutions;
    }

    private StepExecution getLastStepExecution(Step last) {
        StepExecution lastStepExecution = null;
        List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(this.jobExecutionImpl.getExecutionId());
        for (StepExecution stepExecution : stepExecs) {
            if (!last.getId().equals(stepExecution.getName())) continue;
            lastStepExecution = stepExecution;
        }
        return lastStepExecution;
    }

    private Step getLastStepInTheFlow(ExecutionElement previousExecutionElement) {
        Flow flow = (Flow)previousExecutionElement;
        Step last = null;
        for (ExecutionElement elem : flow.getExecutionElements()) {
            if (!(elem instanceof Step)) continue;
            last = (Step)elem;
        }
        return last;
    }

    @Override
    public void stop() {
    }

    public void setStepContext(StepContextImpl<?, ? extends Externalizable> stepContext) {
        throw new BatchContainerRuntimeException("Incorrect usage: step context is not in scope within a flow.");
    }

    public void setAnalyzerQueue(PartitionAnalyzerProxy analyzerProxy) {
        this.analyzerProxy = analyzerProxy;
    }

    @Override
    public void setAnalyzerQueue(LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) {
    }
}

