/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.artifact.proxy.DeciderProxy;
import com.ibm.batch.container.artifact.proxy.InjectionReferences;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.artifact.proxy.ProxyFactory;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.util.ExecutionStatus;
import com.ibm.batch.container.util.PartitionDataWrapper;
import com.ibm.batch.container.validation.ArtifactValidationException;
import com.ibm.batch.container.xjcl.ExecutionElement;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.StepExecution;
import jsr352.batch.jsl.Decision;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;

public class DecisionControllerImpl
implements IExecutionElementController {
    protected RuntimeJobExecutionImpl jobExecutionImpl;
    protected StepContextImpl<?, ? extends Externalizable> stepContext;
    protected Decision decision;
    private PartitionAnalyzerProxy analyzerProxy;
    protected List<StepExecution> stepExecutions = null;
    protected ExecutionElement executionElement = null;

    public DecisionControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Decision decision) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.decision = decision;
    }

    public void setStepContext(StepContextImpl<?, ? extends Externalizable> stepContext) {
        this.stepContext = stepContext;
    }

    public void setStepExecution(Flow flow, StepExecution stepExecution) {
        this.executionElement = flow;
        this.stepExecutions = new ArrayList<StepExecution>();
        this.stepExecutions.add(stepExecution);
    }

    public void setStepExecution(Step step, StepExecution stepExecution) {
        this.executionElement = step;
        this.stepExecutions = new ArrayList<StepExecution>();
        this.stepExecutions.add(stepExecution);
    }

    public void setStepExecutions(Split split, List<StepExecution> stepExecutions) {
        this.executionElement = split;
        this.stepExecutions = stepExecutions;
    }

    @Override
    public String execute() throws Exception {
        DeciderProxy deciderProxy;
        ExecutionStatus status = new ExecutionStatus();
        String deciderId = this.decision.getRef();
        List propList = this.decision.getProperties() == null ? null : this.decision.getProperties().getPropertyList();
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
        try {
            deciderProxy = ProxyFactory.createDeciderProxy(deciderId, injectionRef);
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the decider [" + deciderId + "]", e);
        }
        String exitStatus = null;
        exitStatus = this.executionElement instanceof Split ? deciderProxy.decide(this.stepExecutions.toArray(new StepExecution[this.stepExecutions.size()])) : deciderProxy.decide(this.stepExecutions.get(0));
        return exitStatus;
    }

    @Override
    public void stop() {
        this.stepContext.setBatchStatus(JobOperator.BatchStatus.STOPPING);
    }

    @Override
    public void setAnalyzerQueue(LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) {
    }
}

