/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.jobinstance;

import com.ibm.batch.container.jobinstance.JobInstanceImpl;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.modelresolver.PropertyResolver;
import com.ibm.batch.container.modelresolver.PropertyResolverFactory;
import com.ibm.batch.container.services.IJobIdManagementService;
import com.ibm.batch.container.services.IJobStatusManagerService;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.status.JobStatus;
import com.ibm.batch.container.xjcl.ModelResolverFactory;
import com.ibm.batch.container.xjcl.Navigator;
import com.ibm.batch.container.xjcl.NavigatorFactory;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.StepExecution;
import javax.batch.runtime.context.StepContext;
import jsr352.batch.jsl.JSLJob;

public class JobExecutionHelper {
    private static final String CLASSNAME = JobExecutionHelper.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private static final String GENERATED_JOB = "GENERATED_JOB";
    private static ServicesManager servicesManager = ServicesManager.getInstance();
    private static IJobIdManagementService _jobIdManagementService = (IJobIdManagementService)servicesManager.getService(ServicesManager.ServiceType.JOB_ID_MANAGEMENT_SERVICE);
    private static IJobStatusManagerService _jobIdStatusManagerService = (IJobStatusManagerService)servicesManager.getService(ServicesManager.ServiceType.JOB_STATUS_MANAGEMENT_SERVICE);
    private static IPersistenceManagerService _persistenceManagementService = (IPersistenceManagerService)servicesManager.getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);

    public static RuntimeJobExecutionImpl startJob(String jobXML, Properties jobParameters) {
        long instanceId = _jobIdManagementService.getInstanceId();
        long executionId = _jobIdManagementService.getExecutionId();
        JobInstanceImpl jobInstanceImpl = new JobInstanceImpl(jobXML, jobParameters, instanceId);
        JSLJob jobModel = (JSLJob)ModelResolverFactory.createJobResolver().resolveModel(jobXML);
        PropertyResolver propResolver = PropertyResolverFactory.createJobPropertyResolver();
        propResolver.substituteProperties((Object)jobModel, jobParameters);
        Navigator jobNavigator = NavigatorFactory.createJobNavigator((JSLJob)jobModel);
        jobInstanceImpl.setJobName(jobNavigator.getId());
        _jobIdStatusManagerService.createJobStatus(jobInstanceImpl, executionId);
        Timestamp starttime = new Timestamp(0L);
        Timestamp updatetime = new Timestamp(0L);
        Timestamp endtime = new Timestamp(0L);
        Timestamp createtime = new Timestamp(0L);
        _persistenceManagementService.jobOperatorCreateJobInstanceData(instanceId, jobNavigator.getId());
        _persistenceManagementService.jobOperatorCreateExecutionData(executionId, starttime, updatetime, endtime, createtime, jobParameters, instanceId, "STARTING", "EXITSTATUS");
        return new RuntimeJobExecutionImpl(jobNavigator, jobInstanceImpl, executionId);
    }

    public static RuntimeJobExecutionImpl restartJob(long jobInstanceId, Properties overrideJobParameters) {
        JobStatus jobStatus = _jobIdStatusManagerService.getJobStatus(jobInstanceId);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("On restartJob with jobInstance Id = " + jobInstanceId + " , found JobStatus: " + jobStatus);
        }
        JobInstanceImpl jobInstance = jobStatus.getJobInstance();
        long nextExecutionId = _jobIdManagementService.getExecutionId();
        Properties originalJobParameters = jobInstance.getOriginalJobParams();
        Properties mergedRestartJobParameters = new Properties(originalJobParameters);
        if (overrideJobParameters != null) {
            for (String key : overrideJobParameters.stringPropertyNames()) {
                mergedRestartJobParameters.setProperty(key, overrideJobParameters.getProperty(key));
            }
        }
        JSLJob jobModel = (JSLJob)ModelResolverFactory.createJobResolver().resolveModel(jobInstance.getJobXML());
        PropertyResolver propResolver = PropertyResolverFactory.createJobPropertyResolver();
        propResolver.substituteProperties((Object)jobModel, mergedRestartJobParameters);
        Navigator jobNavigator = NavigatorFactory.createJobNavigator((JSLJob)jobModel);
        _jobIdStatusManagerService.updateJobStatusWithNewExecution(jobInstance.getInstanceId(), nextExecutionId);
        return new RuntimeJobExecutionImpl(jobNavigator, jobInstance, nextExecutionId, jobStatus.getRestartOn());
    }

    public static RuntimeJobExecutionImpl startJob(JSLJob jobModel, Properties jobParameters) {
        long instanceId = _jobIdManagementService.getInstanceId();
        long executionId = _jobIdManagementService.getExecutionId();
        JobInstanceImpl jobInstanceImpl = new JobInstanceImpl(GENERATED_JOB, jobParameters, instanceId);
        PropertyResolver propResolver = PropertyResolverFactory.createJobPropertyResolver();
        propResolver.substituteProperties((Object)jobModel, jobParameters);
        Navigator jobNavigator = NavigatorFactory.createJobNavigator((JSLJob)jobModel);
        jobInstanceImpl.setJobName(jobNavigator.getId());
        _jobIdStatusManagerService.createJobStatus(jobInstanceImpl, executionId);
        return new RuntimeJobExecutionImpl(jobNavigator, jobInstanceImpl, executionId);
    }

    public static void persistStepExecution(long jobExecutionInstanceID, StepContext stepContext) {
        String stepExecutionKey = JobExecutionHelper.getJobStepExecId(jobExecutionInstanceID, stepContext.getStepExecutionId());
        _persistenceManagementService.stepExecutionCreateStepExecutionData(stepExecutionKey, jobExecutionInstanceID, stepContext.getStepExecutionId());
    }

    public static long getstepExecutionIDInfo(String key, String idtype) {
        return _persistenceManagementService.stepExecutionQueryID(key, idtype);
    }

    public static List<StepExecution> getstepExecutionIDInfoList(long key, String idtype) {
        return _persistenceManagementService.stepExecutionQueryIDList(key, idtype);
    }

    private static String getJobStepExecId(long jobExecutionId, long stepExecutionId) {
        return String.valueOf(jobExecutionId) + ':' + String.valueOf(stepExecutionId);
    }
}

