/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.artifact.proxy.ProxyFactory;
import com.ibm.batch.container.artifact.proxy.StepListenerProxy;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.impl.BaseStepControllerImpl;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.validation.ArtifactValidationException;
import java.util.List;
import java.util.logging.Logger;
import jsr352.batch.jsl.Collector;
import jsr352.batch.jsl.Step;

public abstract class SingleThreadedStepControllerImpl
extends BaseStepControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SingleThreadedStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    List<StepListenerProxy> stepListeners = null;

    protected SingleThreadedStepControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Step step) {
        super(jobExecutionImpl, step);
    }

    @Override
    protected void setupStepArtifacts() {
        Collector collector;
        this.stepListeners = this.jobExecutionImpl.getListenerFactory().getStepListeners(this.step);
        if (this.step.getPartition() != null && (collector = this.step.getPartition().getCollector()) != null) {
            List propList = collector.getProperties() == null ? null : collector.getProperties().getPropertyList();
            try {
                this.collectorProxy = ProxyFactory.createPartitionCollectorProxy(collector.getRef(), propList);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the collector [" + collector.getRef() + "]", e);
            }
        }
    }

    @Override
    protected void invokePreStepArtifacts() {
        if (this.stepListeners == null) {
            return;
        }
        if (this.collectorProxy != null) {
            this.collectorProxy.setJobContext(this.jobExecutionImpl.getJobContext());
            this.collectorProxy.setSplitContext(this.splitContext);
            this.collectorProxy.setFlowContext(this.flowContext);
            this.collectorProxy.setStepContext(this.stepContext);
        }
        for (StepListenerProxy listenerProxy : this.stepListeners) {
            listenerProxy.setJobContext(this.jobExecutionImpl.getJobContext());
            listenerProxy.setSplitContext(this.splitContext);
            listenerProxy.setFlowContext(this.flowContext);
            listenerProxy.setStepContext(this.stepContext);
        }
        for (StepListenerProxy listenerProxy : this.stepListeners) {
            listenerProxy.beforeStep();
        }
    }

    @Override
    protected void invokePostStepArtifacts() {
        if (this.analyzerProxy != null) {
            this.analyzerProxy.analyzeExitStatus(this.stepStatus.getExitStatus());
        }
        if (this.stepListeners != null) {
            for (StepListenerProxy listenerProxy : this.stepListeners) {
                listenerProxy.afterStep();
            }
        }
    }
}

