/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.AbortedBeforeStartException;
import com.ibm.batch.container.IController;
import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.artifact.proxy.JobListenerProxy;
import com.ibm.batch.container.artifact.proxy.ListenerFactory;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.context.impl.FlowContextImpl;
import com.ibm.batch.container.context.impl.JobContextImpl;
import com.ibm.batch.container.context.impl.SplitContextImpl;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.impl.ExecutionElementControllerFactory;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.services.IJobStatusManagerService;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.services.impl.JDBCPersistenceManagerImpl;
import com.ibm.batch.container.util.ExecutionStatus;
import com.ibm.batch.container.xjcl.ControlElement;
import com.ibm.batch.container.xjcl.ExecutionElement;
import com.ibm.batch.container.xjcl.Navigator;
import com.ibm.batch.container.xjcl.Transition;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Decision;
import jsr352.batch.jsl.End;
import jsr352.batch.jsl.Fail;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.JSLProperties;
import jsr352.batch.jsl.Property;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;
import jsr352.batch.jsl.Stop;

public class JobControllerImpl
implements IController {
    private static final String CLASSNAME = JobControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IJobStatusManagerService jobStatusService = null;
    private IPersistenceManagerService persistenceService = null;
    private RuntimeJobExecutionImpl jobExecution = null;
    private final JobContextImpl<?> jobContext;
    private final Navigator<JSLJob> jobNavigator;
    private final String jobId;
    private PartitionAnalyzerProxy analyzerProxy = null;
    private ListenerFactory listenerFactory = null;
    private final long jobInstanceId;
    private volatile IExecutionElementController currentStoppableElementController = null;

    public JobControllerImpl(RuntimeJobExecutionImpl jobExecution) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.jobNavigator = jobExecution.getJobNavigator();
        this.jobId = this.jobNavigator.getId();
        this.jobInstanceId = jobExecution.getJobInstance().getInstanceId();
        this.jobStatusService = (IJobStatusManagerService)ServicesManager.getInstance().getService(ServicesManager.ServiceType.JOB_STATUS_MANAGEMENT_SERVICE);
        this.persistenceService = (IPersistenceManagerService)ServicesManager.getInstance().getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
        this.setContextProperties();
        this.setupListeners();
    }

    private void setContextProperties() {
        JSLJob jobModel = (JSLJob)this.jobExecution.getJobNavigator().getJSL();
        JSLProperties jslProps = jobModel.getProperties();
        if (jslProps != null) {
            for (Property property : jslProps.getPropertyList()) {
                Properties contextProps = this.jobContext.getProperties();
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
    }

    private void setupListeners() {
        JSLJob jobModel = (JSLJob)this.jobExecution.getJobNavigator().getJSL();
        this.listenerFactory = new ListenerFactory(jobModel);
        this.jobExecution.setListenerFactory(this.listenerFactory);
    }

    public void executeJob() {
        String methodName = "executeJob";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASSNAME, "executeJob");
        }
        try {
            if (ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING).equals(this.jobContext.getBatchStatus())) {
                this.updateJobBatchStatus(ExecutionStatus.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Exiting as job has been stopped");
                }
                return;
            }
            this.updateJobBatchStatus(ExecutionStatus.BatchStatus.STARTING);
            if (this.jobContext.getBatchStatus().equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING))) {
                this.updateJobBatchStatus(ExecutionStatus.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Exiting as job has been stopped");
                }
                return;
            }
            this.updateJobBatchStatus(ExecutionStatus.BatchStatus.STARTED);
            List<JobListenerProxy> jobListeners = this.listenerFactory.getJobListeners();
            for (JobListenerProxy listenerProxy : jobListeners) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Setting jobContext on jobListener: " + listenerProxy.getDelegate() + " of type: " + listenerProxy.getDelegate().getClass());
                }
                listenerProxy.setJobContext(this.jobContext);
            }
            for (JobListenerProxy listenerProxy : jobListeners) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Invoking @BeforeJob on jobListener: " + listenerProxy.getDelegate() + " of type: " + listenerProxy.getDelegate().getClass());
                }
                listenerProxy.beforeJob();
            }
            if (this.jobContext.getBatchStatus().equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING))) {
                this.updateJobBatchStatus(ExecutionStatus.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Exiting as job has been stopped");
                }
                return;
            }
            this.doExecutionLoop(this.jobNavigator);
            String curStatusString = this.jobContext.getBatchStatus();
            if (curStatusString == null) {
                throw new IllegalStateException("Job BatchStatus should have been set by now");
            }
            ExecutionStatus.BatchStatus curStatus = ExecutionStatus.getBatchStatusEnum(curStatusString);
            if (!curStatus.equals((Object)ExecutionStatus.BatchStatus.FAILED) && !curStatus.equals((Object)ExecutionStatus.BatchStatus.STOPPED)) {
                this.updateJobBatchStatus(ExecutionStatus.BatchStatus.COMPLETED);
            }
            if (this.jobContext.getExitStatus() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No job-level exitStatus set, defaulting to job batch Status = " + this.jobContext.getBatchStatus());
                }
                this.jobContext.setExitStatus(this.jobContext.getBatchStatus());
            }
            for (JobListenerProxy listenerProxy : jobListeners) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Invoking @AfterJob on jobListener: " + listenerProxy.getDelegate() + " of type: " + listenerProxy.getDelegate().getClass());
                }
                listenerProxy.afterJob();
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(CLASSNAME + ": caught exception/error: " + t.getMessage() + " : Stack trace: " + sw.toString());
            }
            this.updateJobBatchStatus(ExecutionStatus.BatchStatus.FAILED);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Job failed with exception/error: " + t.getMessage());
            }
            if (this.jobContext.getExitStatus() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No job-level exitStatus set, defaulting to job batch Status = " + this.jobContext.getBatchStatus());
                }
                this.jobContext.setExitStatus(this.jobContext.getBatchStatus());
            }
            throw new BatchContainerRuntimeException(t);
        }
        finally {
            block42: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Job complete for job id=" + this.jobExecution.getJobInstance().getJobName() + ", executionId=" + this.jobExecution.getExecutionId() + ", batchStatus=" + this.jobContext.getBatchStatus() + ", exitStatus=" + this.jobContext.getExitStatus());
                }
                try {
                    this.jobStatusService.updateJobExecutionStatus(this.jobExecution.getInstanceId(), ExecutionStatus.getBatchStatusEnum(this.jobContext.getBatchStatus()), this.jobContext.getExitStatus());
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block42;
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    logger.warning("Caught Throwable on updating execution status: " + sw.toString());
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASSNAME, "executeJob");
            }
        }
    }

    private void doExecutionLoop(Navigator jobNavigator) {
        Transition nextTransition;
        String methodName = "doExecutionLoop";
        JobContextImpl<?> jobContext = this.jobExecution.getJobContext();
        ExecutionElement currentExecutionElement = null;
        try {
            currentExecutionElement = jobNavigator.getFirstExecutionElement(this.jobExecution.getRestartOn());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Job doesn't contain a step.", e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("First execution element = " + currentExecutionElement.getId());
        }
        StepContextImpl stepContext = null;
        FlowContextImpl flowContext = null;
        SplitContextImpl splitContext = null;
        ExecutionElement previousExecutionElement = null;
        while (true) {
            if (!(currentExecutionElement instanceof Step || currentExecutionElement instanceof Decision || currentExecutionElement instanceof Flow || currentExecutionElement instanceof Split)) {
                throw new UnsupportedOperationException("Only support step, flow, and decision at the moment.");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Next execution element = " + currentExecutionElement.getId());
            }
            IExecutionElementController elementController = ExecutionElementControllerFactory.getExecutionElementController(this.jobExecution, currentExecutionElement);
            elementController.setAnalyzerProxy(this.analyzerProxy);
            if (currentExecutionElement instanceof Decision) {
                if (previousExecutionElement == null) {
                    elementController.setStepContext(null);
                    elementController.setFlowContext(null);
                    elementController.setSplitContext(null);
                } else {
                    if (previousExecutionElement instanceof Decision) {
                        throw new BatchContainerRuntimeException("A decision cannot precede another decision...OR CAN IT???");
                    }
                    if (previousExecutionElement instanceof Step) {
                        elementController.setStepContext(stepContext);
                        elementController.setFlowContext(null);
                        elementController.setSplitContext(null);
                    } else if (previousExecutionElement instanceof Split) {
                        elementController.setStepContext(null);
                        elementController.setFlowContext(null);
                        elementController.setSplitContext(splitContext);
                    } else if (previousExecutionElement instanceof Flow) {
                        elementController.setStepContext(null);
                        elementController.setFlowContext(flowContext);
                        elementController.setSplitContext(null);
                    }
                }
            } else if (currentExecutionElement instanceof Step) {
                String stepId = ((Step)currentExecutionElement).getId();
                stepContext = new StepContextImpl(stepId);
                elementController.setStepContext(stepContext);
            } else if (currentExecutionElement instanceof Flow) {
                String flowId = ((Flow)currentExecutionElement).getId();
                flowContext = new FlowContextImpl(flowId);
                elementController.setFlowContext(flowContext);
            } else if (currentExecutionElement instanceof Split) {
                String splitId = ((Split)currentExecutionElement).getId();
                splitContext = new SplitContextImpl(splitId);
                elementController.setSplitContext(splitContext);
            }
            if (jobContext.getBatchStatus().equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING))) {
                this.updateJobBatchStatus(ExecutionStatus.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting as job has been stopped");
                }
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Start executing element = " + currentExecutionElement.getId());
            }
            this.currentStoppableElementController = elementController;
            String executionElementExitStatus = null;
            try {
                executionElementExitStatus = elementController.execute();
            }
            catch (AbortedBeforeStartException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId());
                }
                throw new IllegalStateException("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId() + "; breaking out of execution loop.");
            }
            this.currentStoppableElementController = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Done executing element=" + currentExecutionElement.getId() + ", exitStatus=" + executionElementExitStatus);
            }
            if (ExecutionStatus.getBatchStatusEnum(jobContext.getBatchStatus()).equals((Object)ExecutionStatus.BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(ExecutionStatus.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting as job has been stopped");
                }
                return;
            }
            nextTransition = jobNavigator.getNextTransition(currentExecutionElement, executionElementExitStatus);
            if (nextTransition == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop TODO: is this an expected state or not? ");
                }
                return;
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            previousExecutionElement = currentExecutionElement;
            currentExecutionElement = nextTransition.getNextExecutionElement();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("doExecutionLoop , Looping through to next execution element=" + currentExecutionElement.getId());
        }
        if (nextTransition.getControlElement() != null) {
            ControlElement controlElem = nextTransition.getControlElement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("doExecutionLoop , Looping through to next control element=" + controlElem);
            }
            if (controlElem instanceof Stop) {
                String restartOn = ((Stop)controlElem).getRestart();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <stop> : " + controlElem + " with restartOn=" + restartOn);
                }
                this.updateJobBatchStatus(ExecutionStatus.BatchStatus.STOPPED);
                this.jobStatusService.updateJobStatusFromJSLStop(this.jobInstanceId, restartOn);
                String newExitStatus = ((Stop)controlElem).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    jobContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on stop, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting stopped job");
                }
                return;
            }
            if (controlElem instanceof End) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is an <end>: " + controlElem);
                }
                this.updateJobBatchStatus(ExecutionStatus.BatchStatus.COMPLETED);
                String newExitStatus = ((End)controlElem).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    jobContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on end, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
            } else if (controlElem instanceof Fail) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <fail>: " + controlElem);
                }
                this.updateJobBatchStatus(ExecutionStatus.BatchStatus.FAILED);
                String newExitStatus = ((Fail)controlElem).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    jobContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on fail, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
            } else {
                throw new IllegalStateException("Not sure how we'd get here but better than looping.");
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("doExecutionLoop Exiting as there are no more execution elements= ");
        }
    }

    @Override
    public void stop() {
        this.updateJobBatchStatus(ExecutionStatus.BatchStatus.STOPPING);
        if (this.currentStoppableElementController != null) {
            this.currentStoppableElementController.stop();
        }
    }

    private void updateJobBatchStatus(ExecutionStatus.BatchStatus batchStatus) {
        String methodName = "updateJobBatchStatus";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(methodName + " Setting job batch status to: " + ExecutionStatus.getStringValue(batchStatus));
        }
        this.jobContext.setBatchStatus(ExecutionStatus.getStringValue(batchStatus));
        this.jobStatusService.updateJobBatchStatus(this.jobInstanceId, batchStatus);
        if (this.persistenceService instanceof JDBCPersistenceManagerImpl) {
            Timestamp updateTS = new Timestamp(0L);
            this.persistenceService.jobExecutionStatusStringUpdate(this.jobExecution.getExecutionId(), "batchstatus", ExecutionStatus.getStringValue(batchStatus), updateTS);
        }
    }

    public void setAnalyzerProxy(PartitionAnalyzerProxy analyzerProxy) {
        this.analyzerProxy = analyzerProxy;
    }
}

