/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.AbortedBeforeStartException;
import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.artifact.proxy.FlowListenerProxy;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.context.impl.FlowContextImpl;
import com.ibm.batch.container.context.impl.SplitContextImpl;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.impl.ExecutionElementControllerFactory;
import com.ibm.batch.container.impl.PartitionedStepControllerImpl;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.util.ExecutionStatus;
import com.ibm.batch.container.xjcl.ControlElement;
import com.ibm.batch.container.xjcl.ExecutionElement;
import com.ibm.batch.container.xjcl.Navigator;
import com.ibm.batch.container.xjcl.NavigatorFactory;
import com.ibm.batch.container.xjcl.Transition;
import java.io.Externalizable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Decision;
import jsr352.batch.jsl.End;
import jsr352.batch.jsl.Fail;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;
import jsr352.batch.jsl.Stop;

public class FlowControllerImpl
implements IExecutionElementController {
    private static final String CLASSNAME = PartitionedStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private final RuntimeJobExecutionImpl jobExecutionImpl;
    protected SplitContextImpl splitContext;
    protected FlowContextImpl currentFlowContext;
    protected Flow flow;
    private final Navigator<Flow> flowNavigator;
    private volatile IExecutionElementController currentStoppableElementController = null;
    private PartitionAnalyzerProxy analyzerProxy;
    List<FlowListenerProxy> flowListeners = null;

    public FlowControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Flow flow) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.flow = flow;
        this.flowNavigator = NavigatorFactory.createFlowNavigator((Flow)flow);
    }

    @Override
    public String execute() throws AbortedBeforeStartException {
        String methodName = "execute";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASSNAME, "execute");
        }
        try {
            this.currentFlowContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STARTED));
            this.flowListeners = this.jobExecutionImpl.getListenerFactory().getFlowListeners(this.flow);
            for (FlowListenerProxy listenerProxy : this.flowListeners) {
                listenerProxy.setJobContext(this.jobExecutionImpl.getJobContext());
                listenerProxy.setSplitContext(this.splitContext);
                listenerProxy.setFlowContext(this.currentFlowContext);
            }
            for (FlowListenerProxy listenerProxy : this.flowListeners) {
                listenerProxy.beforeFlow();
            }
            this.doExecutionLoop(this.flowNavigator);
            String curStatusString = this.currentFlowContext.getBatchStatus();
            if (curStatusString == null) {
                throw new IllegalStateException("Flow BatchStatus should have been set by now");
            }
            ExecutionStatus.BatchStatus curStatus = ExecutionStatus.getBatchStatusEnum(curStatusString);
            if (!curStatus.equals((Object)ExecutionStatus.BatchStatus.FAILED) && !curStatus.equals((Object)ExecutionStatus.BatchStatus.STOPPED)) {
                this.currentFlowContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.COMPLETED));
            }
            for (FlowListenerProxy listenerProxy : this.flowListeners) {
                listenerProxy.afterFlow();
            }
            if (this.currentFlowContext.getExitStatus() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No flow-level exitStatus set, defaulting to flow batch Status = " + this.currentFlowContext.getBatchStatus());
                }
                this.currentFlowContext.setExitStatus(this.currentFlowContext.getBatchStatus());
            }
            String i$ = this.currentFlowContext.getBatchStatus();
            return i$;
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(CLASSNAME + ": caught exception/error: " + t.getMessage() + " : Stack trace: " + sw.toString());
            }
            this.currentFlowContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.FAILED));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Flow failed with exception/error: " + t.getMessage());
            }
            if (this.currentFlowContext.getExitStatus() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No flow-level exitStatus set, defaulting to flow batch Status = " + this.currentFlowContext.getBatchStatus());
                }
                this.currentFlowContext.setExitStatus(this.currentFlowContext.getBatchStatus());
            }
            throw new BatchContainerRuntimeException(t);
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Flow complete for flow id=" + this.flow.getId() + ", executionId=" + this.jobExecutionImpl.getExecutionId() + ", batchStatus=" + this.currentFlowContext.getBatchStatus() + ", exitStatus=" + this.currentFlowContext.getExitStatus());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASSNAME, "execute");
            }
        }
    }

    private void doExecutionLoop(Navigator<Flow> flowNavigator) {
        Transition nextTransition;
        String methodName = "doExecutionLoop";
        ExecutionElement currentExecutionElement = null;
        try {
            currentExecutionElement = flowNavigator.getFirstExecutionElement(this.jobExecutionImpl.getRestartOn());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Flow doesn't contain a step.", e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("First execution element = " + currentExecutionElement.getId());
        }
        StepContextImpl stepContext = null;
        FlowContextImpl flowContext = null;
        SplitContextImpl splitContext = null;
        ExecutionElement previousExecutionElement = null;
        while (true) {
            if (!(currentExecutionElement instanceof Step) && !(currentExecutionElement instanceof Decision)) {
                throw new UnsupportedOperationException("Only support step, and decision within a flow");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Next execution element = " + currentExecutionElement.getId());
            }
            IExecutionElementController elementController = ExecutionElementControllerFactory.getExecutionElementController(this.jobExecutionImpl, currentExecutionElement);
            elementController.setAnalyzerProxy(this.analyzerProxy);
            if (currentExecutionElement instanceof Decision) {
                if (previousExecutionElement == null) {
                    elementController.setStepContext(null);
                    elementController.setFlowContext(null);
                    elementController.setSplitContext(null);
                } else {
                    if (previousExecutionElement instanceof Decision) {
                        throw new BatchContainerRuntimeException("A decision cannot precede another decision...OR CAN IT???");
                    }
                    if (previousExecutionElement instanceof Step) {
                        elementController.setStepContext(stepContext);
                        elementController.setFlowContext(null);
                        elementController.setSplitContext(null);
                    } else if (previousExecutionElement instanceof Split) {
                        elementController.setStepContext(null);
                        elementController.setFlowContext(null);
                        elementController.setSplitContext(splitContext);
                    } else if (previousExecutionElement instanceof Flow) {
                        elementController.setStepContext(null);
                        elementController.setFlowContext(flowContext);
                        elementController.setSplitContext(null);
                    }
                }
            } else if (currentExecutionElement instanceof Step) {
                String stepId = ((Step)currentExecutionElement).getId();
                stepContext = new StepContextImpl(stepId);
                elementController.setStepContext(stepContext);
            } else {
                if (currentExecutionElement instanceof Flow) {
                    throw new IllegalArgumentException("A flow cannot be nested within another flow.");
                }
                if (currentExecutionElement instanceof Split) {
                    throw new IllegalArgumentException("A split cannot be nested within a flow.");
                }
            }
            if (ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING).equals(this.currentFlowContext.getBatchStatus())) {
                this.currentFlowContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED));
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting as job has been stopped");
                }
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Start executing element = " + currentExecutionElement.getId());
            }
            this.currentStoppableElementController = elementController;
            String executionElementExitStatus = null;
            try {
                executionElementExitStatus = elementController.execute();
            }
            catch (AbortedBeforeStartException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId());
                }
                throw new IllegalStateException("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId() + "; breaking out of execution loop.");
            }
            this.currentStoppableElementController = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Done executing element=" + currentExecutionElement.getId() + ", exitStatus=" + executionElementExitStatus);
            }
            if (ExecutionStatus.getBatchStatusEnum(this.currentFlowContext.getBatchStatus()).equals((Object)ExecutionStatus.BatchStatus.STOPPING)) {
                this.currentFlowContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED));
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting as job has been stopped");
                }
                return;
            }
            nextTransition = flowNavigator.getNextTransition(currentExecutionElement, executionElementExitStatus);
            if (nextTransition == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop TODO: is this an expected state or not? ");
                }
                return;
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            previousExecutionElement = currentExecutionElement;
            currentExecutionElement = nextTransition.getNextExecutionElement();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("doExecutionLoop , Looping through to next execution element=" + currentExecutionElement.getId());
        }
        if (nextTransition.getControlElement() != null) {
            ControlElement controlElem = nextTransition.getControlElement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("doExecutionLoop , Looping through to next control element=" + controlElem);
            }
            if (controlElem instanceof Stop) {
                String restartOn = ((Stop)controlElem).getRestart();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <stop> : " + controlElem + " with restartOn=" + restartOn);
                }
                this.currentFlowContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED));
                String newExitStatus = ((Stop)controlElem).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    this.currentFlowContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on stop, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting stopped job");
                }
                return;
            }
            if (controlElem instanceof End) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is an <end>: " + controlElem);
                }
                this.currentFlowContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.COMPLETED));
                String newExitStatus = ((End)controlElem).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    this.currentFlowContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on end, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
            } else if (controlElem instanceof Fail) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <fail>: " + controlElem);
                }
                this.currentFlowContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.FAILED));
                String newExitStatus = ((Fail)controlElem).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    this.currentFlowContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on fail, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
            } else {
                throw new IllegalStateException("Not sure how we'd get here but better than looping.");
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("doExecutionLoop Exiting as there are no more execution elements= ");
        }
    }

    @Override
    public void stop() {
        this.currentFlowContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING));
        if (this.currentStoppableElementController != null) {
            this.currentStoppableElementController.stop();
        }
    }

    public void setStepContext(StepContextImpl<?, ? extends Externalizable> stepContext) {
        throw new BatchContainerRuntimeException("Incorrect usage: step context is not in scope within a flow.");
    }

    @Override
    public void setSplitContext(SplitContextImpl splitContext) {
        this.splitContext = splitContext;
    }

    @Override
    public void setFlowContext(FlowContextImpl flowContext) {
        this.currentFlowContext = flowContext;
    }

    @Override
    public void setAnalyzerProxy(PartitionAnalyzerProxy analyzerProxy) {
        this.analyzerProxy = analyzerProxy;
    }
}

