/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.artifact.proxy.CheckpointAlgorithmProxy;
import com.ibm.batch.container.artifact.proxy.CheckpointListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemProcessorProxy;
import com.ibm.batch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.batch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.batch.container.artifact.proxy.ProxyFactory;
import com.ibm.batch.container.artifact.proxy.RetryListenerProxy;
import com.ibm.batch.container.artifact.proxy.SkipListenerProxy;
import com.ibm.batch.container.context.impl.MetricImpl;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.impl.ChunkHelper;
import com.ibm.batch.container.impl.RetryHandler;
import com.ibm.batch.container.impl.SingleThreadedStepControllerImpl;
import com.ibm.batch.container.impl.SkipHandler;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.util.ExecutionStatus;
import com.ibm.batch.container.util.TCCLObjectInputStream;
import com.ibm.batch.container.validation.ArtifactValidationException;
import com.ibm.ws.batch.container.checkpoint.CheckpointAlgorithm;
import com.ibm.ws.batch.container.checkpoint.CheckpointAlgorithmFactory;
import com.ibm.ws.batch.container.checkpoint.CheckpointData;
import com.ibm.ws.batch.container.checkpoint.CheckpointDataKey;
import com.ibm.ws.batch.container.checkpoint.CheckpointManager;
import com.ibm.ws.batch.container.checkpoint.ItemCheckpointAlgorithm;
import com.ibm.ws.batch.container.checkpoint.ItemTimeCheckpointAlgorithm;
import com.ibm.ws.batch.container.checkpoint.TimeCheckpointAlgorithm;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Chunk;
import jsr352.batch.jsl.JSLProperties;
import jsr352.batch.jsl.ObjectFactory;
import jsr352.batch.jsl.Property;
import jsr352.batch.jsl.Step;

public class ChunkStepControllerImpl
extends SingleThreadedStepControllerImpl {
    private static final String sourceClass = ChunkStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Chunk chunk = null;
    private ItemReaderProxy readerProxy = null;
    private ItemProcessorProxy processorProxy = null;
    private ItemWriterProxy writerProxy = null;
    private CheckpointAlgorithmProxy checkpointProxy = null;
    private CheckpointAlgorithm chkptAlg = null;
    private CheckpointManager checkpointManager;
    private ServicesManager servicesManager = ServicesManager.getInstance();
    private IPersistenceManagerService _persistenceManagerService = null;
    private SkipHandler skipHandler = null;
    CheckpointDataKey readerChkptDK;
    CheckpointDataKey writerChkptDK = null;
    CheckpointData readerChkptData = null;
    CheckpointData writerChkptData = null;
    List<CheckpointListenerProxy> checkpointListeners = null;
    List<SkipListenerProxy> skipListeners = null;
    List<RetryListenerProxy> retryListeners = null;
    private RetryHandler retryHandler;
    long readCount = 0L;
    long writeCount = 0L;
    long readSkipCount = 0L;
    long processSkipCount = 0L;
    long writeSkipCount = 0L;

    public ChunkStepControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Step step) {
        super(jobExecutionImpl, step);
    }

    private List<Object> readAndProcess(int chunkSize, ItemStatus theStatus) {
        ItemStatus status;
        logger.entering(sourceClass, "readAndProcess", new Object[]{chunkSize, theStatus});
        ArrayList<Object> chunkToWrite = new ArrayList<Object>();
        Object itemRead = null;
        Object itemProcessed = null;
        int readProcessedCount = 0;
        do {
            status = new ItemStatus();
            itemRead = this.readItem(status);
            if (!status.isSkipped() && !status.isFinished()) {
                itemProcessed = this.processItem(itemRead, status);
                if (!status.isSkipped()) {
                    chunkToWrite.add(itemProcessed);
                    ++readProcessedCount;
                }
            }
            theStatus.setFinished(status.isFinished());
            theStatus.setCheckPointed(this.checkpointManager.ApplyCheckPointPolicy());
        } while (readProcessedCount != chunkSize && !theStatus.isCheckPointed() && !status.isFinished());
        logger.exiting(sourceClass, "readAndProcess", chunkToWrite);
        return chunkToWrite;
    }

    private Object readItem(ItemStatus status) {
        logger.entering(sourceClass, "readItem", status);
        Object itemRead = null;
        try {
            itemRead = this.readerProxy.readItem();
            status.setFinished(itemRead == null);
            if (!status.isFinished()) {
                this.stepContext.getMetric(MetricImpl.Counter.valueOf("READ_COUNT")).incValue();
            }
        }
        catch (Exception e) {
            if (this.skipReadException(e)) {
                status.setSkipped(true);
                this.stepContext.getMetric(MetricImpl.Counter.valueOf("READ_SKIP_COUNT")).incValue();
            }
            if (this.retryReadException(e)) {
                itemRead = this.readItem(status);
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        logger.exiting(sourceClass, "readItem", itemRead);
        return itemRead;
    }

    private Object processItem(Object itemRead, ItemStatus status) {
        logger.entering(sourceClass, "processItem", new Object[]{itemRead, status});
        Object processedItem = null;
        try {
            processedItem = this.processorProxy.processItem(itemRead);
        }
        catch (Exception e) {
            if (this.skipProcessException(e, itemRead)) {
                status.setSkipped(true);
                this.stepContext.getMetric(MetricImpl.Counter.valueOf("PROCESS_SKIP_COUNT")).incValue();
            }
            if (this.retryProcessException(e, itemRead)) {
                processedItem = this.processItem(itemRead, status);
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        logger.exiting(sourceClass, "processItem", processedItem);
        return processedItem;
    }

    private void writeChunk(List<Object> theChunk) {
        logger.entering(sourceClass, "writeChunk", theChunk);
        if (!theChunk.isEmpty()) {
            try {
                this.writerProxy.writeItems(theChunk);
                this.stepContext.getMetric(MetricImpl.Counter.valueOf("WRITE_COUNT")).incValueBy(theChunk.size());
            }
            catch (Exception e) {
                if (this.skipWriteException(e, theChunk)) {
                    this.stepContext.getMetric(MetricImpl.Counter.valueOf("WRITE_SKIP_COUNT")).incValueBy(theChunk.size());
                }
                if (this.retryWriteException(e, theChunk)) {
                    this.writeChunk(theChunk);
                }
                throw new BatchContainerRuntimeException(e);
            }
            catch (Throwable e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
        logger.exiting(sourceClass, "writeChunk");
    }

    /*
     * Exception decompiling
     */
    private void invokeChunk() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void invokeCoreStep() throws BatchContainerServiceException {
        this.chunk = this.step.getChunk();
        this.initializeChunkArtifacts();
        try {
            this.invokeChunk();
        }
        catch (Exception re) {
            throw new BatchContainerServiceException(re);
        }
    }

    private void initializeChunkArtifacts() {
        List data;
        String sourceMethod;
        block40: {
            sourceMethod = "initializeChunkArtifacts";
            if (logger.isLoggable(Level.FINE)) {
                logger.entering(sourceClass, sourceMethod);
            }
            List propList = this.chunk.getProperties() == null ? null : this.chunk.getProperties().getPropertyList();
            String readerId = this.chunk.getReader();
            try {
                List<Property> filteredProps = this.filterChunkProperties(propList, CHUNK_ARTIFACT.READER);
                this.readerProxy = ProxyFactory.createItemReaderProxy(readerId, filteredProps);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created ItemReaderProxy for " + readerId);
                }
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the ItemReader [" + readerId + "]", e);
            }
            String processorId = this.chunk.getProcessor();
            try {
                List<Property> filteredProps = this.filterChunkProperties(propList, CHUNK_ARTIFACT.PROCESSOR);
                this.processorProxy = ProxyFactory.createItemProcessorProxy(processorId, filteredProps);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created ItemProcessorProxy for " + processorId);
                }
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the ItemProcessor [" + processorId + "]", e);
            }
            String writerId = this.chunk.getWriter();
            try {
                List<Property> filteredProps = this.filterChunkProperties(propList, CHUNK_ARTIFACT.WRITER);
                this.writerProxy = ProxyFactory.createItemWriterProxy(writerId, filteredProps);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created ItemWriterProxy for " + writerId);
                }
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the ItemWriter [" + writerId + "]", e);
            }
            try {
                this.checkpointProxy = CheckpointAlgorithmFactory.getCheckpointAlgorithmProxy(this.step);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created CheckpointAlgorithmProxy for policy [" + this.chunk.getCheckpointPolicy() + "]");
                }
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the CheckpointAlgorithm for policy [" + this.chunk.getCheckpointPolicy() + "]", e);
            }
            int commitInterval = ChunkHelper.getCommitInterval(this.chunk);
            this.checkpointListeners = this.jobExecutionImpl.getListenerFactory().getCheckpointListeners(this.step);
            this.skipListeners = this.jobExecutionImpl.getListenerFactory().getSkipListeners(this.step);
            for (SkipListenerProxy skipListenerProxy : this.skipListeners) {
                skipListenerProxy.setJobContext(this.jobExecutionImpl.getJobContext());
                skipListenerProxy.setStepContext(this.stepContext);
            }
            this.retryListeners = this.jobExecutionImpl.getListenerFactory().getRetryListeners(this.step);
            for (RetryListenerProxy retryListenerProxy : this.retryListeners) {
                retryListenerProxy.setJobContext(this.jobExecutionImpl.getJobContext());
                retryListenerProxy.setStepContext(this.stepContext);
            }
            if (this.checkpointProxy.getCheckpointType() == "item") {
                this.chkptAlg = new ItemCheckpointAlgorithm();
                this.chkptAlg.setThreshold(commitInterval);
            } else if (this.checkpointProxy.getCheckpointType() == "time") {
                this.chkptAlg = new TimeCheckpointAlgorithm();
                this.chkptAlg.setThreshold(commitInterval);
            } else if (this.checkpointProxy.getCheckpointType() == "item-time") {
                this.chkptAlg = new ItemTimeCheckpointAlgorithm();
                JSLProperties jslProps = this.step.getChunk().getCheckpointAlgorithm().getProperties();
                int item = 0;
                int time = 0;
                if (jslProps != null) {
                    for (Property property : jslProps.getPropertyList()) {
                        String propName = property.getName();
                        if (propName.equals("item")) {
                            String string = property.getValue();
                            item = Integer.parseInt(string);
                            continue;
                        }
                        if (!propName.equals("time")) continue;
                        String timeString = property.getValue();
                        time = Integer.parseInt(timeString);
                    }
                }
                if (item > 0 && time > 0) {
                    this.chkptAlg.setThresholds(item, time);
                }
            } else {
                this.chkptAlg = this.checkpointProxy;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Setting contexts for chunk artifacts");
            }
            this.readerProxy.setJobContext(this.jobExecutionImpl.getJobContext());
            this.processorProxy.setJobContext(this.jobExecutionImpl.getJobContext());
            this.writerProxy.setJobContext(this.jobExecutionImpl.getJobContext());
            this.readerProxy.setStepContext(this.stepContext);
            this.processorProxy.setStepContext(this.stepContext);
            this.writerProxy.setStepContext(this.stepContext);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Initialize checkpoint manager with commit-interval=" + commitInterval);
            }
            this.checkpointManager = new CheckpointManager(this.readerProxy, this.writerProxy, this.chkptAlg, commitInterval, this.jobExecutionImpl.getExecutionId(), this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
            this.skipHandler = new SkipHandler(this.chunk, this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
            for (SkipListenerProxy skipListenerProxy : this.skipListeners) {
                this.skipHandler.addSkipListener(skipListenerProxy);
            }
            this.retryHandler = new RetryHandler(this.chunk, this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
            for (RetryListenerProxy retryListenerProxy : this.retryListeners) {
                this.retryHandler.addRetryListener(retryListenerProxy);
            }
            this._persistenceManagerService = (IPersistenceManagerService)this.servicesManager.getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
            this.readerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "READER");
            data = this._persistenceManagerService.getData(2, this.readerChkptDK);
            try {
                if (data.size() >= 1) {
                    this.readerChkptData = (CheckpointData)data.get(0);
                    byte[] byArray = this.readerChkptData.getRestartToken();
                    ByteArrayInputStream readerChkptBA = new ByteArrayInputStream(byArray);
                    TCCLObjectInputStream readerOIS = null;
                    try {
                        readerOIS = new TCCLObjectInputStream(readerChkptBA);
                        this.readerProxy.openReader(readerOIS.readObject());
                        readerOIS.close();
                        break block40;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                this.readerChkptData = null;
                this.readerProxy.openReader(null);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("Expected CheckpointData but found" + data.get(0));
            }
        }
        this.writerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "WRITER");
        data = this._persistenceManagerService.getData(2, this.writerChkptDK);
        try {
            this.writerChkptData = (CheckpointData)data.get(0);
            byte[] byArray = this.writerChkptData.getRestartToken();
            ByteArrayInputStream writerChkptBA = new ByteArrayInputStream(byArray);
            TCCLObjectInputStream writerOIS = null;
            try {
                writerOIS = new TCCLObjectInputStream(writerChkptBA);
                this.writerProxy.openWriter(writerOIS.readObject());
                writerOIS.close();
            }
            catch (Exception ex) {
                throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Expected Checkpoint but found" + data.get(0));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.writerChkptData = null;
            this.writerProxy.openWriter(null);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    @Override
    public void stop() {
        this.stepContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING));
    }

    boolean skipReadException(Exception e) {
        try {
            this.skipHandler.handleException(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean retryReadException(Exception e) {
        try {
            this.retryHandler.handleNoRollbackExceptionRead(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean skipProcessException(Exception e, Object record) {
        try {
            this.skipHandler.handleExceptionWithRecordProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean retryProcessException(Exception e, Object record) {
        try {
            this.retryHandler.handleNoRollbackExceptionWithRecordProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean skipWriteException(Exception e, List<Object> chunkToWrite) {
        Object[] writeObjs = chunkToWrite.toArray();
        for (int i = 0; i < writeObjs.length; ++i) {
            try {
                this.skipHandler.handleExceptionWithRecordWrite(e, writeObjs[i]);
                continue;
            }
            catch (BatchContainerRuntimeException bcre) {
                return false;
            }
        }
        return true;
    }

    boolean retryWriteException(Exception e, List<Object> chunkToWrite) {
        Object[] writeObjs = chunkToWrite.toArray();
        for (int i = 0; i < writeObjs.length; ++i) {
            try {
                this.retryHandler.handleNoRollbackExceptionRead(e);
                continue;
            }
            catch (BatchContainerRuntimeException bcre) {
                return false;
            }
        }
        return true;
    }

    private List<Property> filterChunkProperties(List<Property> chunkProps, CHUNK_ARTIFACT filter) {
        if (chunkProps == null) {
            return null;
        }
        ArrayList<Property> filteredPropertyList = new ArrayList<Property>();
        ObjectFactory jslObjectFactory = new ObjectFactory();
        for (Property prop : chunkProps) {
            String target = prop.getTarget();
            if (target != null && !target.contains(filter.getChunkArtifactType())) continue;
            Property filteredProp = jslObjectFactory.createProperty();
            filteredProp.setName(prop.getName());
            filteredProp.setValue(prop.getValue());
            filteredProp.setTarget(prop.getTarget());
            filteredPropertyList.add(filteredProp);
        }
        return filteredPropertyList;
    }

    private class ItemStatus {
        private boolean skipped = false;
        private boolean finished = false;
        private boolean checkPointed = false;

        private ItemStatus() {
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public void setSkipped(boolean skipped) {
            this.skipped = skipped;
        }

        public boolean isCheckPointed() {
            return this.checkPointed;
        }

        public void setCheckPointed(boolean checkPointed) {
            this.checkPointed = checkPointed;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }
    }

    private static enum CHUNK_ARTIFACT {
        READER("reader"),
        PROCESSOR("processor"),
        WRITER("writer");

        private String chunkArtifactType;

        private CHUNK_ARTIFACT(String chunkArtifactType) {
            this.chunkArtifactType = chunkArtifactType;
        }

        public String getChunkArtifactType() {
            return this.chunkArtifactType;
        }
    }
}

