/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.util;

import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.impl.JobControllerImpl;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.services.IBatchKernelService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchWorkUnit
implements Runnable {
    private String CLASSNAME = BatchWorkUnit.class.getName();
    private Logger logger = Logger.getLogger(BatchWorkUnit.class.getPackage().getName());
    private RuntimeJobExecutionImpl jobExecutionImpl = null;
    private IBatchKernelService batchKernel = null;
    private final JobControllerImpl controller;
    private PartitionAnalyzerProxy analyzerProxy;
    private boolean notifyCallbackWhenDone;

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobExecutionImpl jobExecutionImpl) {
        this(batchKernel, jobExecutionImpl, null, true);
    }

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobExecutionImpl jobExecutionImpl, PartitionAnalyzerProxy analyzerProxy, boolean notifyCallbackWhenDone) {
        this.setBatchKernel(batchKernel);
        this.setJobExecutionImpl(jobExecutionImpl);
        this.analyzerProxy = analyzerProxy;
        this.setNotifyCallbackWhenDone(notifyCallbackWhenDone);
        this.controller = new JobControllerImpl(this.getJobExecutionImpl());
        this.controller.setAnalyzerProxy(this.analyzerProxy);
    }

    public JobControllerImpl getController() {
        return this.controller;
    }

    @Override
    public void run() {
        String method = "run";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.CLASSNAME, method);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("==========================================================");
            this.logger.info("Invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.info("==========================================================");
        }
        try {
            this.controller.executeJob();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Exception when invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
                this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            }
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
            throw new BatchContainerRuntimeException("This job failed unexpectedly.", e);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("==========================================================");
            this.logger.info("Done invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.info("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            this.logger.info("==========================================================");
        }
        if (this.isNotifyCallbackWhenDone()) {
            this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.CLASSNAME, method);
        }
    }

    public void setAnalyzerProxy(PartitionAnalyzerProxy analyzerProxy) {
        this.analyzerProxy = analyzerProxy;
    }

    public PartitionAnalyzerProxy getAnalyzerProxy() {
        return this.analyzerProxy;
    }

    private String getBatchStatus() {
        return this.jobExecutionImpl.getJobContext().getBatchStatus();
    }

    private String getExitStatus() {
        return this.jobExecutionImpl.getJobContext().getExitStatus();
    }

    public void setBatchKernel(IBatchKernelService batchKernel) {
        this.batchKernel = batchKernel;
    }

    public IBatchKernelService getBatchKernel() {
        return this.batchKernel;
    }

    public void setJobExecutionImpl(RuntimeJobExecutionImpl jobExecutionImpl) {
        this.jobExecutionImpl = jobExecutionImpl;
    }

    public RuntimeJobExecutionImpl getJobExecutionImpl() {
        return this.jobExecutionImpl;
    }

    public void setNotifyCallbackWhenDone(boolean notifyCallbackWhenDone) {
        this.notifyCallbackWhenDone = notifyCallbackWhenDone;
    }

    public boolean isNotifyCallbackWhenDone() {
        return this.notifyCallbackWhenDone;
    }
}

