/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.tck.bridge;

import com.ibm.batch.container.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.tck.bridge.IJobEndCallbackService;
import com.ibm.batch.tck.spi.JobEndCallback;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobEndCallbackManagerImpl
implements IJobEndCallbackService {
    private static final String sourceClass = JobEndCallbackManagerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Set<JobEndCallback> callbacks = new HashSet<JobEndCallback>();

    public synchronized void registerJobEndCallback(JobEndCallback callback) {
        this.callbacks.add(callback);
    }

    public synchronized void deregisterJobEndCallback(JobEndCallback callback) {
        this.callbacks.remove(callback);
    }

    @Override
    public synchronized void done(long jobExecutionId) {
        JobEndCallback[] arr;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Firing callbacks for job execution id: " + jobExecutionId);
        }
        for (JobEndCallback callback : arr = this.callbacks.toArray(new JobEndCallback[0])) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Next registered callback: " + callback);
            }
            callback.done(jobExecutionId);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Done firing callbacks for job execution id: " + jobExecutionId);
        }
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }
}

