/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.services.IBatchThreadPoolService;
import com.ibm.batch.container.services.ParallelTaskResult;
import com.ibm.batch.container.services.impl.JSEResultAdapter;
import com.ibm.batch.container.util.BatchWorkUnit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSEThreadPoolServiceImpl
implements IBatchThreadPoolService {
    private static final String sourceClass = JSEThreadPoolServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private int _poolSize = 1;
    private ExecutorService _cachedThreadPool;
    private ScheduledThreadPoolExecutor _scheduledThreadPool;

    @Override
    public void init(IBatchConfig pgcConfig) throws BatchContainerServiceException {
        String method = "init";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        this._cachedThreadPool = Executors.newCachedThreadPool();
        this._scheduledThreadPool = new ScheduledThreadPoolExecutor(this._poolSize);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
        String method = "shutdown";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        this._cachedThreadPool.shutdownNow();
        this._scheduledThreadPool.shutdownNow();
        this._cachedThreadPool = null;
        this._scheduledThreadPool = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    public void executeJob(BatchWorkUnit job) {
        String method = "executeJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        this._cachedThreadPool.execute(job);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    public void executeTask(BatchWorkUnit work, Object config) {
        String method = "executeTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        this._cachedThreadPool.execute(work);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    public void setPoolSize(int poolSize) {
        if (poolSize > 0) {
            this._poolSize = poolSize;
        }
    }

    @Override
    public ParallelTaskResult executeParallelTask(BatchWorkUnit work, Object config) {
        String method = "executeParallelTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        Future<?> result = this._cachedThreadPool.submit(work);
        JSEResultAdapter taskResult = new JSEResultAdapter(result);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return taskResult;
    }
}

