/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.services.IBatchArtifactFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;

public class JSEBatchArtifactFactoryImpl
implements IBatchArtifactFactory,
XMLStreamConstants {
    private static final Logger logger = Logger.getLogger(JSEBatchArtifactFactoryImpl.class.getName());
    private static final String CLASSNAME = JSEBatchArtifactFactoryImpl.class.getName();
    private static final String BATCH_XML = "META-INF/batch.xml";
    private static final QName BATCH_ROOT_ELEM = new QName("batch-artifacts");
    private boolean loaded = false;
    private volatile ArtifactMap artifactMap = null;

    @Override
    public Object load(String batchId) {
        String methodName = "load";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, methodName, "Loading batch artifact id = " + batchId);
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TCCL = " + tccl);
        }
        this.initArtifactMapFromClassLoader(tccl);
        Object loadedArtifact = this.artifactMap.getArtifactById(batchId);
        if (loadedArtifact == null) {
            throw new IllegalArgumentException("Could not load any artifacts with batch id=" + batchId);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, methodName, "For batch artifact id = " + batchId + ", loaded artifact instance: " + loadedArtifact + " of type: " + loadedArtifact.getClass().getCanonicalName());
        }
        return loadedArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initArtifactMapFromClassLoader(ClassLoader loader) {
        ArtifactMap tempMap = this.artifactMap;
        if (tempMap == null) {
            JSEBatchArtifactFactoryImpl jSEBatchArtifactFactoryImpl = this;
            synchronized (jSEBatchArtifactFactoryImpl) {
                tempMap = this.artifactMap;
                if (tempMap == null) {
                    tempMap = new ArtifactMap();
                    InputStream is = this.getBatchXMLStreamFromClassLoader(loader);
                    this.artifactMap = this.populateArtifactMapFromStream(tempMap, is);
                }
            }
        }
    }

    protected InputStream getBatchXMLStreamFromClassLoader(ClassLoader loader) {
        InputStream is = loader.getResourceAsStream(BATCH_XML);
        if (is == null) {
            throw new IllegalStateException("Unable to load batch.xml");
        }
        return is;
    }

    protected ArtifactMap populateArtifactMapFromStream(ArtifactMap tempMap, InputStream is) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            int event;
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(is);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Loaded XMLStreamReader = " + xmlStreamReader);
            }
            boolean processedRoot = false;
            while (xmlStreamReader.hasNext() && (event = xmlStreamReader.next()) != 8) {
                if (event != 1) continue;
                if (!processedRoot) {
                    QName rootQName = xmlStreamReader.getName();
                    if (!rootQName.equals(BATCH_ROOT_ELEM)) {
                        throw new IllegalStateException("Expecting document with root element QName: " + BATCH_ROOT_ELEM + ", but found root element with QName: " + rootQName);
                    }
                    processedRoot = true;
                    continue;
                }
                String annotationShortName = xmlStreamReader.getLocalName();
                String id = xmlStreamReader.getAttributeValue(null, "id");
                String className = xmlStreamReader.getAttributeValue(null, "class");
                tempMap.addEntry(annotationShortName, id, className);
                while (event != 2) {
                    event = xmlStreamReader.next();
                }
            }
            xmlStreamReader.close();
            is.close();
            return tempMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    private class ArtifactMap {
        private Map<String, Class> idToArtifactClassMap = new HashMap<String, Class>();
        private Map<String, List<String>> idToArtifactTypeListMap = new HashMap<String, List<String>>();

        private ArtifactMap() {
        }

        private void addEntry(String batchTypeName, String id, String className) {
            try {
                if (!this.idToArtifactClassMap.containsKey(id)) {
                    Class<?> artifactClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                    this.idToArtifactClassMap.put(id, artifactClass);
                    ArrayList<String> typeList = new ArrayList<String>();
                    typeList.add(batchTypeName);
                    this.idToArtifactTypeListMap.put(id, typeList);
                } else {
                    Class<?> artifactClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                    if (!this.idToArtifactClassMap.get(id).equals(artifactClass)) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            Class alreadyLoaded = this.idToArtifactClassMap.get(id);
                            logger.severe("Attempted to load batch artifact with id: " + id + ", and className: " + className + ".   Found: " + artifactClass + ", however the artifact id: " + id + " is already associated with: " + alreadyLoaded + ", of className: " + alreadyLoaded.getCanonicalName());
                        }
                        throw new IllegalArgumentException("Already loaded a different class for id = " + id);
                    }
                    List<String> typeList = this.idToArtifactTypeListMap.get(id);
                    typeList.add(batchTypeName);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Object getArtifactById(String id) {
            Object artifactInstance = null;
            try {
                Class clazz = this.idToArtifactClassMap.get(id);
                if (clazz != null) {
                    artifactInstance = this.idToArtifactClassMap.get(id).newInstance();
                }
            }
            catch (IllegalAccessException e) {
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + id, e);
            }
            catch (InstantiationException e) {
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + id, e);
            }
            return artifactInstance;
        }

        private List<String> getBatchTypeList(String id) {
            return this.idToArtifactTypeListMap.get(id);
        }
    }
}

