/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.exception.TransactionManagementException;
import com.ibm.batch.container.services.ITransactionManagementService;
import com.ibm.batch.container.transaction.impl.DefaultNonTransactionalManager;
import com.ibm.batch.container.transaction.impl.JTAUserTransactionAdapter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.context.StepContext;
import javax.batch.runtime.spi.TransactionManagerSPI;

public class BatchTransactionServiceImpl
implements ITransactionManagementService {
    private static final String CLASSNAME = BatchTransactionServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    public static final String JAVAX_TRANSACTION_MANAGER_SPI_PROPNAME = "javax.batch.transaction.manager.spi";
    private IBatchConfig batchConfig = null;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.entering(CLASSNAME, "init", batchConfig);
        this.batchConfig = batchConfig;
        logger.exiting(CLASSNAME, "init");
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
        logger.entering(CLASSNAME, "shutdown");
        logger.fine("do nothing");
        logger.exiting(CLASSNAME, "shutdown");
    }

    @Override
    public TransactionManagerSPI getTransactionManager(StepContext<?, ?> stepContext) throws TransactionManagementException {
        TransactionManagerSPI transactionManager;
        logger.entering(CLASSNAME, "getTransactionManager", stepContext);
        if (this.isStepInLocalTrans(stepContext)) {
            logger.fine("default no-op local transaction manager");
            transactionManager = new DefaultNonTransactionalManager();
        } else {
            transactionManager = this.getTransactionManager();
        }
        int timeout = this.getTransactionTimeout(stepContext);
        logger.log(Level.FINE, "transaction timeout {0}", timeout);
        try {
            transactionManager.setTransactionTimeout(timeout);
        }
        catch (Exception e) {
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "getTransactionManager", transactionManager);
        return transactionManager;
    }

    private boolean isStepInLocalTrans(StepContext<?, ?> stepContext) {
        logger.entering(CLASSNAME, "isStepInLocalTrans", stepContext);
        Properties p = stepContext.getProperties();
        boolean inLocalTx = true;
        if (p != null && !p.isEmpty()) {
            String globalMode = p.getProperty("javax.transaction.global.mode");
            logger.log(Level.FINE, "javax.transaction.global.mode = {0}", globalMode);
            if (globalMode != null && !globalMode.isEmpty() && globalMode.equalsIgnoreCase("true")) {
                inLocalTx = false;
            }
        }
        logger.exiting(CLASSNAME, "isStepInLocalTrans", inLocalTx);
        return inLocalTx;
    }

    private int getTransactionTimeout(StepContext<?, ?> stepContext) {
        logger.entering(CLASSNAME, "getTransactionTimeout", stepContext);
        Properties p = stepContext.getProperties();
        int timeout = 180;
        if (p != null && !p.isEmpty()) {
            String to = p.getProperty("javax.transaction.global.timeout");
            logger.log(Level.FINE, "javax.transaction.global.timeout = {0}", to);
            if (to != null && !to.isEmpty()) {
                timeout = Integer.parseInt(to, 10);
            }
        }
        logger.exiting(CLASSNAME, "getTransactionTimeout", timeout);
        return timeout;
    }

    private TransactionManagerSPI getTransactionManager() {
        logger.entering(CLASSNAME, "getTransactionObject");
        TransactionManagerSPI transactionManager = null;
        transactionManager = this.getTransactionObjectFromJvmProperties();
        if (transactionManager == null && !this.batchConfig.isJ2seMode()) {
            logger.fine("getting transaction object from JNDI java:comp/UserTransaction");
            transactionManager = new JTAUserTransactionAdapter("java:comp/UserTransaction");
        }
        if (transactionManager == null && this.batchConfig.isJ2seMode()) {
            logger.fine("defaulting back to no op transaction manager");
            transactionManager = new DefaultNonTransactionalManager();
        }
        logger.exiting(CLASSNAME, "getTransactionObject", transactionManager);
        return transactionManager;
    }

    private TransactionManagerSPI getTransactionObjectFromJvmProperties() {
        logger.entering(CLASSNAME, "getTransactionObjectFromJvmProperties");
        TransactionManagerSPI transactionObj = null;
        String className = System.getProperty(JAVAX_TRANSACTION_MANAGER_SPI_PROPNAME);
        logger.log(Level.FINE, "javax.batch.transaction.manager = {0}", className);
        if (className != null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                transactionObj = (TransactionManagerSPI)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new TransactionManagementException(e);
            }
            catch (IllegalAccessException e) {
                throw new TransactionManagementException(e);
            }
            catch (InstantiationException e) {
                throw new TransactionManagementException(e);
            }
            catch (ClassCastException e) {
                throw new TransactionManagementException("Class:" + className + " from JVM property " + JAVAX_TRANSACTION_MANAGER_SPI_PROPNAME + "must implement the TransactionManagerSPI interface.", e);
            }
        }
        logger.exiting(CLASSNAME, "getTransactionObjectFromJvmProperties", transactionObj);
        return transactionObj;
    }
}

