/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.exception.PersistenceException;
import com.ibm.batch.container.services.IPersistenceDataKey;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.status.JobStatus;
import com.ibm.batch.container.status.JobStatusKey;
import com.ibm.batch.container.status.StepStatus;
import com.ibm.batch.container.status.StepStatusKey;
import com.ibm.ws.batch.container.checkpoint.CheckpointData;
import com.ibm.ws.batch.container.checkpoint.CheckpointDataKey;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractPersistenceManagerImpl
implements IPersistenceManagerService {
    IBatchConfig batchConfig = null;

    @Override
    public void createData(int storeDestination, IPersistenceDataKey key, Serializable value) throws PersistenceException {
        if (storeDestination == 0) {
            this._createJobStatus((JobStatusKey)key, (JobStatus)value);
        } else if (storeDestination == 1) {
            this._createStepStatus((StepStatusKey)key, (StepStatus)value);
        } else if (storeDestination == 2) {
            this._createCheckpointData((CheckpointDataKey)key, (CheckpointData)value);
        } else {
            throw new IllegalArgumentException("Only support job status & step status & checkpoint persistence through this service.");
        }
    }

    @Override
    public void deleteData(int storeDestination, IPersistenceDataKey key) throws PersistenceException {
        if (storeDestination == 0) {
            this._deleteJobStatus((JobStatusKey)key);
        } else if (storeDestination == 1) {
            this._deleteStepStatus((StepStatusKey)key);
        } else if (storeDestination == 2) {
            this._deleteCheckpointData((CheckpointDataKey)key);
        } else {
            throw new IllegalArgumentException("Only support job status & step status & checkpoint persistence through this service.");
        }
    }

    @Override
    public List getData(int storeDestination, IPersistenceDataKey key) throws PersistenceException {
        if (storeDestination == 0) {
            return this._getJobStatus((JobStatusKey)key);
        }
        if (storeDestination == 1) {
            return this._getStepStatus((StepStatusKey)key);
        }
        if (storeDestination == 2) {
            return this._getCheckpointData((CheckpointDataKey)key);
        }
        throw new IllegalArgumentException("Only support job status & step status & checkpoint persistence through this service.");
    }

    @Override
    public void updateData(int storeDestination, IPersistenceDataKey key, Serializable value) throws PersistenceException {
        if (storeDestination == 0) {
            this._updateJobStatus((JobStatusKey)key, (JobStatus)value);
        } else if (storeDestination == 1) {
            this._updateStepStatus((StepStatusKey)key, (StepStatus)value);
        } else if (storeDestination == 2) {
            this._updateCheckpointData((CheckpointDataKey)key, (CheckpointData)value);
        } else {
            throw new IllegalArgumentException("Only support job status & step status & checkpoint persistence through this service.");
        }
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        this.batchConfig = batchConfig;
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    protected abstract void _createStepStatus(StepStatusKey var1, StepStatus var2);

    protected abstract void _createJobStatus(JobStatusKey var1, JobStatus var2);

    protected abstract void _createCheckpointData(CheckpointDataKey var1, CheckpointData var2);

    protected abstract List<StepStatus> _getStepStatus(StepStatusKey var1);

    protected abstract List<JobStatus> _getJobStatus(JobStatusKey var1);

    protected abstract List<CheckpointData> _getCheckpointData(CheckpointDataKey var1);

    protected abstract void _updateStepStatus(StepStatusKey var1, StepStatus var2);

    protected abstract void _updateJobStatus(JobStatusKey var1, JobStatus var2);

    protected abstract void _updateCheckpointData(CheckpointDataKey var1, CheckpointData var2);

    protected abstract void _deleteStepStatus(StepStatusKey var1);

    protected abstract void _deleteJobStatus(JobStatusKey var1);

    protected abstract void _deleteCheckpointData(CheckpointDataKey var1);
}

