/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.impl.AbstractPersistenceManagerImpl;
import com.ibm.batch.container.status.JobStatus;
import com.ibm.batch.container.status.JobStatusKey;
import com.ibm.batch.container.status.StepStatus;
import com.ibm.batch.container.status.StepStatusKey;
import com.ibm.ws.batch.container.checkpoint.CheckpointData;
import com.ibm.ws.batch.container.checkpoint.CheckpointDataKey;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractMapBasedPersistenceManagerImpl
extends AbstractPersistenceManagerImpl
implements IPersistenceManagerService {
    private static final String CLASSNAME = AbstractMapBasedPersistenceManagerImpl.class.getName();
    private static Logger logger = Logger.getLogger(AbstractMapBasedPersistenceManagerImpl.class.getPackage().getName());
    protected static boolean _isInited = false;
    protected static Hashtable<Long, JobStatus> _jobStatusStore = null;
    protected static Hashtable<String, StepStatus> _stepStatusStore = null;
    protected static Hashtable<String, CheckpointData> _checkpointStore = null;
    protected static Object _jobStoreLock = new Object();
    protected static Object _stepStoreLock = new Object();
    protected static Object _checkpointStoreLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _createCheckpointData(CheckpointDataKey key, CheckpointData value) {
        Object object = _checkpointStoreLock;
        synchronized (object) {
            if (!_checkpointStore.containsKey(key.getKeyPrimitive())) {
                _checkpointStore.put(key.getKeyPrimitive(), value);
                this._saveStore(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _createStepStatus(StepStatusKey key, StepStatus value) {
        Object object = _stepStoreLock;
        synchronized (object) {
            if (_stepStatusStore.containsKey(key.getKeyPrimitive())) {
                throw new IllegalStateException("Already have step entry for key = " + key);
            }
            _stepStatusStore.put(key.getKeyPrimitive(), value);
            this._saveStore(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _createJobStatus(JobStatusKey key, JobStatus value) {
        Object object = _jobStoreLock;
        synchronized (object) {
            if (_jobStatusStore.containsKey(key.getKeyPrimitive())) {
                throw new IllegalStateException("Entry with key = " + key.getKeyPrimitive() + " already exists.");
            }
            _jobStatusStore.put(key.getKeyPrimitive(), value);
            this._saveStore(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<JobStatus> _getJobStatus(JobStatusKey key) {
        ArrayList<JobStatus> statusList = new ArrayList<JobStatus>();
        Object object = _jobStoreLock;
        synchronized (object) {
            if (_jobStatusStore.containsKey(key.getKeyPrimitive())) {
                JobStatus status = _jobStatusStore.get(key.getKeyPrimitive());
                statusList.add(status);
            }
        }
        return statusList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<StepStatus> _getStepStatus(StepStatusKey key) {
        ArrayList<StepStatus> statusList = new ArrayList<StepStatus>();
        Object object = _stepStoreLock;
        synchronized (object) {
            if (_stepStatusStore.containsKey(key.getKeyPrimitive())) {
                StepStatus status = _stepStatusStore.get(key.getKeyPrimitive());
                statusList.add(status);
            }
        }
        return statusList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _deleteCheckpointData(CheckpointDataKey key) {
        Object object = _checkpointStoreLock;
        synchronized (object) {
            if (_checkpointStore.containsKey(key.getCommaSeparatedKey())) {
                _checkpointStore.remove(key.getCommaSeparatedKey());
                this._saveStore(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _deleteStepStatus(StepStatusKey key) {
        Object object = _stepStoreLock;
        synchronized (object) {
            if (_stepStatusStore.containsKey(key.getKeyPrimitive())) {
                _stepStatusStore.remove(key.getKeyPrimitive());
                this._saveStore(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _deleteJobStatus(JobStatusKey key) {
        Object object = _jobStoreLock;
        synchronized (object) {
            if (_jobStatusStore.containsKey(key.getKeyPrimitive())) {
                _jobStatusStore.remove(key.getKeyPrimitive());
                this._saveStore(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<CheckpointData> _getCheckpointData(CheckpointDataKey key) {
        ArrayList<CheckpointData> dataList = new ArrayList<CheckpointData>();
        Object object = _checkpointStoreLock;
        synchronized (object) {
            if (_checkpointStore.containsKey(key.getCommaSeparatedKey())) {
                CheckpointData data = _checkpointStore.get(key.getCommaSeparatedKey());
                dataList.add(data);
            }
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateCheckpointData(CheckpointDataKey key, CheckpointData value) {
        Object object = _checkpointStoreLock;
        synchronized (object) {
            if (_checkpointStore.containsKey(key.getCommaSeparatedKey())) {
                CheckpointData data = _checkpointStore.get(key.getCommaSeparatedKey());
                data.setRestartToken(value.getRestartToken());
                data = value;
                this._saveStore(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateStepStatus(StepStatusKey key, StepStatus value) {
        Object object = _stepStoreLock;
        synchronized (object) {
            if (!_stepStatusStore.containsKey(key.getKeyPrimitive())) {
                throw new IllegalStateException("Could not find entry for key = " + key.getKeyPrimitive());
            }
            _stepStatusStore.put(key.getKeyPrimitive(), value);
            this._saveStore(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateJobStatus(JobStatusKey key, JobStatus value) {
        Object object = _jobStoreLock;
        synchronized (object) {
            if (!_jobStatusStore.containsKey(key.getKeyPrimitive())) {
                throw new IllegalStateException("Could not find entry for key = " + key.getKeyPrimitive());
            }
            _jobStatusStore.put(key.getKeyPrimitive(), value);
            this._saveStore(0);
        }
    }

    @Override
    public void init(IBatchConfig pgcConfig) throws BatchContainerServiceException {
        super.init(pgcConfig);
        this._loadDataStores();
    }

    protected abstract void _loadDataStores();

    protected abstract void _saveStore(int var1);

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }
}

