/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services;

import com.ibm.batch.container.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.impl.BatchConfigImpl;
import com.ibm.batch.container.impl.BatchKernelImpl;
import com.ibm.batch.container.services.IBatchServiceBase;
import com.ibm.batch.container.services.IBatchThreadPoolService;
import com.ibm.batch.container.services.impl.BatchTransactionServiceImpl;
import com.ibm.batch.container.services.impl.JDBCPersistenceManagerImpl;
import com.ibm.batch.container.services.impl.JSEBatchArtifactFactoryImpl;
import com.ibm.batch.container.services.impl.JSEThreadPoolServiceImpl;
import com.ibm.batch.container.services.impl.JobIdManagerImpl;
import com.ibm.batch.container.services.impl.JobStatusManagerImpl;
import com.ibm.batch.container.tck.bridge.JobEndCallbackManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServicesManager {
    private static final String sourceClass = ServicesManager.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final String BATCH_CONTAINER_CONFIG_FILE = "batch-services.properties";
    public static final String PERSISTENCE_MANAGEMENT_SERVICE = "PERSISTENCE_MANAGEMENT_SERVICE";
    public static final String JOB_STATUS_MANAGEMENT_SERVICE = "JOB_STATUS_MANAGEMENT_SERVICE";
    public static final String BATCH_THREADPOOL_SERVICE = "BATCH_THREADPOOL_SERVICE";
    public static final String CONFIGURATION_SERVICE = "CONFIGURATION_SERVICE";
    public static final String CONTAINER_LOGGER_CONFIG_SERVICE = "CONTAINER_LOGGER_CONFIG_SERVICE";
    public static final String CONTAINER_ARTIFACT_FACTORY_SERVICE = "CONTAINER_ARTIFACT_FACTORY_SERVICE";
    public static final String BATCH_KERNEL_SERVICE = "BATCH_KERNEL_SERVICE";
    public static final String JOB_ID_MANAGEMENT_SERVICE = "JOB_ID_MANAGEMENT_SERVICE";
    public static final String JOB_OP_SERVICE = "JOB_OP_SERVICE";
    public static final String CALLBACK_SERVICE = "CALLBACK_SERVICE";
    public static final String TRANSACTION_SERVICE = "TRANSACTION_SERVICE";
    public static final String J2SE_MODE = "J2SE_MODE";
    private static final String JNDI_NAME = "JNDI_NAME";
    public static final String WORK_MANAGER_JNDI_NAME = "WORK_MANAGER_JNDI_NAME";
    private static final String DEFAULT_PERSISTENCE_MGR_CLASS = "com.ibm.batch.container.services.impl.InMemoryPersistenceManagerImpl";
    private static final String DEFAULT_BATCH_THREADPOOL_SERVICE = "com.ibm.batch.container.services.impl.JSEThreadPoolImpl";
    private static final String DEFAULT_CONFIGURATION_SERVICE = "com.ibm.ws.gridcontainer.services.impl.DefaultConfigurationRepositoryServiceImpl";
    private static final String DEFAULT_CONTAINER_LOGGER_CONFIG_SERVICE = "com.ibm.ws.gridcontainer.services.impl.DefaultContainerLoggerConfigurationServiceImpl";
    private static final String DEFAULT_CONTAINER_ARTIFACT_FACTORY_SERVICE = "com.ibm.batch.services.impl.JSEBatchArtifactFactoryImpl";
    private static final String DEFAULT_BATCH_KERNEL_SERVICE = "com.ibm.batch.container.impl.BatchKernelImpl";
    private static final String DEFAULT_JOBSTATUS_MRG_SERVICE = "com.ibm.batch.container.services.impl.JobStatusManagerImpl";
    private static final String DEFAULT_JOBID_MRG_SERVICE = "com.ibm.batch.container.services.impl.JobIdManagerImpl";
    private static final String DEFAULT_JOB_OP_SERVICE = "com.ibm.batch.container.services.impl.JobOperatorImpl";
    private static final String DEFAULT_CALLBACK_SERVICE = "com.ibm.batch.container.tck.bridge.JobEndCallbackManagerImpl";
    private static final String DEFAULT_TRANSACTION_SERVICE = "com.ibm.batch.container.services.impl.BatchTransactionServiceImpl";
    private static final String JDBC_DRIVER = "JDBC_DRIVER";
    private static final String JDBC_URL = "JDBC_URL";
    private static final String DB_USER = "DB_USER";
    private static final String DB_PASSWORD = "DB_PWD";
    private String persistenceMgrClass = null;
    private String threadpoolServiceClass = null;
    private String configServiceClass = null;
    private String batchArtifactFactoryClass = null;
    private String containerKernelClass = null;
    private String jobstatusMgrClass = null;
    private String jobIdMgrClass = null;
    private String jobOpClass = null;
    private String callbackClass = null;
    private String transactionClass = null;
    private boolean isInited = false;
    private Properties batchContainerProps = null;
    private static ServicesManager servicesManager;
    private static BatchConfigImpl batchConfig;
    private String batchConfigDir = null;
    private ConcurrentHashMap<String, IBatchServiceBase> _serviceRegistry = new ConcurrentHashMap();

    private ServicesManager(Properties servicesList) {
        this.init(servicesList);
    }

    private ServicesManager() {
        this.init(null);
    }

    private void init(Properties prop) {
        String sourceMethod = "init";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod);
        }
        if (!this.isInited) {
            if (this.batchContainerProps != null) {
                this.batchContainerProps = prop;
            }
            this.batchConfigDir = System.getProperty("batch.container.dir");
            if (this.batchConfigDir == null) {
                logger.info("batch.container.dir has not been set");
                String currentDir = System.getProperty("user.dir");
                this.batchConfigDir = currentDir + File.separator + ".." + File.separator + "JSR352.Runtime" + File.separator + "bin" + File.separator + "META-INF" + File.separator + "services";
                logger.info("batch.container.dir is set to default location " + this.batchConfigDir);
            } else {
                logger.info("batch.container.dir set to " + this.batchConfigDir);
            }
            batchConfig = new BatchConfigImpl();
            batchConfig.setBatchContainerHome(this.batchConfigDir);
            this.loadServicesList();
            this.isInited = true;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    private void loadServicesList() {
        InputStream batchServicesListInputStream = this.getClass().getResourceAsStream("/META-INF/services/batch-services.properties");
        if (this.batchContainerProps == null) {
            this.batchContainerProps = new Properties();
        }
        if (batchServicesListInputStream != null) {
            try {
                logger.fine("Batch Services File exists! loading it..");
                this.batchContainerProps.load(batchServicesListInputStream);
                batchServicesListInputStream.close();
            }
            catch (IOException e) {
                logger.info("Error loading /META-INF/services/batch-services.properties IOException=" + e.toString());
            }
            catch (Exception e) {
                logger.info("Error loading /META-INF/services/batch-services.properties Exception=" + e.toString());
            }
        } else {
            logger.info("Could not find batch services file: /META-INF/services/batch-services.properties");
        }
        this.persistenceMgrClass = this.batchContainerProps.getProperty(PERSISTENCE_MANAGEMENT_SERVICE, DEFAULT_PERSISTENCE_MGR_CLASS);
        this.jobstatusMgrClass = this.batchContainerProps.getProperty(JOB_STATUS_MANAGEMENT_SERVICE, DEFAULT_JOBSTATUS_MRG_SERVICE);
        this.threadpoolServiceClass = this.batchContainerProps.getProperty(BATCH_THREADPOOL_SERVICE, DEFAULT_BATCH_THREADPOOL_SERVICE);
        this.configServiceClass = this.batchContainerProps.getProperty(CONFIGURATION_SERVICE, DEFAULT_CONFIGURATION_SERVICE);
        this.containerKernelClass = this.batchContainerProps.getProperty(BATCH_KERNEL_SERVICE, DEFAULT_BATCH_KERNEL_SERVICE);
        this.jobIdMgrClass = this.batchContainerProps.getProperty(JOB_ID_MANAGEMENT_SERVICE, DEFAULT_JOBID_MRG_SERVICE);
        this.jobOpClass = this.batchContainerProps.getProperty(JOB_OP_SERVICE, DEFAULT_JOB_OP_SERVICE);
        this.callbackClass = this.batchContainerProps.getProperty(CALLBACK_SERVICE, DEFAULT_CALLBACK_SERVICE);
        this.transactionClass = this.batchContainerProps.getProperty(TRANSACTION_SERVICE, DEFAULT_TRANSACTION_SERVICE);
        this.batchArtifactFactoryClass = this.batchContainerProps.getProperty(CONTAINER_ARTIFACT_FACTORY_SERVICE, DEFAULT_CONTAINER_ARTIFACT_FACTORY_SERVICE);
        if (this.batchContainerProps.getProperty(J2SE_MODE) != null && this.batchContainerProps.getProperty(J2SE_MODE).equalsIgnoreCase("true")) {
            batchConfig.setJ2seMode(true);
        }
        batchConfig.setJndiName(this.batchContainerProps.getProperty(JNDI_NAME));
        batchConfig.setJdbcDriver(this.batchContainerProps.getProperty(JDBC_DRIVER));
        batchConfig.setJdbcUrl(this.batchContainerProps.getProperty(JDBC_URL));
        batchConfig.setDbUser(this.batchContainerProps.getProperty(DB_USER));
        batchConfig.setDbPassword(this.batchContainerProps.getProperty(DB_PASSWORD));
        batchConfig.setWorkManagerJndiName(this.batchContainerProps.getProperty(WORK_MANAGER_JNDI_NAME));
    }

    public void shutdown() {
        String sourceMethod = "shutdown";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    public IBatchServiceBase getService(ServiceType serviceType) throws BatchContainerServiceException {
        String sourceMethod = "getService";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod + ", serviceType=" + (Object)((Object)serviceType));
        }
        IBatchServiceBase service = null;
        if (!this.isInited) {
            Exception e = new Exception("ServicesManager not inited!");
            throw new BatchContainerServiceException("ServicesManager not inited!", e);
        }
        String key = "";
        switch (serviceType) {
            case PERSISTENCE_MANAGEMENT_SERVICE: {
                service = this._getServiceHelper(PERSISTENCE_MANAGEMENT_SERVICE, this.persistenceMgrClass, JDBCPersistenceManagerImpl.class);
                break;
            }
            case CONTAINER_ARTIFACT_FACTORY_SERVICE: {
                service = this._getServiceHelper(CONTAINER_ARTIFACT_FACTORY_SERVICE, this.batchArtifactFactoryClass, JSEBatchArtifactFactoryImpl.class);
                break;
            }
            case BATCH_KERNEL_SERVICE: {
                service = this._getServiceHelper(BATCH_KERNEL_SERVICE, this.containerKernelClass, BatchKernelImpl.class);
                break;
            }
            case JOB_STATUS_MANAGEMENT_SERVICE: {
                service = this._getServiceHelper(JOB_STATUS_MANAGEMENT_SERVICE, this.jobstatusMgrClass, JobStatusManagerImpl.class);
                break;
            }
            case JOB_ID_MANAGEMENT_SERVICE: {
                service = this._getServiceHelper(JOB_ID_MANAGEMENT_SERVICE, this.jobIdMgrClass, JobIdManagerImpl.class);
                break;
            }
            case JOB_OP_SERVICE: {
                service = this._getServiceHelper(JOB_OP_SERVICE, this.jobOpClass, JobIdManagerImpl.class);
                break;
            }
            case CALLBACK_SERVICE: {
                service = this._getServiceHelper(CALLBACK_SERVICE, this.callbackClass, JobEndCallbackManagerImpl.class);
                break;
            }
            case TRANSACTION_MANAGEMENT_SERVICE: {
                service = this._getServiceHelper(TRANSACTION_SERVICE, this.transactionClass, BatchTransactionServiceImpl.class);
                break;
            }
            default: {
                logger.finer("Invalid service type" + (Object)((Object)serviceType));
                Exception e = new Exception("Invalid service type");
                throw new BatchContainerServiceException("Invalid service type=" + (Object)((Object)serviceType), e);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
        return service;
    }

    public IBatchThreadPoolService getThreadpoolService(IBatchConfig bConfig, int size) {
        IBatchThreadPoolService threadpoolService = null;
        try {
            threadpoolService = (IBatchThreadPoolService)this._loadService(this.threadpoolServiceClass);
        }
        catch (Throwable e1) {
            logger.warning("Could not instantiate: " + this.threadpoolServiceClass + " due to: " + e1.getMessage() + " reverting to defaults");
            threadpoolService = new JSEThreadPoolServiceImpl();
        }
        threadpoolService.setPoolSize(size);
        if (bConfig == null) {
            bConfig = batchConfig;
        }
        threadpoolService.init(bConfig);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("got executor service");
        }
        return threadpoolService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBatchServiceBase _getServiceHelper(String key, String className, Class defaultClass) {
        IBatchServiceBase service = this._serviceRegistry.get(key);
        if (service == null) {
            ServicesManager servicesManager = this;
            synchronized (servicesManager) {
                service = this._serviceRegistry.get(key);
                if (service == null) {
                    service = this._loadServiceHelper(className, defaultClass);
                    service.init(batchConfig);
                    this._serviceRegistry.putIfAbsent(key, service);
                }
            }
        }
        return service;
    }

    public IBatchServiceBase _loadServiceHelper(String className, Class defaultClass) {
        Throwable e;
        IBatchServiceBase service;
        block8: {
            block7: {
                service = null;
                e = null;
                try {
                    if (className != null) {
                        service = this._loadService(className);
                    }
                }
                catch (Throwable e1) {
                    e = e1;
                    if (logger == null) break block7;
                    logger.log(Level.WARNING, "Could not instantiate: " + className + " due to exception. Reverting to default: " + defaultClass.getName(), e);
                }
            }
            if (service == null) {
                try {
                    service = (IBatchServiceBase)defaultClass.newInstance();
                }
                catch (Throwable e2) {
                    e = e2;
                    if (logger == null) break block8;
                    logger.log(Level.WARNING, "Could not instantiate: " + defaultClass.getName() + " due to exception", e);
                }
            }
        }
        if (service == null) {
            throw new RuntimeException("Could not instantiate service " + className + " or default " + defaultClass.getName(), e);
        }
        return service;
    }

    private IBatchServiceBase _loadService(String className) throws Exception {
        Constructor<?> ctor;
        IBatchServiceBase service = null;
        Class<?> cls = Class.forName(className);
        if (cls != null) {
            ctor = cls.getConstructor(new Class[0]);
            if (ctor == null) {
                throw new Exception("Service class " + className + " should  have a default constructor defined");
            }
        } else {
            throw new Exception("Exception loading Service class " + className + " make sure it exists");
        }
        service = (IBatchServiceBase)ctor.newInstance(new Object[0]);
        return service;
    }

    public static synchronized ServicesManager getInstance() throws BatchContainerServiceException {
        if (servicesManager == null) {
            servicesManager = new ServicesManager();
        }
        return servicesManager;
    }

    public static synchronized ServicesManager getInstance(Properties servicesList) throws BatchContainerServiceException {
        if (servicesManager == null) {
            servicesManager = new ServicesManager(servicesList);
        }
        return servicesManager;
    }

    static {
        batchConfig = null;
    }

    public static enum ServiceType {
        TRANSACTION_MANAGEMENT_SERVICE,
        PERSISTENCE_MANAGEMENT_SERVICE,
        JOB_STATUS_MANAGEMENT_SERVICE,
        THREADPOOL_MANAGEMENT_SERVICE,
        CONTAINER_ARTIFACT_FACTORY_SERVICE,
        CONFIGURATION_SERVICE,
        BATCH_KERNEL_SERVICE,
        JOB_ID_MANAGEMENT_SERVICE,
        JOB_OP_SERVICE,
        CALLBACK_SERVICE;

    }
}

