/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.artifact.proxy.RetryListenerProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Chunk;

public class RetryHandler {
    private static final String className = RetryHandler.class.getName();
    private static Logger logger = Logger.getLogger(RetryHandler.class.getPackage().getName());
    public static final String RETRY_COUNT = "retry-limit";
    public static final String RETRY_INCLUDE_EX = "include class";
    public static final String RETRY_EXCLUDE_EX = "exclude class";
    private RetryListenerProxy _retryListener = null;
    private long _jobId = 0L;
    private String _stepId = null;
    private Set<String> _retryNoRBIncludeExceptions = null;
    private Set<String> _retryNoRBExcludeExceptions = null;
    private int _retryLimit = 0;
    private long _retryCount = 0L;
    private Exception _retryNoRBException = null;

    public RetryHandler(Chunk chunk, long l, String stepId) {
        this._jobId = l;
        this._stepId = stepId;
        this.initialize(chunk);
    }

    public void addRetryListener(RetryListenerProxy retryListener) {
        this._retryListener = retryListener;
    }

    private void initialize(Chunk chunk) {
        String mName = "initialize";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "initialize");
        }
        try {
            if (chunk.getRetryLimit() != null) {
                this._retryLimit = Integer.parseInt(chunk.getRetryLimit());
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("NumberFormatException reading retry-limit", nfe);
        }
        if (this._retryLimit > 0) {
            this._retryNoRBIncludeExceptions = new HashSet<String>();
            this._retryNoRBExcludeExceptions = new HashSet<String>();
            boolean done = false;
            String includeEx = null;
            String excludeEx = null;
            if (chunk.getNoRollbackExceptionClasses() != null && chunk.getNoRollbackExceptionClasses().getInclude() != null) {
                includeEx = chunk.getNoRollbackExceptionClasses().getInclude().getClazz();
                logger.finer("RETRYHANDLE: include: " + includeEx);
            }
            if (chunk.getNoRollbackExceptionClasses() != null && chunk.getNoRollbackExceptionClasses().getExclude() != null) {
                excludeEx = chunk.getNoRollbackExceptionClasses().getExclude().getClazz();
                logger.finer("RETRYHANDLE: exclude: " + excludeEx);
            }
            if (includeEx != null) {
                this._retryNoRBIncludeExceptions.add(includeEx.trim());
            }
            if (excludeEx != null) {
                this._retryNoRBExcludeExceptions.add(excludeEx.trim());
            }
            boolean bl = done = includeEx == null && excludeEx == null;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, className, "initialize", "added include exception " + includeEx + "; added exclude exception " + excludeEx);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "initialize", this.toString());
        }
    }

    public void handleNoRollbackExceptionRead(Exception e) {
        String mName = "handleException";
        logger.finer("RETRYHANDLE: in retryhandler handle exception on a read:" + e.toString());
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleException", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isRetryLimitReached() && this.isRetryable(e)) {
            ++this._retryCount;
            this.logRetry(e);
            if (this._retryListener != null) {
                this._retryListener.onRetryReadItem(e);
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleException", "No retry.  Rethrow", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "handleException", e);
        }
    }

    public void handleNoRollbackExceptionWithRecordProcess(Exception e, Object w) {
        String mName = "handleException";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleException", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isRetryLimitReached() && this.isRetryable(e)) {
            ++this._retryCount;
            this.logRetry(e);
            if (this._retryListener != null) {
                this._retryListener.onRetryProcessException(e, w);
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleException", "No retry.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
    }

    public void handleNoRollbackExceptionWithRecordWriteItem(Exception e, Object w) {
        String mName = "handleException";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleException", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isRetryLimitReached() && this.isRetryable(e)) {
            ++this._retryCount;
            this.logRetry(e);
            if (this._retryListener != null) {
                this._retryListener.onRetryWriteItem(e, w);
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleException", "No retry.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
    }

    private boolean isRetryable(Exception e) {
        boolean retVal;
        String mName = "isRetryable";
        String exClassName = e.getClass().getName();
        boolean bl = retVal = (this._retryNoRBIncludeExceptions.isEmpty() || this.containsRetryableNoRB(this._retryNoRBIncludeExceptions, e)) && !this.containsRetryableNoRB(this._retryNoRBExcludeExceptions, e);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "isRetryable", "isRetryable: " + retVal + ": " + exClassName);
        }
        return retVal;
    }

    private boolean containsRetryableNoRB(Set<String> retryList, Exception e) {
        String mName = "containsRetryableNoRB";
        boolean retVal = false;
        for (String exClassName : retryList) {
            try {
                retVal = Class.forName(exClassName).isInstance(e);
                if (!retVal) continue;
                break;
            }
            catch (ClassNotFoundException cnf) {
                logger.logp(Level.FINE, className, "containsRetryableNoRB", cnf.getLocalizedMessage());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "containsRetryableNoRB", "containsRetryableNoRB: " + retVal);
        }
        return retVal;
    }

    private boolean isRetryLimitReached() {
        return this._retryCount >= (long)this._retryLimit;
    }

    private void logRetry(Exception e) {
        String key = "record.retried.norollback.by.batch.container";
        Object[] details = new Object[]{this._jobId, this._stepId, e.getClass().getName() + ": " + e.getMessage()};
    }

    public long getRetryCount() {
        return this._retryCount;
    }

    public void setRetryCount(long retryCount) {
        String mName = "setRetryCount";
        this._retryCount = retryCount;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "setRetryCount", "setRetryCount: " + this._retryCount);
        }
    }

    public String toString() {
        return "RetryHandler{" + super.toString() + "}count:limit=" + this._retryCount + ":" + this._retryLimit;
    }
}

