/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.artifact.proxy.PartitionMapperProxy;
import com.ibm.batch.container.artifact.proxy.PartitionReducerProxy;
import com.ibm.batch.container.artifact.proxy.ProxyFactory;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.impl.BaseStepControllerImpl;
import com.ibm.batch.container.impl.ParallelJobBuilder;
import com.ibm.batch.container.jobinstance.ParallelJobExecution;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.util.ExecutionStatus;
import com.ibm.batch.container.validation.ArtifactValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.parameters.PartitionPlan;
import jsr352.batch.jsl.Analyzer;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.PartitionMapper;
import jsr352.batch.jsl.PartitionReducer;
import jsr352.batch.jsl.Step;

public class PartitionedStepControllerImpl
extends BaseStepControllerImpl {
    private static final String sourceClass = PartitionedStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final int DEFAULT_PARTITION_INSTANCES = 1;
    private int numPartitions = 1;
    private Properties[] partitionProperties = null;
    private volatile List<ParallelJobExecution> parallelJobExecs;
    private PartitionReducerProxy partitionReducer = null;
    final List<JSLJob> subJobs = new ArrayList<JSLJob>();

    protected PartitionedStepControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Step step) {
        super(jobExecutionImpl, step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.stepContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING));
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelJobExecs != null) {
                for (ParallelJobExecution subJob : this.parallelJobExecs) {
                    try {
                        batchKernel.stopJob(subJob.getJobExecution().getInstanceId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invokeCoreStep() {
        Object partitionMapperProxy;
        PartitionMapper partitionMapper;
        String instancesAttr = null;
        if (this.step.getPartition().getPartitionPlan() != null && (instancesAttr = this.step.getPartition().getPartitionPlan().getInstances()) != null) {
            try {
                this.numPartitions = Integer.parseInt(instancesAttr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse partition instances value in stepId: " + this.step.getId() + ", with instances=" + instancesAttr, e);
            }
            if (this.numPartitions < 1) {
                throw new IllegalArgumentException("Partition instances value must be 1 or greater in stepId: " + this.step.getId() + ", with instances=" + instancesAttr);
            }
        }
        if ((partitionMapper = this.step.getPartition().getPartitionMapper()) != null) {
            List propertyList = partitionMapper.getProperties() == null ? null : partitionMapper.getProperties().getPropertyList();
            try {
                partitionMapperProxy = ProxyFactory.createPartitionMapperProxy(partitionMapper.getRef(), propertyList);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the PartitionMapper [" + partitionMapper.getRef() + "]", e);
            }
            ((AbstractProxy)partitionMapperProxy).setJobContext(this.jobExecutionImpl.getJobContext());
            ((AbstractProxy)partitionMapperProxy).setStepContext(this.stepContext);
            ((AbstractProxy)partitionMapperProxy).setFlowContext(this.flowContext);
            ((AbstractProxy)partitionMapperProxy).setSplitContext(this.splitContext);
            PartitionPlan plan = ((PartitionMapperProxy)partitionMapperProxy).calculatePartitions();
            this.numPartitions = plan.getPartitionCount();
            if (logger.isLoggable(Level.FINE) && instancesAttr != null) {
                logger.fine("Overriding instances attribute of " + instancesAttr + " with subJobCount of " + this.numPartitions + " in step " + this.step.getId());
            }
            this.partitionProperties = plan.getPartitionProperties();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Subjob properties defined by partition mapper: " + this.partitionProperties);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Number of partitions in step: " + this.numPartitions + " in step " + this.step.getId());
            logger.fine("Subjob properties defined by partition mapper: " + this.partitionProperties);
        }
        partitionMapperProxy = this.subJobs;
        synchronized (partitionMapperProxy) {
            if (this.jobExecutionImpl.getJobContext().getBatchStatus().equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING))) {
                this.stepContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED));
                return;
            }
            for (int instance = 0; instance < this.numPartitions; ++instance) {
                this.subJobs.add(ParallelJobBuilder.buildSubJob(this.jobExecutionImpl.getExecutionId(), this.step, this.partitionProperties, instance));
            }
            this.parallelJobExecs = batchKernel.startParallelJobs(this.subJobs, this.partitionProperties, this.analyzerProxy);
        }
        boolean rollback = false;
        for (ParallelJobExecution subJob : this.parallelJobExecs) {
            subJob.waitForResult();
            String batchStatus = subJob.getJobExecution().getJobContext().getBatchStatus();
            if (batchStatus.equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.FAILED))) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
                    logger.fine("Starting logical transaction rollback.");
                }
                if (this.partitionReducer != null) {
                    this.stop();
                    this.partitionReducer.partitionReducerRollback();
                    rollback = true;
                }
                this.stepContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.FAILED));
                break;
            }
            if (!batchStatus.equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED))) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
                logger.fine("Starting logical transaction rollback.");
            }
            if (this.partitionReducer != null) {
                this.stop();
                this.partitionReducer.partitionReducerRollback();
                rollback = true;
            }
            this.stepContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED));
            break;
        }
        if (!rollback && this.partitionReducer != null) {
            this.partitionReducer.partitionReducerBeforeCompletion();
        }
    }

    @Override
    protected void setupStepArtifacts() {
        PartitionReducer partitionReducer;
        Analyzer analyzer = this.step.getPartition().getAnalyzer();
        if (analyzer != null) {
            List propList = analyzer.getProperties() == null ? null : analyzer.getProperties().getPropertyList();
            try {
                this.analyzerProxy = ProxyFactory.createPartitionAnalyzerProxy(analyzer.getRef(), propList);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the analyzer [" + analyzer.getRef() + "]", e);
            }
            this.analyzerProxy.setJobContext(this.jobExecutionImpl.getJobContext());
            this.analyzerProxy.setSplitContext(this.splitContext);
            this.analyzerProxy.setFlowContext(this.flowContext);
            this.analyzerProxy.setStepContext(this.stepContext);
        }
        if ((partitionReducer = this.step.getPartition().getPartitionReducer()) != null) {
            List propList = partitionReducer.getProperties() == null ? null : partitionReducer.getProperties().getPropertyList();
            try {
                this.partitionReducer = ProxyFactory.createPartitionReducerProxy(partitionReducer.getRef(), propList);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the analyzer [" + partitionReducer.getRef() + "]", e);
            }
        }
    }

    @Override
    protected void invokePreStepArtifacts() {
        if (this.partitionReducer != null) {
            this.partitionReducer.partitionReducerBegin();
        }
    }

    @Override
    protected void invokePostStepArtifacts() {
        if (this.partitionReducer != null) {
            this.partitionReducer.partitionReducerAfterCompletion(this.stepStatus.getExitStatus());
        }
    }
}

