/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.AbortedBeforeStartException;
import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.artifact.proxy.DeciderProxy;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.artifact.proxy.ProxyFactory;
import com.ibm.batch.container.context.impl.FlowContextImpl;
import com.ibm.batch.container.context.impl.SplitContextImpl;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.util.ExecutionStatus;
import com.ibm.batch.container.validation.ArtifactValidationException;
import java.io.Externalizable;
import java.util.List;
import jsr352.batch.jsl.Decision;

public class DecisionControllerImpl
implements IExecutionElementController {
    protected RuntimeJobExecutionImpl jobExecutionImpl;
    protected StepContextImpl<?, ? extends Externalizable> stepContext;
    protected SplitContextImpl splitContext;
    protected FlowContextImpl flowContext;
    protected Decision decision;
    private PartitionAnalyzerProxy analyzerProxy;

    public DecisionControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Decision decision) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.decision = decision;
    }

    public void setStepContext(StepContextImpl<?, ? extends Externalizable> stepContext) {
        this.stepContext = stepContext;
    }

    @Override
    public void setSplitContext(SplitContextImpl splitContext) {
        this.splitContext = splitContext;
    }

    @Override
    public void setFlowContext(FlowContextImpl flowContext) {
        this.flowContext = flowContext;
    }

    @Override
    public String execute() throws AbortedBeforeStartException {
        DeciderProxy deciderProxy;
        ExecutionStatus status = new ExecutionStatus();
        String deciderId = this.decision.getRef();
        List propList = this.decision.getProperties() == null ? null : this.decision.getProperties().getPropertyList();
        try {
            deciderProxy = ProxyFactory.createDeciderProxy(deciderId, propList);
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the decider [" + deciderId + "]", e);
        }
        deciderProxy.setJobContext(this.jobExecutionImpl.getJobContext());
        deciderProxy.setStepContext(this.stepContext);
        deciderProxy.setFlowContext(this.flowContext);
        deciderProxy.setSplitContext(this.splitContext);
        String exitStatus = deciderProxy.decide();
        return exitStatus;
    }

    @Override
    public void stop() {
        this.stepContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING));
    }

    @Override
    public void setAnalyzerProxy(PartitionAnalyzerProxy analyzerProxy) {
        this.analyzerProxy = analyzerProxy;
    }
}

