/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.IBatchConfig;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.impl.JobControllerImpl;
import com.ibm.batch.container.jobinstance.JobExecutionHelper;
import com.ibm.batch.container.jobinstance.ParallelJobExecution;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.services.IBatchKernelService;
import com.ibm.batch.container.services.IBatchThreadPoolService;
import com.ibm.batch.container.services.IJobIdManagementService;
import com.ibm.batch.container.services.ParallelTaskResult;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.tck.bridge.IJobEndCallbackService;
import com.ibm.batch.container.util.BatchWorkUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.exception.JobExecutionNotRunningException;
import javax.batch.operations.exception.NoSuchJobExecutionException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.StepExecution;
import jsr352.batch.jsl.JSLJob;

public class BatchKernelImpl
implements IBatchKernelService {
    private static final String sourceClass = BatchKernelImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static IJobIdManagementService _jobIdManagementService = null;
    private Map<Long, JobControllerImpl> instanceId2jobControllerMap = new ConcurrentHashMap<Long, JobControllerImpl>();
    private Map<Long, RuntimeJobExecutionImpl> jobExecutionInstancesMap = new ConcurrentHashMap<Long, RuntimeJobExecutionImpl>();
    private Map<String, StepExecution> stepExecutionInstancesMap = new ConcurrentHashMap<String, StepExecution>();
    ServicesManager servicesManager = ServicesManager.getInstance();
    private IBatchThreadPoolService executorService = null;
    private IJobEndCallbackService callbackService = null;
    public static final int THREAD_POOL_SIZE = 5;

    public BatchKernelImpl() {
        _jobIdManagementService = (IJobIdManagementService)this.servicesManager.getService(ServicesManager.ServiceType.JOB_ID_MANAGEMENT_SERVICE);
        this.executorService = ServicesManager.getInstance().getThreadpoolService(null, 5);
        this.callbackService = (IJobEndCallbackService)this.servicesManager.getService(ServicesManager.ServiceType.CALLBACK_SERVICE);
    }

    @Override
    public void init(IBatchConfig pgcConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @Override
    public JobExecution restartJob(long jobInstanceId) {
        return this.restartJob(jobInstanceId, null);
    }

    @Override
    public JobExecution startJob(String jobXML) {
        return this.startJob(jobXML, null);
    }

    @Override
    public JobExecution startJob(String jobXML, Properties jobParameters) {
        String method = "startJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobXML, jobParameters});
        }
        RuntimeJobExecutionImpl jobExecution = JobExecutionHelper.startJob(jobXML, jobParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.jobExecutionInstancesMap.put(jobExecution.getExecutionId(), jobExecution);
        this.executorService.executeTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void stopJob(long jobInstanceId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        JobControllerImpl controller = this.instanceId2jobControllerMap.get(jobInstanceId);
        if (controller == null) {
            String msg = "JobExecution with execution id of " + jobInstanceId + "is not running.";
            throw new JobExecutionNotRunningException(null, msg);
        }
        controller.stop();
    }

    @Override
    public JobExecution restartJob(long jobInstanceId, Properties overrideJobParameters) {
        String method = "restartJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobInstanceId, overrideJobParameters});
        }
        RuntimeJobExecutionImpl jobExecution = JobExecutionHelper.restartJob(jobInstanceId, overrideJobParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution);
        this.instanceId2jobControllerMap.put(jobInstanceId, batchWork.getController());
        this.jobExecutionInstancesMap.put(jobExecution.getExecutionId(), jobExecution);
        this.executorService.executeTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void jobExecutionDone(RuntimeJobExecutionImpl jobExecution) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution done, getting ready to invoke callbacks for JobExecution: " + jobExecution.getExecutionId());
        }
        this.callbackService.done(jobExecution.getExecutionId());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Done invoking callbacks for JobExecution: " + jobExecution.getExecutionId());
        }
        this.instanceId2jobControllerMap.remove(jobExecution.getInstanceId());
    }

    @Override
    public JobExecution getJobExecution(long executionId) {
        String method = "getJobExecution";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, executionId);
        }
        RuntimeJobExecutionImpl rtJobExecution = this.jobExecutionInstancesMap.get(executionId);
        JobExecution retVal = rtJobExecution.getJobOperatorJobExecution();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, retVal);
        }
        return retVal;
    }

    @Override
    public List<StepExecution> getJobSteps(long jobExecutionId) {
        ArrayList<StepExecution> steps = new ArrayList<StepExecution>();
        for (StepExecution stepExecution : this.stepExecutionInstancesMap.values()) {
            if (stepExecution.getJobExecutionId() != jobExecutionId) continue;
            steps.add(stepExecution);
        }
        return steps;
    }

    @Override
    public StepExecution getStepExecution(long jobExecutionId, long stepExecutionId) {
        String method = "getStepExecution";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, "jobExecutionId " + String.valueOf(jobExecutionId) + " : stepExecutionId " + stepExecutionId);
        }
        String key = this.getJobStepExecId(jobExecutionId, stepExecutionId);
        StepExecution retVal = this.stepExecutionInstancesMap.get(key);
        long jobExecID = JobExecutionHelper.getstepExecutionIDInfo(key, "jobexecid");
        long stepExecID = JobExecutionHelper.getstepExecutionIDInfo(key, "stepexecid");
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, retVal);
        }
        return retVal;
    }

    public void registerStepExecution(long jobExecutionId, long stepExecutionId, StepExecution stepExecution) {
        String method = "registerStepExecution";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, "jobExecutionId " + String.valueOf(jobExecutionId) + " : stepExecutionId " + stepExecutionId);
        }
        String key = this.getJobStepExecId(jobExecutionId, stepExecutionId);
        this.stepExecutionInstancesMap.put(key, stepExecution);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    private String getJobStepExecId(long jobExecutionId, long stepExecutionId) {
        return String.valueOf(jobExecutionId) + ':' + String.valueOf(stepExecutionId);
    }

    private ParallelJobExecution startGeneratedJob(JSLJob jobModel, Properties jobParameters, PartitionAnalyzerProxy analyzerProxy) {
        String method = "startGeneratedJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobModel, jobParameters});
        }
        RuntimeJobExecutionImpl jobExecution = JobExecutionHelper.startJob(jobModel, jobParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution, analyzerProxy, false);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.jobExecutionInstancesMap.put(jobExecution.getExecutionId(), jobExecution);
        ParallelTaskResult result = this.executorService.executeParallelTask(batchWork, null);
        ParallelJobExecution parallelJobExec = new ParallelJobExecution(jobExecution, result);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return parallelJobExec;
    }

    public List<ParallelJobExecution> startParallelJobs(List<JSLJob> jobModels, Properties[] jobParameters, PartitionAnalyzerProxy analyzerProxy) {
        ArrayList<ParallelJobExecution> parallelJobExecs = new ArrayList<ParallelJobExecution>(jobModels.size());
        int instance = 0;
        for (JSLJob parallelJob : jobModels) {
            Properties jobProperties = jobParameters == null ? null : jobParameters[instance];
            ParallelJobExecution parallelJobExec = this.startGeneratedJob(parallelJob, jobProperties, analyzerProxy);
            parallelJobExecs.add(parallelJobExec);
            ++instance;
        }
        return parallelJobExecs;
    }

    @Override
    public List<Long> getExecutionIds(long jobInstance) {
        return null;
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        return 0;
    }
}

