/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.CheckpointListenerProxy;
import com.ibm.batch.container.artifact.proxy.FlowListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemProcessListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemReadListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemWriteListenerProxy;
import com.ibm.batch.container.artifact.proxy.JobListenerProxy;
import com.ibm.batch.container.artifact.proxy.ProxyFactory;
import com.ibm.batch.container.artifact.proxy.RetryListenerProxy;
import com.ibm.batch.container.artifact.proxy.SkipListenerProxy;
import com.ibm.batch.container.artifact.proxy.SplitListenerProxy;
import com.ibm.batch.container.artifact.proxy.StepListenerProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.batch.annotation.CheckpointListener;
import javax.batch.annotation.FlowListener;
import javax.batch.annotation.ItemProcessListener;
import javax.batch.annotation.ItemReadListener;
import javax.batch.annotation.ItemWriteListener;
import javax.batch.annotation.JobListener;
import javax.batch.annotation.RetryListener;
import javax.batch.annotation.SkipListener;
import javax.batch.annotation.SplitListener;
import javax.batch.annotation.StepListener;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.Listener;
import jsr352.batch.jsl.Listeners;
import jsr352.batch.jsl.Property;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;

public class ListenerFactory {
    private List<ListenerInfo> jobLevelListenerInfo = null;
    private Map<String, List<ListenerInfo>> stepLevelListenerInfo = new HashMap<String, List<ListenerInfo>>();
    private Map<String, List<ListenerInfo>> splitLevelListenerInfo = new HashMap<String, List<ListenerInfo>>();
    private Map<String, List<ListenerInfo>> flowLevelListenerInfo = new HashMap<String, List<ListenerInfo>>();

    public ListenerFactory(JSLJob jobModel) {
        this.initJobLevelListeners(jobModel);
    }

    private void initJobLevelListeners(JSLJob jobModel) {
        this.jobLevelListenerInfo = new ArrayList<ListenerInfo>();
        Listeners jobLevelListeners = jobModel.getListeners();
        if (jobLevelListeners != null) {
            for (Listener listener : jobLevelListeners.getListenerList()) {
                ListenerInfo info = this.buildListenerInfo(listener);
                this.jobLevelListenerInfo.add(info);
            }
        }
    }

    private synchronized List<ListenerInfo> getStepListenerInfo(Step step) {
        if (!this.stepLevelListenerInfo.containsKey(step.getId())) {
            ArrayList<ListenerInfo> stepListenerInfoList = new ArrayList<ListenerInfo>();
            this.stepLevelListenerInfo.put(step.getId(), stepListenerInfoList);
            Listeners stepLevelListeners = step.getListeners();
            if (stepLevelListeners != null) {
                for (Listener listener : stepLevelListeners.getListenerList()) {
                    ListenerInfo info = this.buildListenerInfo(listener);
                    stepListenerInfoList.add(info);
                }
            }
            return stepListenerInfoList;
        }
        return this.stepLevelListenerInfo.get(step.getId());
    }

    private synchronized List<ListenerInfo> getSplitListenerInfo(Split split) {
        if (!this.splitLevelListenerInfo.containsKey(split.getId())) {
            ArrayList<ListenerInfo> splitListenerInfoList = new ArrayList<ListenerInfo>();
            this.splitLevelListenerInfo.put(split.getId(), splitListenerInfoList);
            Listeners splitLevelListeners = split.getListeners();
            if (splitLevelListeners != null) {
                for (Listener listener : splitLevelListeners.getListenerList()) {
                    ListenerInfo info = this.buildListenerInfo(listener);
                    splitListenerInfoList.add(info);
                }
            }
            return splitListenerInfoList;
        }
        return this.splitLevelListenerInfo.get(split.getId());
    }

    private synchronized List<ListenerInfo> getFlowListenerInfo(Flow flow) {
        if (!this.flowLevelListenerInfo.containsKey(flow.getId())) {
            ArrayList<ListenerInfo> flowListenerInfoList = new ArrayList<ListenerInfo>();
            this.flowLevelListenerInfo.put(flow.getId(), flowListenerInfoList);
            Listeners flowLevelListeners = flow.getListeners();
            if (flowLevelListeners != null) {
                for (Listener listener : flowLevelListeners.getListenerList()) {
                    ListenerInfo info = this.buildListenerInfo(listener);
                    flowListenerInfoList.add(info);
                }
            }
            return flowListenerInfoList;
        }
        return this.flowLevelListenerInfo.get(flow.getId());
    }

    private ListenerInfo buildListenerInfo(Listener listener) {
        String id = listener.getRef();
        List propList = listener.getProperties() == null ? null : listener.getProperties().getPropertyList();
        Object listenerArtifact = ProxyFactory.loadArtifact(id);
        if (listenerArtifact == null) {
            throw new IllegalArgumentException("Load of artifact id: " + id + " returned <null>.");
        }
        ListenerInfo info = new ListenerInfo(listenerArtifact, propList);
        return info;
    }

    public List<JobListenerProxy> getJobListeners() {
        ArrayList<JobListenerProxy> retVal = new ArrayList<JobListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isJobListener()) continue;
            JobListenerProxy proxy = new JobListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<CheckpointListenerProxy> getCheckpointListeners(Step step) {
        CheckpointListenerProxy proxy;
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step);
        ArrayList<CheckpointListenerProxy> retVal = new ArrayList<CheckpointListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isCheckpointListener()) continue;
            proxy = new CheckpointListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isCheckpointListener()) continue;
            proxy = new CheckpointListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ItemProcessListenerProxy> getItemProcessListeners(Step step) {
        ItemProcessListenerProxy proxy;
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step);
        ArrayList<ItemProcessListenerProxy> retVal = new ArrayList<ItemProcessListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isItemProcessListener()) continue;
            proxy = new ItemProcessListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isItemProcessListener()) continue;
            proxy = new ItemProcessListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ItemReadListenerProxy> getItemReadListeners(Step step) {
        ItemReadListenerProxy proxy;
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step);
        ArrayList<ItemReadListenerProxy> retVal = new ArrayList<ItemReadListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isItemReadListener()) continue;
            proxy = new ItemReadListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isItemReadListener()) continue;
            proxy = new ItemReadListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ItemWriteListenerProxy> getItemWriteListeners(Step step) {
        ItemWriteListenerProxy proxy;
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step);
        ArrayList<ItemWriteListenerProxy> retVal = new ArrayList<ItemWriteListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isItemWriteListener()) continue;
            proxy = new ItemWriteListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isItemWriteListener()) continue;
            proxy = new ItemWriteListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<RetryListenerProxy> getRetryListeners(Step step) {
        RetryListenerProxy proxy;
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step);
        ArrayList<RetryListenerProxy> retVal = new ArrayList<RetryListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isRetryListener()) continue;
            proxy = new RetryListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isRetryListener()) continue;
            proxy = new RetryListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<SkipListenerProxy> getSkipListeners(Step step) {
        SkipListenerProxy proxy;
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step);
        ArrayList<SkipListenerProxy> retVal = new ArrayList<SkipListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isSkipListener()) continue;
            proxy = new SkipListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isSkipListener()) continue;
            proxy = new SkipListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<StepListenerProxy> getStepListeners(Step step) {
        StepListenerProxy proxy;
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step);
        ArrayList<StepListenerProxy> retVal = new ArrayList<StepListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isStepListener()) continue;
            proxy = new StepListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isStepListener()) continue;
            proxy = new StepListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<SplitListenerProxy> getSplitListeners(Split split) {
        SplitListenerProxy proxy;
        List<ListenerInfo> splitListenerInfo = this.getSplitListenerInfo(split);
        ArrayList<SplitListenerProxy> retVal = new ArrayList<SplitListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isSplitListener()) continue;
            proxy = new SplitListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        for (ListenerInfo li : splitListenerInfo) {
            if (!li.isSplitListener()) continue;
            proxy = new SplitListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<FlowListenerProxy> getFlowListeners(Flow flow) {
        FlowListenerProxy proxy;
        List<ListenerInfo> flowListenerInfo = this.getFlowListenerInfo(flow);
        ArrayList<FlowListenerProxy> retVal = new ArrayList<FlowListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isFlowListener()) continue;
            proxy = new FlowListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        for (ListenerInfo li : flowListenerInfo) {
            if (!li.isFlowListener()) continue;
            proxy = new FlowListenerProxy(li.getArtifact(), li.getPropList());
            retVal.add(proxy);
        }
        return retVal;
    }

    private class ListenerInfo {
        Object listenerArtifact = null;
        Class listenerArtifactClass = null;
        List<Property> propList = null;

        Object getArtifact() {
            return this.listenerArtifact;
        }

        private ListenerInfo(Object listenerArtifact, List<Property> propList) {
            this.listenerArtifact = listenerArtifact;
            this.listenerArtifactClass = listenerArtifact.getClass();
            this.propList = propList;
        }

        boolean isJobListener() {
            return this.listenerArtifactClass.isAnnotationPresent(JobListener.class);
        }

        boolean isSplitListener() {
            return this.listenerArtifactClass.isAnnotationPresent(SplitListener.class);
        }

        boolean isFlowListener() {
            return this.listenerArtifactClass.isAnnotationPresent(FlowListener.class);
        }

        boolean isStepListener() {
            return this.listenerArtifactClass.isAnnotationPresent(StepListener.class);
        }

        boolean isCheckpointListener() {
            return this.listenerArtifactClass.isAnnotationPresent(CheckpointListener.class);
        }

        boolean isItemProcessListener() {
            return this.listenerArtifactClass.isAnnotationPresent(ItemProcessListener.class);
        }

        boolean isItemReadListener() {
            return this.listenerArtifactClass.isAnnotationPresent(ItemReadListener.class);
        }

        boolean isItemWriteListener() {
            return this.listenerArtifactClass.isAnnotationPresent(ItemWriteListener.class);
        }

        boolean isRetryListener() {
            return this.listenerArtifactClass.isAnnotationPresent(RetryListener.class);
        }

        boolean isSkipListener() {
            return this.listenerArtifactClass.isAnnotationPresent(SkipListener.class);
        }

        List<Property> getPropList() {
            return this.propList;
        }

        void setPropList(List<Property> propList) {
            this.propList = propList;
        }
    }
}

