/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.xjcl.CloneUtility;
import com.ibm.batch.container.xjcl.ControlElement;
import java.util.List;
import java.util.Properties;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.ObjectFactory;
import jsr352.batch.jsl.Partition;
import jsr352.batch.jsl.PartitionPlan;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;

public class PartitionedStepBuilder {
    public static JSLJob buildSubJob(Long parentJobExecutionId, Split split, Flow flow, Properties[] subJobParameters) {
        ObjectFactory jslFactory = new ObjectFactory();
        JSLJob subJob = jslFactory.createJSLJob();
        String subJobId = PartitionedStepBuilder.generateSubJobId(parentJobExecutionId, split.getId(), flow.getId());
        subJob.setId(subJobId);
        subJob.getExecutionElements().add(flow);
        return subJob;
    }

    public static JSLJob buildSubJob(Long parentJobInstanceId, Step step, int partitionInstance) {
        ObjectFactory jslFactory = new ObjectFactory();
        JSLJob subJob = jslFactory.createJSLJob();
        String subJobId = PartitionedStepBuilder.generateSubJobId(parentJobInstanceId, step.getId(), partitionInstance);
        subJob.setId(subJobId);
        Step newStep = jslFactory.createStep();
        newStep.setId(step.getId());
        newStep.setAbstract(step.getAbstract());
        newStep.setAllowStartIfComplete(step.getAllowStartIfComplete());
        if (step.getBatchlet() != null) {
            newStep.setBatchlet(CloneUtility.cloneBatchlet(step.getBatchlet()));
        }
        if (step.getChunk() != null) {
            newStep.setChunk(CloneUtility.cloneChunk(step.getChunk()));
        }
        List<ControlElement> newControlElements = newStep.getControlElements();
        CloneUtility.cloneControlElements(step.getControlElements(), newControlElements);
        newStep.setListeners(CloneUtility.cloneListeners(step.getListeners()));
        newStep.setNextFromAttribute(step.getNextFromAttribute());
        newStep.setParent(step.getParent());
        Partition partition = step.getPartition();
        if (partition != null && partition.getCollector() != null) {
            Partition basePartition = jslFactory.createPartition();
            PartitionPlan partitionPlan = jslFactory.createPartitionPlan();
            partitionPlan.setPartitions(null);
            basePartition.setPlan(partitionPlan);
            basePartition.setCollector(partition.getCollector());
            newStep.setPartition(basePartition);
        }
        newStep.setStartLimit(step.getStartLimit());
        newStep.setProperties(CloneUtility.cloneJSLProperties(step.getProperties()));
        if (step.getListeners() != null) {
            newStep.setListeners(CloneUtility.cloneListeners(step.getListeners()));
        }
        subJob.getExecutionElements().add(newStep);
        return subJob;
    }

    private static String generateSubJobId(Long parentJobInstanceId, String splitId, String flowId) {
        StringBuilder strBuilder = new StringBuilder(parentJobInstanceId.toString());
        strBuilder.append(':');
        strBuilder.append(splitId);
        strBuilder.append(':');
        strBuilder.append(flowId);
        return strBuilder.toString();
    }

    private static String generateSubJobId(Long parentJobInstanceId, String stepId, int partitionInstance) {
        StringBuilder strBuilder = new StringBuilder(parentJobInstanceId.toString());
        strBuilder.append(':');
        strBuilder.append(stepId);
        strBuilder.append(':');
        strBuilder.append(partitionInstance);
        return strBuilder.toString();
    }
}

