/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.ProcessItem;
import jsr352.batch.jsl.Property;

public class ItemProcessorProxy
extends AbstractProxy {
    private Method processItemMethod = null;

    ItemProcessorProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : this.delegate.getClass().getDeclaredMethods()) {
            ProcessItem processItem = method.getAnnotation(ProcessItem.class);
            if (processItem == null) continue;
            this.processItemMethod = method;
        }
    }

    public Object processItem(Object inputItem) throws Throwable {
        Object[] itemParam = new Object[]{inputItem};
        Object outputItem = null;
        if (this.processItemMethod != null) {
            try {
                outputItem = this.processItemMethod.invoke(this.delegate, itemParam);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        return outputItem;
    }

    public Method getProcessItemMethod() {
        return this.processItemMethod;
    }
}

