/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.transaction.impl;

import com.ibm.batch.container.exception.TransactionManagementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.spi.TransactionManagerSPI;

public class DefaultNonTransactionalManager
implements TransactionManagerSPI {
    private static final String CLASSNAME = DefaultNonTransactionalManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private int status = 6;

    public void begin() throws TransactionManagementException {
        logger.entering(CLASSNAME, "begin");
        this.status = 0;
        logger.log(Level.FINE, "javax.transaction.Status.ACTIVE: {0}", this.status);
        logger.exiting(CLASSNAME, "begin");
    }

    public void commit() throws TransactionManagementException {
        logger.entering(CLASSNAME, "commit");
        this.status = 3;
        logger.log(Level.FINE, "javax.transaction.Status.STATUS_COMMITTED: {0}", this.status);
        logger.exiting(CLASSNAME, "commit");
    }

    public void rollback() throws TransactionManagementException {
        logger.entering(CLASSNAME, "rollback");
        this.status = 4;
        logger.log(Level.FINE, "javax.transaction.Status.STATUS_ROLLEDBACK: {0}", this.status);
        logger.exiting(CLASSNAME, "rollback");
    }

    public int getStatus() throws TransactionManagementException {
        logger.entering(CLASSNAME, "getStatus");
        logger.exiting(CLASSNAME, "getStatus", this.status);
        return this.status;
    }

    public void setRollbackOnly() throws TransactionManagementException {
        logger.entering(CLASSNAME, "setRollbackOnly");
        this.status = 9;
        logger.log(Level.FINE, "javax.transaction.Status.STATUS_ROLLING_BACK: {0}", this.status);
        logger.exiting(CLASSNAME, "setRollbackOnly");
    }

    public void setTransactionTimeout(int seconds) throws TransactionManagementException {
        logger.entering(CLASSNAME, "setTransactionTimeout", seconds);
        logger.fine("do nothing");
        logger.exiting(CLASSNAME, "setTransactionTimeout");
    }
}

