/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.modelresolver.impl;

import com.ibm.batch.container.modelresolver.PropertyResolver;
import java.util.List;
import java.util.Properties;
import jsr352.batch.jsl.JSLProperties;
import jsr352.batch.jsl.Property;

public abstract class AbstractPropertyResolver<B>
implements PropertyResolver<B> {
    @Override
    public B substituteProperties(B b) {
        return this.substituteProperties(b, null, null);
    }

    @Override
    public B substituteProperties(B b, Properties submittedProps) {
        return this.substituteProperties(b, submittedProps, null);
    }

    protected Properties resolveElementProperties(List<Property> elementProperties, Properties submittedProps, Properties parentProps) {
        Properties currentXMLProperties = new Properties();
        currentXMLProperties = this.inheritProperties(parentProps, currentXMLProperties);
        for (Property prop : elementProperties) {
            String name = prop.getName();
            name = this.replaceAllProperties(name, submittedProps, currentXMLProperties);
            String value = prop.getValue();
            value = this.replaceAllProperties(value, submittedProps, currentXMLProperties);
            currentXMLProperties.setProperty(name, value);
            prop.setName(name);
            prop.setValue(value);
        }
        return currentXMLProperties;
    }

    protected String replaceAllProperties(String str, Properties submittedProps, Properties xmlProperties) {
        int startIndex = 0;
        NextProperty nextProp = this.findNextProperty(str, startIndex);
        while (nextProp != null) {
            startIndex = nextProp.endIndex;
            String nextPropValue = this.resolvePropertyValue(nextProp.propName, nextProp.propType, submittedProps, xmlProperties);
            int lengthDifference = 0;
            switch (nextProp.propType) {
                case JOB_PARAMETERS: {
                    lengthDifference = nextPropValue.length() - (nextProp.propName.length() + "#{jobParameters['']}".length());
                    startIndex += lengthDifference;
                    str = str.replace("#{jobParameters['" + nextProp.propName + "']}", nextPropValue);
                    break;
                }
                case JOB_PROPERTIES: {
                    lengthDifference = nextPropValue.length() - (nextProp.propName.length() + "#{jobProperties['']}".length());
                    startIndex += lengthDifference;
                    str = str.replace("#{jobProperties['" + nextProp.propName + "']}", nextPropValue);
                    break;
                }
                case SYSTEM_PROPERTIES: {
                    lengthDifference = nextPropValue.length() - (nextProp.propName.length() + "#{systemProperties['']}".length());
                    startIndex += lengthDifference;
                    str = str.replace("#{systemProperties['" + nextProp.propName + "']}", nextPropValue);
                }
            }
            nextProp = this.findNextProperty(str, startIndex);
        }
        return str;
    }

    private String resolvePropertyValue(String name, PROPERTY_TYPE propType, Properties submittedProperties, Properties xmlProperties) {
        String value = null;
        switch (propType) {
            case JOB_PARAMETERS: {
                if (submittedProperties != null) {
                    value = submittedProperties.getProperty(name);
                }
                if (value == null) break;
                return value;
            }
            case JOB_PROPERTIES: {
                if (xmlProperties != null) {
                    value = xmlProperties.getProperty(name);
                }
                if (value == null) break;
                return value;
            }
            case SYSTEM_PROPERTIES: {
                value = System.getProperty(name);
                if (value == null) break;
                return value;
            }
        }
        return "null";
    }

    private Properties inheritProperties(Properties parentProps, Properties childProps) {
        if (parentProps == null) {
            return childProps;
        }
        if (childProps == null) {
            return parentProps;
        }
        for (String parentKey : parentProps.stringPropertyNames()) {
            if (childProps.containsKey(parentKey)) continue;
            childProps.setProperty(parentKey, parentProps.getProperty(parentKey));
        }
        return childProps;
    }

    private int getEndIndexOfNextProperty(String str, int startIndex) {
        if (str == null) {
            return -1;
        }
        int startPropIndex = str.indexOf("${", startIndex);
        if (startPropIndex == -1) {
            return -1;
        }
        int endPropIndex = str.indexOf("}", startPropIndex);
        if (endPropIndex > startPropIndex) {
            return endPropIndex;
        }
        return -1;
    }

    private NextProperty findNextProperty(String str, int startIndex) {
        if (str == null) {
            return null;
        }
        int startPropIndex = str.indexOf("#{", startIndex);
        if (startPropIndex == -1) {
            return null;
        }
        PROPERTY_TYPE type = null;
        if (str.startsWith("#{jobParameters['", startPropIndex)) {
            type = PROPERTY_TYPE.JOB_PARAMETERS;
        } else if (str.startsWith("#{systemProperties['", startPropIndex)) {
            type = PROPERTY_TYPE.SYSTEM_PROPERTIES;
        } else if (str.startsWith("#{jobProperties['", startPropIndex)) {
            type = PROPERTY_TYPE.JOB_PROPERTIES;
        }
        if (type == null) {
            return null;
        }
        int endPropIndex = str.indexOf("']}");
        String propName = null;
        if (endPropIndex > startPropIndex) {
            if (type.equals((Object)PROPERTY_TYPE.JOB_PARAMETERS)) {
                propName = str.substring(startPropIndex + 17, endPropIndex);
            }
            if (type.equals((Object)PROPERTY_TYPE.JOB_PROPERTIES)) {
                propName = str.substring(startPropIndex + 17, endPropIndex);
            }
            if (type.equals((Object)PROPERTY_TYPE.SYSTEM_PROPERTIES)) {
                propName = str.substring(startPropIndex + 20, endPropIndex);
            }
            return new NextProperty(propName, type, startPropIndex, endPropIndex);
        }
        return null;
    }

    private Properties xmlPropertiesToJavaProperties(JSLProperties xmlProperties) {
        Properties props = new Properties();
        for (Property prop : xmlProperties.getPropertyList()) {
            props.setProperty(prop.getName(), prop.getValue());
        }
        return props;
    }

    class NextProperty {
        final String propName;
        final PROPERTY_TYPE propType;
        final int startIndex;
        final int endIndex;

        NextProperty(String propName, PROPERTY_TYPE propType, int startIndex, int endIndex) {
            this.propName = propName;
            this.propType = propType;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }

    private static enum PROPERTY_TYPE {
        JOB_PARAMETERS,
        SYSTEM_PROPERTIES,
        JOB_PROPERTIES;

    }
}

