/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.xjcl.impl;

import com.ibm.batch.container.xjcl.ExecutionElement;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.JSLProperties;
import jsr352.batch.jsl.Listeners;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;

public class JobMergeHelper {
    public void mergeParentJob(JSLJob parent, JSLJob child) {
        if (!parent.getId().equals(child.getParent())) {
            return;
        }
        child.setProperties(this.mergeProperties(parent.getProperties(), child.getProperties()));
        child.setListeners(this.mergeListeners(parent.getListeners(), child.getListeners()));
        for (ExecutionElement pElem : parent.getExecutionElements()) {
            boolean hasCollidingId = false;
            ExecutionElement collidingChildElement = null;
            for (ExecutionElement cElem : child.getExecutionElements()) {
                if (!pElem.getId().equals(cElem.getId())) continue;
                hasCollidingId = true;
                collidingChildElement = cElem;
            }
            if (hasCollidingId) {
                if (pElem instanceof Flow) {
                    this.mergeCollidingFlow(pElem, collidingChildElement);
                }
                if (pElem instanceof Step) {
                    this.mergeCollidingStep(pElem, collidingChildElement);
                }
                if (!(pElem instanceof Split)) continue;
                this.mergeCollidingSplit(pElem, collidingChildElement);
                continue;
            }
            child.getExecutionElements().add(pElem);
        }
    }

    private JSLProperties mergeProperties(JSLProperties parentProps, JSLProperties childProps) {
        if (parentProps == null) {
            return childProps;
        }
        if (childProps == null) {
            childProps = new JSLProperties();
        }
        childProps.getPropertyList().addAll(parentProps.getPropertyList());
        return childProps;
    }

    private Listeners mergeListeners(Listeners parentListeners, Listeners childListeners) {
        if (parentListeners == null) {
            return childListeners;
        }
        if (childListeners == null) {
            childListeners = new Listeners();
        }
        childListeners.getListenerList().addAll(parentListeners.getListenerList());
        return childListeners;
    }

    public void mergeCollidingFlow(ExecutionElement parent, ExecutionElement child) {
    }

    public void mergeCollidingStep(ExecutionElement parent, ExecutionElement child) {
    }

    public void mergeCollidingSplit(ExecutionElement parent, ExecutionElement child) {
    }
}

