/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.config.GlassfishThreadPoolConfigurationBean;
import com.ibm.batch.container.config.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.services.impl.AbstractThreadPoolServiceImpl;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlassfishThreadPoolServiceImpl
extends AbstractThreadPoolServiceImpl {
    private static final String sourceClass = GlassfishThreadPoolServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        String method = "init";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        GlassfishThreadPoolConfigurationBean threadPoolConfig = batchConfig.getGlassfishThreadPoolConfigurationBean();
        int idleThreadTimeout = threadPoolConfig.getIdleThreadTimeout();
        int maxQueueSize = threadPoolConfig.getMaxQueueSize();
        int maxThreadPoolSize = threadPoolConfig.getMaxThreadPoolSize();
        int minThreadPoolSize = threadPoolConfig.getMinThreadPoolSize();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Glassfish thread pool settings: (" + minThreadPoolSize + "," + maxThreadPoolSize + "," + idleThreadTimeout + "," + (Object)((Object)TimeUnit.SECONDS) + "," + maxQueueSize + ")");
        }
        LinkedBlockingQueue<Runnable> queue = null;
        queue = maxQueueSize == -1 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(maxQueueSize);
        this.executorService = new ThreadPoolExecutor(minThreadPoolSize, maxThreadPoolSize, idleThreadTimeout, TimeUnit.SECONDS, queue);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    public void updateConfig(GlassfishThreadPoolConfigurationBean threadPoolConfig) {
        int idleThreadTimeout = threadPoolConfig.getIdleThreadTimeout();
        int maxThreadPoolSize = threadPoolConfig.getMaxThreadPoolSize();
        int minThreadPoolSize = threadPoolConfig.getMinThreadPoolSize();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Updating glassfish thread pool with new settings: (" + minThreadPoolSize + "," + maxThreadPoolSize + "," + idleThreadTimeout + "," + (Object)((Object)TimeUnit.SECONDS) + ")");
        }
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.executorService;
        executor.setCorePoolSize(minThreadPoolSize);
        executor.setMaximumPoolSize(maxThreadPoolSize);
        executor.setKeepAliveTime(idleThreadTimeout, TimeUnit.SECONDS);
    }
}

