/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.io.Externalizable;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.AnalyzeCollectorData;
import javax.batch.annotation.AnalyzeExitStatus;
import jsr352.batch.jsl.Property;

public class PartitionAnalyzerProxy
extends AbstractProxy {
    private Method analyzeCollectorDataMethod = null;
    private Method analyzeExitStatusMethod = null;

    PartitionAnalyzerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : delegate.getClass().getDeclaredMethods()) {
            AnalyzeExitStatus afterJob;
            AnalyzeCollectorData beforeJob = method.getAnnotation(AnalyzeCollectorData.class);
            if (beforeJob != null) {
                this.analyzeExitStatusMethod = method;
            }
            if ((afterJob = method.getAnnotation(AnalyzeExitStatus.class)) == null) continue;
            this.analyzeCollectorDataMethod = method;
        }
    }

    public synchronized void analyzeCollectorData(Externalizable data) {
        if (this.analyzeExitStatusMethod != null) {
            try {
                this.analyzeExitStatusMethod.invoke(this.delegate, data);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public synchronized void analyzeExitStatus(String exitStatus) {
        if (this.analyzeCollectorDataMethod != null) {
            try {
                this.analyzeCollectorDataMethod.invoke(this.delegate, exitStatus);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

