/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.ws.batch.container.checkpoint.CheckpointAlgorithm;
import com.ibm.ws.batch.container.checkpoint.ItemCheckpointAlgorithm;
import com.ibm.ws.batch.container.checkpoint.ItemTimeCheckpointAlgorithm;
import com.ibm.ws.batch.container.checkpoint.TimeCheckpointAlgorithm;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.BeginCheckpoint;
import javax.batch.annotation.CheckpointTimeout;
import javax.batch.annotation.EndCheckpoint;
import javax.batch.annotation.IsReadyToCheckpoint;
import jsr352.batch.jsl.Property;

public class CheckpointAlgorithmProxy
extends AbstractProxy
implements CheckpointAlgorithm {
    private Method getCheckpointTimeOutMethod = null;
    private Method beginCheckpointMethod = null;
    private Method isReadyToCheckpointMethod = null;
    private Method endCheckpointMethod = null;
    private String checkpointType = null;
    private String checkpointName = null;

    public CheckpointAlgorithmProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : this.delegate.getClass().getDeclaredMethods()) {
            EndCheckpoint endCheckpoint;
            IsReadyToCheckpoint isReadyToCheckpoint;
            BeginCheckpoint beginCheckpoint;
            CheckpointTimeout getCheckpointTimeOut = method.getAnnotation(CheckpointTimeout.class);
            if (getCheckpointTimeOut != null) {
                this.getCheckpointTimeOutMethod = method;
            }
            if ((beginCheckpoint = method.getAnnotation(BeginCheckpoint.class)) != null) {
                this.beginCheckpointMethod = method;
            }
            if ((isReadyToCheckpoint = method.getAnnotation(IsReadyToCheckpoint.class)) != null) {
                this.isReadyToCheckpointMethod = method;
            }
            if ((endCheckpoint = method.getAnnotation(EndCheckpoint.class)) != null) {
                this.endCheckpointMethod = method;
            }
            if (delegate instanceof ItemCheckpointAlgorithm) {
                this.checkpointType = "item";
                this.checkpointName = ItemCheckpointAlgorithm.class.getName();
                continue;
            }
            if (delegate instanceof TimeCheckpointAlgorithm) {
                this.checkpointType = "time";
                this.checkpointName = TimeCheckpointAlgorithm.class.getName();
                continue;
            }
            this.checkpointType = "custom";
            if (delegate instanceof ItemTimeCheckpointAlgorithm) {
                this.checkpointType = "item-time";
                this.checkpointName = ItemTimeCheckpointAlgorithm.class.getName();
                continue;
            }
            this.checkpointType = "custom";
            this.checkpointName = delegate.getClass().getName();
        }
    }

    public int getCheckpointTimeOut(int timeOut) {
        int retTimeOut = 0;
        if (this.getCheckpointTimeOutMethod != null) {
            try {
                retTimeOut = (Integer)this.getCheckpointTimeOutMethod.invoke(this.delegate, timeOut);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
        return retTimeOut;
    }

    public void beginCheckpoint() {
        if (this.beginCheckpointMethod != null) {
            try {
                this.beginCheckpointMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void endCheckpoint() {
        if (this.endCheckpointMethod != null) {
            try {
                this.endCheckpointMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public boolean isReadyToCheckpointMethod() {
        Boolean ret = false;
        if (this.isReadyToCheckpointMethod != null) {
            try {
                ret = (Boolean)this.isReadyToCheckpointMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
        return ret;
    }

    public String getCheckpointType() {
        return this.checkpointType;
    }

    public String getCheckpointAlgorithmClassName() {
        return this.checkpointName;
    }

    @Override
    public boolean isReadyToCheckpoint() throws Exception {
        return this.isReadyToCheckpointMethod();
    }

    @Override
    public void setThreshold(int INthreshHold) {
    }

    @Override
    public void setThresholds(int itemthreshold, int timethreshold) {
    }
}

