/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.AfterWrite;
import javax.batch.annotation.BeforeWrite;
import javax.batch.annotation.OnWriteError;
import jsr352.batch.jsl.Property;

public class ItemWriteListenerProxy
extends AbstractProxy {
    private Method beforeWriteMethod = null;
    private Method afterWriteMethod = null;
    private Method onWriteErrorMethod = null;

    ItemWriteListenerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : this.delegate.getClass().getDeclaredMethods()) {
            OnWriteError onWriteError;
            AfterWrite afterWrite;
            BeforeWrite beforeWrite = method.getAnnotation(BeforeWrite.class);
            if (beforeWrite != null) {
                this.beforeWriteMethod = method;
            }
            if ((afterWrite = method.getAnnotation(AfterWrite.class)) != null) {
                this.afterWriteMethod = method;
            }
            if ((onWriteError = method.getAnnotation(OnWriteError.class)) == null) continue;
            this.onWriteErrorMethod = method;
        }
    }

    public void beforeWrite() {
        if (this.beforeWriteMethod != null) {
            try {
                this.beforeWriteMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void afterWrite() {
        if (this.afterWriteMethod != null) {
            try {
                this.afterWriteMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onWriteError() {
        if (this.onWriteErrorMethod != null) {
            try {
                this.onWriteErrorMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

