/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodev.graphql.tools;

import com.coxautodev.graphql.tools.GenericType;
import com.coxautodev.graphql.tools.SchemaClassScannerError;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ScalarTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.ScalarInfo;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019BA\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J*\u0010\u0014\u001a\u00020\u00152\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/coxautodev/graphql/tools/TypeClassMatcher;", "", "graphQLType", "Lgraphql/language/Type;", "Lcom/coxautodev/graphql/tools/GraphQLLangType;", "javaType", "Ljava/lang/reflect/Type;", "Lcom/coxautodev/graphql/tools/JavaType;", "generic", "Lcom/coxautodev/graphql/tools/GenericType;", "location", "Lcom/coxautodev/graphql/tools/TypeClassMatcher$Location;", "definitionsByName", "", "", "Lgraphql/language/TypeDefinition;", "(Lgraphql/language/Type;Ljava/lang/reflect/Type;Lcom/coxautodev/graphql/tools/GenericType;Lcom/coxautodev/graphql/tools/TypeClassMatcher$Location;Ljava/util/Map;)V", "error", "Lcom/coxautodev/graphql/tools/SchemaClassScannerError;", "msg", "match", "Lcom/coxautodev/graphql/tools/TypeClassMatcher$Match;", "root", "", "Location", "Match", "graphql-java-tools"})
public final class TypeClassMatcher {
    private final graphql.language.Type graphQLType;
    private final Type javaType;
    private final GenericType generic;
    private final Location location;
    private final Map<String, TypeDefinition> definitionsByName;

    private final SchemaClassScannerError error(String msg) {
        return new SchemaClassScannerError("Unable to match type definition (" + this.graphQLType + ") with java type (" + this.javaType + "): " + msg, null, 2, null);
    }

    @NotNull
    public final Match match() {
        return this.match(this.graphQLType, this.javaType, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Match match(graphql.language.Type graphQLType, Type javaType, boolean root) {
        Match match;
        graphql.language.Type type;
        Type realType = this.generic.unwrapGenericWrapper(javaType);
        boolean optional = false;
        if (realType instanceof ParameterizedType && this.generic.isTypeAssignableFromRawClass((ParameterizedType)realType, Optional.class)) {
            optional = true;
            if (Intrinsics.areEqual((Object)((Object)this.location), (Object)((Object)Location.RETURN_TYPE)) && !root) {
                throw (Throwable)this.error(Optional.class.getName() + " can only be used at the top level of a return type");
            }
            Object object = ArraysKt.first((Object[])((ParameterizedType)realType).getActualTypeArguments());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"realType.actualTypeArguments.first()");
            realType = this.generic.unwrapGenericWrapper((Type)object);
            if (realType instanceof ParameterizedType && this.generic.isTypeAssignableFromRawClass((ParameterizedType)realType, Optional.class)) {
                throw (Throwable)this.error(Optional.class.getName() + " cannot be nested within itself");
            }
        }
        if ((type = graphQLType) instanceof NonNullType) {
            if (optional) {
                throw (Throwable)this.error("graphql type is marked as nonnull but " + Optional.class.getName() + " was used");
            }
            graphql.language.Type type2 = ((NonNullType)graphQLType).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"graphQLType.type");
            match = TypeClassMatcher.match$default(this, type2, realType, false, 4, null);
            return match;
        } else if (type instanceof ListType) {
            if (!(realType instanceof ParameterizedType) || !this.generic.isTypeAssignableFromRawClass((ParameterizedType)realType, List.class)) throw (Throwable)this.error("Java class is not a List: " + realType);
            graphql.language.Type type3 = ((ListType)graphQLType).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"graphQLType.type");
            Object object = ArraysKt.first((Object[])((ParameterizedType)realType).getActualTypeArguments());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"realType.actualTypeArguments.first()");
            match = TypeClassMatcher.match$default(this, type3, (Type)object, false, 4, null);
            return match;
        } else if (type instanceof TypeName) {
            ScalarTypeDefinition scalarTypeDefinition = (ScalarTypeDefinition)ScalarInfo.STANDARD_SCALAR_DEFINITIONS.get(((TypeName)graphQLType).getName());
            TypeDefinition typeDefinition = scalarTypeDefinition != null ? (TypeDefinition)scalarTypeDefinition : this.definitionsByName.get(((TypeName)graphQLType).getName());
            if (typeDefinition == null) {
                throw (Throwable)new SchemaClassScannerError("No " + TypeDefinition.class.getSimpleName() + " for type name " + ((TypeName)graphQLType).getName(), null, 2, null);
            }
            TypeDefinition typeDefinition2 = typeDefinition;
            match = new Match(typeDefinition2, this.generic.getRawClass(realType));
            return match;
        } else {
            if (!(type instanceof TypeDefinition)) throw (Throwable)this.error("Unknown type: " + realType.getClass().getName());
            match = new Match((TypeDefinition)graphQLType, this.generic.getRawClass(realType));
        }
        return match;
    }

    static /* bridge */ /* synthetic */ Match match$default(TypeClassMatcher typeClassMatcher, graphql.language.Type type, Type type2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return typeClassMatcher.match(type, type2, bl);
    }

    public TypeClassMatcher(@NotNull graphql.language.Type graphQLType, @NotNull Type javaType, @NotNull GenericType generic, @NotNull Location location, @NotNull Map<String, ? extends TypeDefinition> definitionsByName) {
        Intrinsics.checkParameterIsNotNull((Object)graphQLType, (String)"graphQLType");
        Intrinsics.checkParameterIsNotNull((Object)javaType, (String)"javaType");
        Intrinsics.checkParameterIsNotNull((Object)generic, (String)"generic");
        Intrinsics.checkParameterIsNotNull((Object)((Object)location), (String)"location");
        Intrinsics.checkParameterIsNotNull(definitionsByName, (String)"definitionsByName");
        this.graphQLType = graphQLType;
        this.javaType = javaType;
        this.generic = generic;
        this.location = location;
        this.definitionsByName = definitionsByName;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/coxautodev/graphql/tools/TypeClassMatcher$Match;", "", "type", "Lgraphql/language/TypeDefinition;", "clazz", "Ljava/lang/Class;", "(Lgraphql/language/TypeDefinition;Ljava/lang/Class;)V", "getClazz", "()Ljava/lang/Class;", "getType", "()Lgraphql/language/TypeDefinition;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "graphql-java-tools"})
    public static final class Match {
        @NotNull
        private final TypeDefinition type;
        @NotNull
        private final Class<?> clazz;

        @NotNull
        public final TypeDefinition getType() {
            return this.type;
        }

        @NotNull
        public final Class<?> getClazz() {
            return this.clazz;
        }

        public Match(@NotNull TypeDefinition type, @NotNull Class<?> clazz) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            this.type = type;
            this.clazz = clazz;
        }

        @NotNull
        public final TypeDefinition component1() {
            return this.type;
        }

        @NotNull
        public final Class<?> component2() {
            return this.clazz;
        }

        @NotNull
        public final Match copy(@NotNull TypeDefinition type, @NotNull Class<?> clazz) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            return new Match(type, clazz);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Match copy$default(Match match, TypeDefinition typeDefinition, Class clazz, int n, Object object) {
            if ((n & 1) != 0) {
                typeDefinition = match.type;
            }
            if ((n & 2) != 0) {
                clazz = match.clazz;
            }
            return match.copy(typeDefinition, clazz);
        }

        public String toString() {
            return "Match(type=" + this.type + ", clazz=" + this.clazz + ")";
        }

        public int hashCode() {
            TypeDefinition typeDefinition = this.type;
            Class<?> clazz = this.clazz;
            return (typeDefinition != null ? typeDefinition.hashCode() : 0) * 31 + (clazz != null ? clazz.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Match)) break block3;
                    Match match = (Match)object;
                    if (!Intrinsics.areEqual((Object)this.type, (Object)match.type) || !Intrinsics.areEqual(this.clazz, match.clazz)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/coxautodev/graphql/tools/TypeClassMatcher$Location;", "", "(Ljava/lang/String;I)V", "RETURN_TYPE", "PARAMETER_TYPE", "graphql-java-tools"})
    public static final class Location
    extends Enum<Location> {
        public static final /* enum */ Location RETURN_TYPE;
        public static final /* enum */ Location PARAMETER_TYPE;
        private static final /* synthetic */ Location[] $VALUES;

        static {
            Location[] locationArray = new Location[2];
            Location[] locationArray2 = locationArray;
            locationArray[0] = RETURN_TYPE = new Location();
            locationArray[1] = PARAMETER_TYPE = new Location();
            $VALUES = locationArray;
        }

        public static Location[] values() {
            return (Location[])$VALUES.clone();
        }

        public static Location valueOf(String string) {
            return Enum.valueOf(Location.class, string);
        }
    }
}

