/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.googlecode.wicket.kendo.ui;

import com.googlecode.wicket.kendo.ui.form.button.Button;

/**
 * Provides default Kendo UI icons. Might be used to decorate a {@link Button} for instance.
 *
 * @author Sebastien Briquet - sebfz1
 * @see <a href="http://docs.telerik.com/kendo-ui/styles-and-layout/icons-web">http://docs.telerik.com/kendo-ui/styles-and-layout/icons-web</a>
 *
 */
public class KendoIcon
{
	/** css class mastering icon display */
	public static final String K_ICON = "k-icon";

	public static final String NONE = "";

	// Actions //
	public static final String UNDO = "undo";
	public static final String REDO = "redo";
	public static final String RESET = "reset";
	public static final String RELOAD = "reload";
	public static final String REFRESH = "refresh";
	public static final String NON_RECURRENCE = "non-recurrence";
	public static final String RESET_SM = "reset-sm";
	public static final String RELOAD_SM = "reload-sm";
	public static final String REFRESH_SM = "refresh-sm";
	public static final String CLOCK = "clock";
	public static final String CALENDAR = "calendar";
	public static final String SAVE = "save";
	public static final String FLOPPY = "floppy";
	public static final String PRINT = "print";
	public static final String PRINTER = "printer";
	public static final String EDIT = "edit";
	public static final String PENCIL = "pencil";
	public static final String DELETE = "delete";
	public static final String TRASH = "trash";
	public static final String ATTACHMENT = "attachment";
	public static final String CLIP = "clip";
	public static final String ATTACHMENT_45 = "attachment-45";
	public static final String CLIP_45 = "clip-45";
	public static final String LINK_HORIZONTAL = "link-horizontal";
	public static final String HYPERLINK = "hyperlink";
	public static final String UNLINK_HORIZONTAL = "unlink-horizontal";
	public static final String HYPERLINK_REMOVE = "hyperlink-remove";
	public static final String LINK_VERTICAL = "link-vertical";
	public static final String UNLINK_VERTICAL = "unlink-vertical";
	public static final String LOCK = "lock";
	public static final String UNLOCK = "unlock";
	public static final String CANCEL = "cancel";
	public static final String CANCEL_OUTLINE = "cancel-outline";
	public static final String CANCEL_CIRCLE = "cancel-circle";
	public static final String CHECK = "check";
	public static final String CHECKMARK = "checkmark";
	public static final String CHECK_OUTLINE = "check-outline";
	public static final String CHECKMARK_OUTLINE = "checkmark-outline";
	public static final String CHECK_CIRCLE = "check-circle";
	public static final String CHECKMARK_CIRCLE = "checkmark-circle";
	public static final String CLOSE = "close";
	public static final String X = "x";
	public static final String CLOSE_OUTLINE = "close-outline";
	public static final String X_OUTLINE = "x-outline";
	public static final String CLOSE_CIRCLE = "close-circle";
	public static final String X_CIRCLE = "x-circle";
	public static final String PLUS = "plus";
	public static final String PLUS_OUTLINE = "plus-outline";
	public static final String PLUS_CIRCLE = "plus-circle";
	public static final String MINUS = "minus";
	public static final String MINUS_OUTLINE = "minus-outline";
	public static final String MINUS_CIRCLE = "minus-circle";
	public static final String SORT_ASC = "sort-asc";
	public static final String SORT_DESC = "sort-desc";
	public static final String UNSORT = "unsort";
	public static final String SORT_CLEAR = "sort-clear";
	public static final String SORT_ASC_SM = "sort-asc-sm";
	public static final String SORT_DESC_SM = "sort-desc-sm";
	public static final String FILTER = "filter";
	public static final String FILTER_CLEAR = "filter-clear";
	public static final String FILTER_SM = "filter-sm";
	public static final String FILTER_SORT_ASC_SM = "filter-sort-asc-sm";
	public static final String FILTER_SORT_DESC_SM = "filter-sort-desc-sm";
	public static final String FILTER_ADD_EXPRESSION = "filter-add-expression";
	public static final String FILTER_ADD_GROUP = "filter-add-group";
	public static final String LOGIN = "login";
	public static final String LOGOUT = "logout";
	public static final String DOWNLOAD = "download";
	public static final String UPLOAD = "upload";
	public static final String HYPERLINK_OPEN = "hyperlink-open";
	public static final String HYPERLINK_OPEN_SM = "hyperlink-open-sm";
	public static final String LAUNCH = "launch";
	public static final String WINDOW = "window";
	public static final String WINDOW_MAXIMIZE = "window-maximize";
	public static final String WINDOWS = "windows";
	public static final String WINDOW_RESTORE = "window-restore";
	public static final String TILES = "tiles";
	public static final String WINDOW_MINIMIZE = "window-minimize";
	public static final String GEAR = "gear";
	public static final String COG = "cog";
	public static final String CUSTOM = "custom";
	public static final String GEARS = "gears";
	public static final String COGS = "cogs";
	public static final String WRENCH = "wrench";
	public static final String SETTINGS = "settings";
	public static final String PREVIEW = "preview";
	public static final String EYE = "eye";
	public static final String ZOOM = "zoom";
	public static final String SEARCH = "search";
	public static final String ZOOM_IN = "zoom-in";
	public static final String ZOOM_OUT = "zoom-out";
	public static final String PAN = "pan";
	public static final String MOVE = "move";
	public static final String CALCULATOR = "calculator";
	public static final String CART = "cart";
	public static final String SHOPPING_CART = "shopping-cart";
	public static final String CONNECTOR = "connector";
	public static final String PLUS_SM = "plus-sm";
	public static final String MINUS_SM = "minus-sm";
	
	// Alerts and Notifications //
	public static final String NOTIFICATION = "notification";
	public static final String BELL = "bell";
	public static final String INFORMATION = "information";
	public static final String INFO = "info";
	public static final String QUESTION = "question";
	public static final String HELP = "help";
	public static final String WARNING = "warning";
	public static final String EXCEPTION = "exception";
	public static final String ERROR = "error";

	// Editing //
	public static final String PAGE_PROPERTIES = "page-properties";
	public static final String BOLD = "bold";
	public static final String ITALIC = "italic";
	public static final String UNDERLINE = "underline";
	public static final String FONT_FAMILY = "font-family";
	public static final String FOREGROUND_COLOR = "foreground-color";
	public static final String CONVERT_LOWERCASE = "convert-lowercase";
	public static final String CONVERT_UPPERCASE = "convert-uppercase";
	public static final String STRIKETHROUGH = "strikethrough";
	public static final String SUB_SCRIPT = "sub-script";
	public static final String SUP_SCRIPT = "sup-script";
	public static final String DIV = "div";
	public static final String ALL = "all";
	public static final String H1 = "h1";
	public static final String H2 = "h2";
	public static final String H3 = "h3";
	public static final String H4 = "h4";
	public static final String H5 = "h5";
	public static final String H6 = "h6";
	public static final String LIST_ORDERED = "list-ordered";
	public static final String LIST_NUMBERED = "list-numbered";
	public static final String LIST_UNORDERED = "list-unordered";
	public static final String LIST_BULLETED = "list-bulleted";
	public static final String INDENT_INCREASE = "indent-increase";
	public static final String INDENT = "indent";
	public static final String INDENT_DECREASE = "indent-decrease";
	public static final String OUTDENT = "outdent";
	public static final String INSERT_UP = "insert-up";
	public static final String INSERT_TOP = "insert-top";
	public static final String INSERT_MIDDLE = "insert-middle";
	public static final String INSERT_DOWN = "insert-down";
	public static final String INSERT_BOTTOM = "insert-bottom";
	public static final String ALIGN_TOP = "align-top";
	public static final String ALIGN_MIDDLE = "align-middle";
	public static final String ALIGN_BOTTOM = "align-bottom";
	public static final String ALIGN_LEFT = "align-left";
	public static final String ALIGN_CENTER = "align-center";
	public static final String ALIGN_RIGHT = "align-right";
	public static final String ALIGN_JUSTIFY = "align-justify";
	public static final String ALIGN_REMOVE = "align-remove";
	public static final String TEXT_WRAP = "text-wrap";
	public static final String RULE_HORIZONTAL = "rule-horizontal";
	public static final String TABLE_ALIGN_TOP_LEFT = "table-align-top-left";
	public static final String TABLE_ALIGN_TOP_CENTER = "table-align-top-center";
	public static final String TABLE_ALIGN_TOP_RIGHT = "table-align-top-right";
	public static final String TABLE_ALIGN_MIDDLE_LEFT = "table-align-middle-left";
	public static final String TABLE_ALIGN_MIDDLE_CENTER = "table-align-middle-center";
	public static final String TABLE_ALIGN_MIDDLE_RIGHT = "table-align-middle-right";
	public static final String TABLE_ALIGN_BOTTOM_LEFT = "table-align-bottom-left";
	public static final String TABLE_ALIGN_BOTTOM_CENTER = "table-align-bottom-center";
	public static final String TABLE_ALIGN_BOTTOM_RIGHT = "table-align-bottom-right";
	public static final String TABLE_ALIGN_REMOVE = "table-align-remove";
	public static final String BORDERS_ALL = "borders-all";
	public static final String BORDERS_OUTSIDE = "borders-outside";
	public static final String BORDERS_INSIDE = "borders-inside";
	public static final String BORDERS_INSIDE_HORIZONTAL = "borders-inside-horizontal";
	public static final String BORDERS_INSIDE_VERTICAL = "borders-inside-vertical";
	public static final String BORDER_TOP = "border-top";
	public static final String BORDER_BOTTOM = "border-bottom";
	public static final String BORDER_LEFT = "border-left";
	public static final String BORDER_RIGHT = "border-right";
	public static final String BORDER_NO = "border-no";
	public static final String BORDERS_SHOW_HIDE = "borders-show-hide";
	public static final String FORM = "form";
	public static final String BORDER = "border";
	public static final String FORM_ELEMENT = "form-element";
	public static final String CODE_SNIPPET = "code-snippet";
	public static final String SELECT_ALL = "select-all";
	public static final String BUTTON = "button";
	public static final String SELECT_BOX = "select-box";
	public static final String CALENDAR_DATE = "calendar-date";
	public static final String GROUP_BOX = "group-box";
	public static final String TEXTAREA = "textarea";
	public static final String TEXTBOX = "textbox";
	public static final String TEXTBOX_HIDDEN = "textbox-hidden";
	public static final String PASSWORD = "password"; // NOSONAR
	public static final String PARAGRAPH_ADD = "paragraph-add";
	public static final String EDIT_TOOLS = "edit-tools";
	public static final String TEMPLATE_MANAGER = "template-manager";
	public static final String CHANGE_MANUALLY = "change-manually";
	public static final String TRACK_CHANGES = "track-changes";
	public static final String TRACK_CHANGES_ENABLE = "track-changes-enable";
	public static final String TRACK_CHANGES_ACCEPT = "track-changes-accept";
	public static final String TRACK_CHANGES_ACCEPT_ALL = "track-changes-accept-all";
	public static final String TRACK_CHANGES_REJECT = "track-changes-reject";
	public static final String TRACK_CHANGES_REJECT_ALL = "track-changes-reject-all";
	public static final String DOCUMENT_MANAGER = "document-manager";
	public static final String CUSTOM_ICON = "custom-icon";
	public static final String DICTIONARY_ADD = "dictionary-add";
	public static final String IMAGE_LIGHT_DIALOG = "image-light-dialog";
	public static final String IMAGE_INSERT = "image-insert";
	public static final String IMAGE_EDIT = "image-edit";
	public static final String IMAGE_MAP_EDITOR = "image-map-editor";
	public static final String COMMENT = "comment";
	public static final String COMMENT_REMOVE = "comment-remove";
	public static final String COMMENTS_REMOVE_ALL = "comments-remove-all";
	public static final String SILVERLIGHT = "silverlight";
	public static final String MEDIA_MANAGER = "media-manager";
	public static final String VIDEO_EXTERNAL = "video-external";
	public static final String FLASH_MANAGER = "flash-manager";
	public static final String FIND_AND_REPLACE = "find-and-replace";
	public static final String FIND = "find";
	public static final String COPY = "copy";
	public static final String FILES = "files";
	public static final String CUT = "cut";
	public static final String PASTE = "paste";
	public static final String PASTE_AS_HTML = "paste-as-html";
	public static final String PASTE_FROM_WORD = "paste-from-word";
	public static final String PASTE_FROM_WORD_STRIP_FILE = "paste-from-word-strip-file";
	public static final String PASTE_HTML = "paste-html";
	public static final String PASTE_MARKDOWN = "paste-markdown";
	public static final String PASTE_PLAIN_TEXT = "paste-plain-text";
	public static final String APPLY_FORMAT = "apply-format";
	public static final String CLEAR_CSS = "clear-css";
	public static final String COPY_FORMAT = "copy-format";
	public static final String STRIP_ALL_FORMATING = "strip-all-formating";
	public static final String STRIP_CSS_FORMAT = "strip-css-format";
	public static final String STRIP_FONT_ELEMENTS = "strip-font-elements";
	public static final String STRIP_SPAN_ELEMENTS = "strip-span-elements";
	public static final String STRIP_WORD_FORMATTING = "strip-word-formatting";
	public static final String FORMAT_CODE_BLOCK = "format-code-block";
	public static final String STYLE_BUILDER = "style-builder";
	public static final String MODULE_MANAGER = "module-manager";
	public static final String HYPERLINK_LIGHT_DIALOG = "hyperlink-light-dialog";
	public static final String HYPERLINK_INSERT = "hyperlink-insert";
	public static final String HYPERLINK_GLOBE = "hyperlink-globe";
	public static final String HYPERLINK_GLOBE_REMOVE = "hyperlink-globe-remove";
	public static final String HYPERLINK_EMAIL = "hyperlink-email";
	public static final String ANCHOR = "anchor";
	public static final String TABLE_LIGHT_DIALOG = "table-light-dialog";
	public static final String TABLE_INSERT = "table-insert";
	public static final String TABLE = "table";
	public static final String TABLE_UNMERGE = "table-unmerge";
	public static final String TABLE_PROPERTIES = "table-properties";
	public static final String TABLE_CELL = "table-cell";
	public static final String TABLE_CELL_PROPERTIES = "table-cell-properties";
	public static final String TABLE_COLUMN_INSERT_LEFT = "table-column-insert-left";
	public static final String TABLE_COLUMN_INSERT_RIGHT = "table-column-insert-right";
	public static final String TABLE_ROW_INSERT_ABOVE = "table-row-insert-above";
	public static final String TABLE_ROW_INSERT_BELOW = "table-row-insert-below";
	public static final String TABLE_COLUMN_DELETE = "table-column-delete";
	public static final String TABLE_ROW_DELETE = "table-row-delete";
	public static final String TABLE_CELL_DELETE = "table-cell-delete";
	public static final String TABLE_DELETE = "table-delete";
	public static final String CELLS_MERGE = "cells-merge";
	public static final String CELLS_MERGE_HORIZONTALLY = "cells-merge-horizontally";
	public static final String CELLS_MERGE_VERTICALLY = "cells-merge-vertically";
	public static final String CELL_SPLIT_HORIZONTALLY = "cell-split-horizontally";
	public static final String CELL_SPLIT_VERTICALLY = "cell-split-vertically";
	public static final String PANE_FREEZE = "pane-freeze";
	public static final String ROW_FREEZE = "row-freeze";
	public static final String COLUMN_FREEZE = "column-freeze";
	public static final String TOOLBAR_FLOAT = "toolbar-float";
	public static final String SPELL_CHECKER = "spell-checker";
	public static final String VALIDATION_XHTML = "validation-xhtml";
	public static final String VALIDATION_DATA = "validation-data";
	public static final String TOGGLE_FULL_SCREEN_MODE = "toggle-full-screen-mode";
	public static final String FORMULA_FX = "formula-fx";
	public static final String SUM = "sum";
	public static final String SYMBOL = "symbol";
	public static final String DOLLAR = "dollar";
	public static final String CURRENCY = "currency";
	public static final String PERCENT = "percent";
	public static final String CUSTOM_FORMAT = "custom-format";
	public static final String DECIMAL_INCREASE = "decimal-increase";
	public static final String DECIMAL_DECREASE = "decimal-decrease";
	public static final String FONT_SIZE = "font-size";
	public static final String IMAGE_ABSOLUTE_POSITION = "image-absolute-position";
	
	// Files and Folders //
	public static final String FOLDER = "folder";
	public static final String FOLDER_OPEN = "folder-open";
	public static final String FOLDER_ADD = "folder-add";
	public static final String FOLDER_UP = "folder-up";
	public static final String FOLDER_MORE = "folder-more";
	public static final String FIELDS_MORE = "fields-more";
	public static final String AGGREGATE_FIELDS = "aggregate-fields";
	public static final String FILE = "file";
	public static final String FILE_VERTICAL = "file-vertical";
	public static final String FILE_ADD = "file-add";
	public static final String FILE_TXT = "file-txt";
	public static final String TXT = "txt";
	public static final String FILE_CSV = "file-csv";
	public static final String CSV = "csv";
	public static final String FILE_EXCEL = "file-excel";
	public static final String FILE_XLS = "file-xls";
	public static final String EXCEL = "excel";
	public static final String XLS = "xls";
	public static final String FILE_WORD = "file-word";
	public static final String FILE_DOC = "file-doc";
	public static final String WORD = "word";
	public static final String DOC = "doc";
	public static final String FILE_MDB = "file-mdb";
	public static final String MDB = "mdb";
	public static final String FILE_PPT = "file-ppt";
	public static final String PPT = "ppt";
	public static final String FILE_PDF = "file-pdf";
	public static final String PDF = "pdf";
	public static final String FILE_PSD = "file-psd";
	public static final String PSD = "psd";
	public static final String FILE_FLASH = "file-flash";
	public static final String FLASH = "flash";
	public static final String FILE_CONFIG = "file-config";
	public static final String CONFIG = "config";
	public static final String FILE_ASCX = "file-ascx";
	public static final String ASCX = "ascx";
	public static final String FILE_BAC = "file-bac";
	public static final String BAC = "bac";
	public static final String FILE_ZIP = "file-zip";
	public static final String ZIP = "zip";
	public static final String FILM = "film";
	public static final String CSS3 = "css3";
	public static final String HTML5 = "html5";
	public static final String HTML = "html";
	public static final String SOURCE_CODE = "source-code";
	public static final String VIEW_SOURCE = "view-source";
	public static final String CSS = "css";
	public static final String JS = "js";
	public static final String EXE = "exe";
	public static final String CSPROJ = "csproj";
	public static final String VBPROJ = "vbproj";
	public static final String CS = "cs";
	public static final String VB = "vb";
	public static final String SLN = "sln";
	public static final String CLOUD = "cloud";
	public static final String FILE_HORIZONTAL = "file-horizontal";

	// Images //
	public static final String PHOTO_CAMERA = "photo-camera";
	public static final String IMAGE = "image";
	public static final String PHOTO = "photo";
	public static final String IMAGE_EXPORT = "image-export";
	public static final String PHOTO_EXPORT = "photo-export";
	public static final String ZOOM_ACTUAL_SIZE = "zoom-actual-size";
	public static final String ZOOM_BEST_FIT = "zoom-best-fit";
	public static final String IMAGE_RESIZE = "image-resize";
	public static final String CROP = "crop";
	public static final String MIRROR = "mirror";
	public static final String FLIP_HORIZONTAL = "flip-horizontal";
	public static final String FLIP_VERTICAL = "flip-vertical";
	public static final String ROTATE = "rotate";
	public static final String ROTATE_RIGHT = "rotate-right";
	public static final String ROTATE_LEFT = "rotate-left";
	public static final String BRUSH = "brush";
	public static final String PALETTE = "palette";
	public static final String PAINT = "paint";
	public static final String DROPLET = "droplet";
	public static final String BACKGROUND = "background";
	public static final String LINE = "line";
	public static final String SHAPE_LINE = "shape-line";
	public static final String BRIGHTNESS_CONTRAST = "brightness-contrast";
	public static final String SATURATION = "saturation";
	public static final String INVERT_COLORS = "invert-colors";
	public static final String TRANSPERANCY = "transperancy";
	public static final String OPACITY = "opacity";
	public static final String GREYSCALE = "greyscale";
	public static final String BLUR = "blur";
	public static final String SHARPEN = "sharpen";
	public static final String SHAPE = "shape";
	public static final String ROUND_CORNERS = "round-corners";
	public static final String FRONT_ELEMENT = "front-element";
	public static final String BACK_ELEMENT = "back-element";
	public static final String FORWARD_ELEMENT = "forward-element";
	public static final String BACKWARD_ELEMENT = "backward-element";
	public static final String ALIGN_LEFT_ELEMENT = "align-left-element";
	public static final String ALIGN_CENTER_ELEMENT = "align-center-element";
	public static final String ALIGN_RIGHT_ELEMENT = "align-right-element";
	public static final String ALIGN_TOP_ELEMENT = "align-top-element";
	public static final String ALIGN_MIDDLE_ELEMENT = "align-middle-element";
	public static final String ALIGN_BOTTOM_ELEMENT = "align-bottom-element";
	public static final String THUMBNAILS_UP = "thumbnails-up";
	public static final String THUMBNAILS_RIGHT = "thumbnails-right";
	public static final String THUMBNAILS_DOWN = "thumbnails-down";
	public static final String THUMBNAILS_LEFT = "thumbnails-left";
	public static final String FULL_SCREEN = "full-screen";
	public static final String FULLSCREEN = "fullscreen";
	public static final String FULL_SCREEN_EXIT = "full-screen-exit";
	public static final String FULLSCREEN_EXIT = "fullscreen-exit";
	public static final String RESET_COLOR = "reset-color";
	public static final String PAINT_REMOVE = "paint-remove";
	public static final String BACKGROUND_REMOVE = "background-remove";

	// Layout and Navigation //
	public static final String ARROW_45_UP_RIGHT = "arrow-45-up-right";
	public static final String COLLAPSE_NE = "collapse-ne";
	public static final String RESIZE_NE = "resize-ne";
	public static final String ARROW_45_DOWN_RIGHT = "arrow-45-down-right";
	public static final String COLLAPSE_SE = "collapse-se";
	public static final String RESIZE_SE = "resize-se";
	public static final String ARROW_45_DOWN_LEFT = "arrow-45-down-left";
	public static final String COLLAPSE_SW = "collapse-sw";
	public static final String RESIZE_SW = "resize-sw";
	public static final String ARROW_45_UP_LEFT = "arrow-45-up-left";
	public static final String COLLAPSE_NW = "collapse-nw";
	public static final String RESIZE_NEW = "resize-new";
	public static final String ARROW_60_UP = "arrow-60-up";
	public static final String ARROW_60_RIGHT = "arrow-60-right";
	public static final String ARROW_60_DOWN = "arrow-60-down";
	public static final String ARROW_60_LEFT = "arrow-60-left";
	public static final String ARROW_END_UP = "arrow-end-up";
	public static final String ARROW_END_RIGHT = "arrow-end-right";
	public static final String ARROW_END_DOWN = "arrow-end-down";
	public static final String ARROW_END_LEFT = "arrow-end-left";
	public static final String ARROW_DOUBLE_60_UP = "arrow-double-60-up";
	public static final String ARROW_SEEK_UP = "arrow-seek-up";
	public static final String ARROW_DOUBLE_60_RIGHT = "arrow-double-60-right";
	public static final String ARROW_SEEK_RIGHT = "arrow-seek-right";
	public static final String ARROW_DOUBLE_60_DOWN = "arrow-double-60-down";
	public static final String ARROW_SEEK_DOWN = "arrow-seek-down";
	public static final String ARROW_DOUBLE_60_LEFT = "arrow-double-60-left";
	public static final String ARROWS_KPI = "arrows-kpi";
	public static final String KPI = "kpi";
	public static final String ARROWS_NO_CHANGE = "arrows-no-change";
	public static final String ARROW_OVERFLOW_DOWN = "arrow-overflow-down";
	public static final String ARROW_CHEVRON_UP = "arrow-chevron-up";
	public static final String ARROW_CHEVRON_RIGHT = "arrow-chevron-right";
	public static final String ARROW_CHEVRON_DOWN = "arrow-chevron-down";
	public static final String ARROW_CHEVRON_LEFT = "arrow-chevron-left";
	public static final String ARROW_UP = "arrow-up";
	public static final String ARROW_RIGHT = "arrow-right";
	public static final String ARROW_DOWN = "arrow-down";
	public static final String ARROW_LEFT = "arrow-left";
	public static final String ARROW_DRILL = "arrow-drill";
	public static final String ARROW_PARENT = "arrow-parent";
	public static final String ARROW_ROOT = "arrow-root";
	public static final String ARROWS_RESIZING = "arrows-resizing";
	public static final String ARROWS_DIMENSIONS = "arrows-dimensions";
	public static final String ARROWS_SWAP = "arrows-swap";
	public static final String DRAG_AND_DROP = "drag-and-drop";
	public static final String CATEGORIZE = "categorize";
	public static final String GRID = "grid";
	public static final String GRID_LAYOUT = "grid-layout";
	public static final String GROUP = "group";
	public static final String UNGROUP = "ungroup";
	public static final String HANDLER_DRAG = "handler-drag";
	public static final String LAYOUT = "layout";
	public static final String LAYOUT_1_BY_4 = "layout-1-by-4";
	public static final String LAYOUT_2_BY_2 = "layout-2-by-2";
	public static final String LAYOUT_SIDE_BY_SIDE = "layout-side-by-side";
	public static final String LAYOUT_STACKED = "layout-stacked";
	public static final String COLUMNS = "columns";
	public static final String ROWS = "rows";
	public static final String REORDER = "reorder";
	public static final String MENU = "menu";
	public static final String MORE_VERTICAL = "more-vertical";
	public static final String MORE_HORIZONTAL = "more-horizontal";

	// Mapping //
	public static final String GLOBE_OUTLINE = "globe-outline";
	public static final String GLOBE = "globe";
	public static final String MARKER_PIN = "marker-pin";
	public static final String MARKER_PIN_TARGET = "marker-pin-target";
	public static final String PIN = "pin";
	public static final String UNPIN = "unpin";

	// Media //
	public static final String PLAY = "play";
	public static final String PAUSE = "pause";
	public static final String STOP = "stop";
	public static final String REWIND = "rewind";
	public static final String FORWARD = "forward";
	public static final String VOLUME_DOWN = "volume-down";
	public static final String VOLUME_UP = "volume-up";
	public static final String VOLUME_OFF = "volume-off";
	public static final String HD = "hd";
	public static final String SUBTITLES = "subtitles";
	public static final String PLAYLIST = "playlist";
	public static final String AUDIO = "audio";

	// Social Sharing //
	public static final String SHARE = "share";
	public static final String USER = "user";
	public static final String INBOX = "inbox";
	public static final String BLOGGER = "blogger";
	public static final String BLOGGER_BOX = "blogger-box";
	public static final String DELICIOUS = "delicious";
	public static final String DELICIOUS_BOX = "delicious-box";
	public static final String DIGG = "digg";
	public static final String DIGG_BOX = "digg-box";
	public static final String EMAIL = "email";
	public static final String ENVELOP = "envelop";
	public static final String LETTER = "letter";
	public static final String EMAIL_BOX = "email-box";
	public static final String ENVELOP_BOX = "envelop-box";
	public static final String LETTER_BOX = "letter-box";
	public static final String FACEBOOK = "facebook";
	public static final String FACEBOOK_BOX = "facebook-box";
	public static final String GOOGLE = "google";
	public static final String GOOGLE_BOX = "google-box";
	public static final String GOOGLE_PLUS = "google-plus";
	public static final String GOOGLE_PLUS_BOX = "google-plus-box";
	public static final String LINKEDIN = "linkedin";
	public static final String LINKEDIN_BOX = "linkedin-box";
	public static final String MYSPACE = "myspace";
	public static final String MYSPACE_BOX = "myspace-box";
	public static final String PINTEREST = "pinterest";
	public static final String PINTEREST_BOX = "pinterest-box";
	public static final String REDDIT = "reddit";
	public static final String REDDIT_BOX = "reddit-box";
	public static final String STUMBLE_UPON = "stumble-upon";
	public static final String STUMBLE_UPON_BOX = "stumble-upon-box";
	public static final String TELL_A_FRIEND = "tell-a-friend";
	public static final String TELL_A_FRIEND_BOX = "tell-a-friend-box";
	public static final String TUMBLR = "tumblr";
	public static final String TUMBLR_BOX = "tumblr-box";
	public static final String TWITTER = "twitter";
	public static final String TWITTER_BOX = "twitter-box";
	public static final String YAMMER = "yammer";
	public static final String YAMMER_BOX = "yammer-box";
	public static final String BEHANCE = "behance";
	public static final String BEHANCE_BOX = "behance-box";
	public static final String DRIBBBLE = "dribbble";
	public static final String DRIBBBLE_BOX = "dribbble-box";
	public static final String RSS = "rss";
	public static final String RSS_BOX = "rss-box";
	public static final String VIMEO = "vimeo";
	public static final String VIMEO_BOX = "vimeo-box";
	public static final String YOUTUBE = "youtube";
	public static final String YOUTUBE_BOX = "youtube-box";

	// Toggle //
	public static final String HEART_OUTLINE = "heart-outline";
	public static final String FAV_OUTLINE = "fav-outline";
	public static final String FAVORITE_OUTLINE = "favorite-outline";
	public static final String HEART = "heart";
	public static final String FAV = "fav";
	public static final String FAVORITE = "favorite";
	public static final String STAR_OUTLINE = "star-outline";
	public static final String BOOKMARK_OUTLINE = "bookmark-outline";
	public static final String STAR = "star";
	public static final String BOOKMARK = "bookmark";
	public static final String CHECKBOX = "checkbox";
	public static final String SHAPE_RECT = "shape-rect";
	public static final String CHECKBOX_CHECKED = "checkbox-checked";
	public static final String TRI_STATE_INDETERMINATE = "tri-state-indeterminate";
	public static final String TRI_STATE_NULL = "tri-state-null";
	public static final String CIRCLE = "circle";
	public static final String RADIOBUTTON = "radiobutton";
	public static final String SHAPE_CIRCLE = "shape-circle";
	public static final String RADIOBUTTON_CHECKED = "radiobutton-checked";

	/**
	 * Constants class
	 */
	private KendoIcon()
	{
	}

	/**
	 * Indicates whether the icon is {@link KendoIcon#NONE}
	 *
	 * @param icon the icon
	 * @return true or false
	 */
	public static boolean isNone(String icon)
	{
		return KendoIcon.NONE.equals(icon);
	}

	/**
	 * Gets the full css-class of the icon
	 *
	 * @param icon the {@link KendoIcon}
	 * @return the full css-class
	 */
	public static String getCssClass(String icon)
	{
		if (!isNone(icon))
		{
			return String.format("%s k-i-%s", K_ICON, icon);
		}

		return "";
	}
}
