/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.calendar;

import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.calendar.CalendarView;
import com.googlecode.wicket.jquery.ui.calendar.ICalendarListener;
import com.googlecode.wicket.jquery.ui.calendar.settings.CalendarLibrarySettings;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class CalendarBehavior
extends JQueryBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "fullCalendar";
    private final ICalendarListener listener;
    private JQueryAjaxBehavior onSelectAjaxBehavior = null;
    private JQueryAjaxBehavior onDayClickAjaxBehavior;
    private JQueryAjaxBehavior onEventClickAjaxBehavior;
    private JQueryAjaxBehavior onEventDropAjaxBehavior = null;
    private JQueryAjaxBehavior onEventResizeAjaxBehavior = null;
    private JQueryAjaxBehavior onObjectDropAjaxBehavior = null;
    private JQueryAjaxBehavior onViewRenderAjaxBehavior = null;

    public CalendarBehavior(String selector, ICalendarListener listener) {
        this(selector, new Options(), listener);
    }

    public CalendarBehavior(String selector, Options options, ICalendarListener listener) {
        super(selector, METHOD, options);
        this.listener = (ICalendarListener)Args.notNull((Object)listener, (String)"listener");
        this.initReferences();
    }

    private void initReferences() {
        CalendarLibrarySettings settings = CalendarLibrarySettings.get();
        if (settings.getStyleSheetReference() != null) {
            this.add(settings.getStyleSheetReference());
        }
        if (settings.getJavaScriptReference() != null) {
            this.add(settings.getJavaScriptReference());
        }
        if (settings.getGCalJavaScriptReference() != null) {
            this.add(settings.getGCalJavaScriptReference());
        }
        if (settings.getLocalesJavaScriptReference() != null) {
            this.add(settings.getLocalesJavaScriptReference());
        }
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isSelectable()) {
            this.onSelectAjaxBehavior = this.newOnSelectAjaxBehavior(this);
            component.add(new Behavior[]{this.onSelectAjaxBehavior});
        }
        if (this.listener.isDayClickEnabled()) {
            this.onDayClickAjaxBehavior = this.newOnDayClickAjaxBehavior(this);
            component.add(new Behavior[]{this.onDayClickAjaxBehavior});
        }
        if (this.listener.isEventClickEnabled()) {
            this.onEventClickAjaxBehavior = this.newOnEventClickAjaxBehavior(this);
            component.add(new Behavior[]{this.onEventClickAjaxBehavior});
        }
        if (this.listener.isEventDropEnabled()) {
            this.onEventDropAjaxBehavior = this.newOnEventDropAjaxBehavior(this, this.listener.getEventDropPrecondition());
            component.add(new Behavior[]{this.onEventDropAjaxBehavior});
        }
        if (this.listener.isEventResizeEnabled()) {
            this.onEventResizeAjaxBehavior = this.newOnEventResizeAjaxBehavior(this, this.listener.getEventResizePrecondition());
            component.add(new Behavior[]{this.onEventResizeAjaxBehavior});
        }
        if (this.listener.isObjectDropEnabled()) {
            this.onObjectDropAjaxBehavior = this.newOnObjectDropAjaxBehavior(this);
            component.add(new Behavior[]{this.onObjectDropAjaxBehavior});
        }
        if (this.listener.isViewRenderEnabled()) {
            this.onViewRenderAjaxBehavior = this.newOnViewRenderAjaxBehavior(this);
            component.add(new Behavior[]{this.onViewRenderAjaxBehavior});
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        StringBuilder builder = new StringBuilder();
        builder.append("jQuery(\"<img id='calendar-indicator' src='").append(RequestCycleUtils.getAjaxIndicatorUrl()).append("' />\").appendTo('.fc-header-center');\n");
        builder.append("jQuery(document).ajaxStart(function() { jQuery('#calendar-indicator').show(); });\n");
        builder.append("jQuery(document).ajaxStop(function() { jQuery('#calendar-indicator').hide(); });\n");
        this.renderOnDomReadyScript(builder.toString(), response);
    }

    protected boolean isEditable() {
        return this.onDayClickAjaxBehavior != null || this.onEventClickAjaxBehavior != null;
    }

    public void onConfigure(Component component) {
        this.setOption("editable", this.isEditable());
        this.setOption("selectable", this.listener.isSelectable());
        this.setOption("selectHelper", this.listener.isSelectable());
        this.setOption("disableDragging", !this.listener.isEventDropEnabled());
        this.setOption("disableResizing", !this.listener.isEventResizeEnabled());
        this.setOption("droppable", this.listener.isObjectDropEnabled());
        if (this.onSelectAjaxBehavior != null) {
            this.setOption("select", this.onSelectAjaxBehavior.getCallbackFunction());
        }
        if (this.onDayClickAjaxBehavior != null) {
            this.setOption("dayClick", this.onDayClickAjaxBehavior.getCallbackFunction());
        }
        if (this.onEventClickAjaxBehavior != null) {
            this.setOption("eventClick", this.onEventClickAjaxBehavior.getCallbackFunction());
        }
        if (this.onEventDropAjaxBehavior != null) {
            this.setOption("eventDrop", this.onEventDropAjaxBehavior.getCallbackFunction());
        }
        if (this.onEventResizeAjaxBehavior != null) {
            this.setOption("eventResize", this.onEventResizeAjaxBehavior.getCallbackFunction());
        }
        if (this.onObjectDropAjaxBehavior != null) {
            this.setOption("drop", this.onObjectDropAjaxBehavior.getCallbackFunction());
        }
        if (this.onViewRenderAjaxBehavior != null) {
            this.setOption("viewRender", this.onViewRenderAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SelectEvent) {
            SelectEvent selectEvent = (SelectEvent)event;
            this.listener.onSelect(target, selectEvent.getView(), selectEvent.getStart(), selectEvent.getEnd(), selectEvent.isAllDay());
        } else if (event instanceof DayClickEvent) {
            DayClickEvent dayClickEvent = (DayClickEvent)event;
            this.listener.onDayClick(target, dayClickEvent.getView(), dayClickEvent.getDate(), dayClickEvent.isAllDay());
        } else if (event instanceof ClickEvent) {
            ClickEvent clickEvent = (ClickEvent)event;
            this.listener.onEventClick(target, clickEvent.getView(), clickEvent.getEventId());
        } else if (event instanceof DropEvent) {
            DropEvent dropEvent = (DropEvent)event;
            this.listener.onEventDrop(target, dropEvent.getEventId(), dropEvent.getDelta(), dropEvent.isAllDay());
        } else if (event instanceof ResizeEvent) {
            ResizeEvent resizeEvent = (ResizeEvent)event;
            this.listener.onEventResize(target, resizeEvent.getEventId(), resizeEvent.getDelta());
        } else if (event instanceof ObjectDropEvent) {
            ObjectDropEvent dropEvent = (ObjectDropEvent)event;
            this.listener.onObjectDrop(target, dropEvent.getTitle(), dropEvent.getDate(), dropEvent.isAllDay());
        } else if (event instanceof ViewRenderEvent) {
            ViewRenderEvent renderEvent = (ViewRenderEvent)event;
            this.listener.onViewRender(target, renderEvent.getView(), renderEvent.getStart(), renderEvent.getEnd());
        }
    }

    protected JQueryAjaxBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSelectAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnDayClickAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDayClickAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnEventClickAjaxBehavior(IJQueryAjaxAware source) {
        return new OnEventClickAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnEventDropAjaxBehavior(IJQueryAjaxAware source, CharSequence precondition) {
        return new OnEventDropAjaxBehavior(source, precondition);
    }

    protected JQueryAjaxBehavior newOnEventResizeAjaxBehavior(IJQueryAjaxAware source, CharSequence precondition) {
        return new OnEventResizeAjaxBehavior(source, precondition);
    }

    protected JQueryAjaxBehavior newOnObjectDropAjaxBehavior(IJQueryAjaxAware source) {
        return new OnObjectDropAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnViewRenderAjaxBehavior(IJQueryAjaxAware source) {
        return new OnViewRenderAjaxBehavior(source);
    }

    protected static class ObjectDropEvent
    extends JQueryEvent {
        private final LocalDateTime day;
        private final String title;
        private final boolean isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();

        public ObjectDropEvent() {
            String date = RequestCycleUtils.getQueryParameterValue((String)"date").toString();
            this.day = this.isAllDay ? LocalDate.parse(date).atStartOfDay() : LocalDateTime.parse(date);
            this.title = RequestCycleUtils.getQueryParameterValue((String)"title").toString();
        }

        public LocalDateTime getDate() {
            return this.day;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isAllDay() {
            return this.isAllDay;
        }
    }

    protected static class ResizeEvent
    extends DeltaEvent {
        protected ResizeEvent() {
        }
    }

    protected static class DropEvent
    extends DeltaEvent {
        private final boolean isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();

        public boolean isAllDay() {
            return this.isAllDay;
        }
    }

    protected static abstract class DeltaEvent
    extends JQueryEvent {
        private final String eventId = RequestCycleUtils.getQueryParameterValue((String)"eventId").toString();
        private final long delta = RequestCycleUtils.getQueryParameterValue((String)"millisDelta").toLong();

        public String getEventId() {
            return this.eventId;
        }

        public long getDelta() {
            return this.delta;
        }
    }

    protected static class ViewRenderEvent
    extends JQueryEvent {
        private final LocalDate start;
        private final LocalDate end;
        private final String viewName;

        public ViewRenderEvent() {
            String start = RequestCycleUtils.getQueryParameterValue((String)"startDate").toString();
            this.start = LocalDate.parse(start);
            String end = RequestCycleUtils.getQueryParameterValue((String)"endDate").toString();
            this.end = LocalDate.parse(end);
            this.viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();
        }

        public LocalDate getStart() {
            return this.start;
        }

        public LocalDate getEnd() {
            return this.end;
        }

        public CalendarView getView() {
            return CalendarView.get(this.viewName);
        }
    }

    protected static class ClickEvent
    extends JQueryEvent {
        private final String eventId = RequestCycleUtils.getQueryParameterValue((String)"eventId").toString();
        private final String viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();

        public String getEventId() {
            return this.eventId;
        }

        public CalendarView getView() {
            return CalendarView.get(this.viewName);
        }
    }

    protected static class DayClickEvent
    extends JQueryEvent {
        private final LocalDateTime day;
        private final boolean isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();
        private final String viewName;

        public DayClickEvent() {
            String date = RequestCycleUtils.getQueryParameterValue((String)"date").toString();
            this.day = this.isAllDay ? LocalDate.parse(date).atStartOfDay() : LocalDateTime.parse(date);
            this.viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();
        }

        public LocalDateTime getDate() {
            return this.day;
        }

        public boolean isAllDay() {
            return this.isAllDay;
        }

        public CalendarView getView() {
            return CalendarView.get(this.viewName);
        }
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final LocalDateTime start;
        private final LocalDateTime end;
        private final boolean isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();
        private final String viewName;

        public SelectEvent() {
            String start = RequestCycleUtils.getQueryParameterValue((String)"startDate").toString();
            this.start = this.isAllDay ? LocalDate.parse(start).atStartOfDay() : LocalDateTime.parse(start);
            String end = RequestCycleUtils.getQueryParameterValue((String)"endDate").toString();
            this.end = this.isAllDay ? LocalDate.parse(end).atStartOfDay() : LocalDateTime.parse(end);
            this.viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();
        }

        public LocalDateTime getStart() {
            return this.start;
        }

        public LocalDateTime getEnd() {
            return this.end;
        }

        public boolean isAllDay() {
            return this.isAllDay;
        }

        public CalendarView getView() {
            return CalendarView.get(this.viewName);
        }
    }

    protected static class OnViewRenderAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnViewRenderAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"view"), CallbackParameter.context((String)"element"), CallbackParameter.resolved((String)"viewName", (String)"view.name"), CallbackParameter.resolved((String)"startDate", (String)"view.start.format()"), CallbackParameter.resolved((String)"endDate", (String)"view.end.format()")};
        }

        protected JQueryEvent newEvent() {
            return new ViewRenderEvent();
        }
    }

    protected static class OnObjectDropAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnObjectDropAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.converted((String)"date", (String)"date.format()"), CallbackParameter.resolved((String)"allDay", (String)"!date.hasTime()"), CallbackParameter.context((String)"jsEvent"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"title", (String)"jQuery(this).data('title')")};
        }

        protected JQueryEvent newEvent() {
            return new ObjectDropEvent();
        }
    }

    protected static class OnEventResizeAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final CharSequence precondition;

        public OnEventResizeAjaxBehavior(IJQueryAjaxAware source, CharSequence precondition) {
            super(source);
            this.precondition = precondition;
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            if (!Strings.isEmpty((CharSequence)this.precondition)) {
                AjaxCallListener ajaxCallListener = new AjaxCallListener();
                ajaxCallListener.onPrecondition(this.precondition);
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"delta"), CallbackParameter.context((String)"revertFunc"), CallbackParameter.context((String)"jsEvent"), CallbackParameter.context((String)"ui"), CallbackParameter.context((String)"view"), CallbackParameter.resolved((String)"millisDelta", (String)"delta.asMilliseconds()"), CallbackParameter.resolved((String)"allDay", (String)"!event.start.hasTime()"), CallbackParameter.resolved((String)"eventId", (String)"event.id")};
        }

        protected JQueryEvent newEvent() {
            return new ResizeEvent();
        }
    }

    protected static class OnEventDropAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final CharSequence precondition;

        public OnEventDropAjaxBehavior(IJQueryAjaxAware source, CharSequence precondition) {
            super(source);
            this.precondition = precondition;
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            if (!Strings.isEmpty((CharSequence)this.precondition)) {
                AjaxCallListener ajaxCallListener = new AjaxCallListener();
                ajaxCallListener.onPrecondition(this.precondition);
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"delta"), CallbackParameter.resolved((String)"millisDelta", (String)"delta.asMilliseconds()"), CallbackParameter.resolved((String)"allDay", (String)"!event.start.hasTime()"), CallbackParameter.context((String)"revertFunc"), CallbackParameter.context((String)"jsEvent"), CallbackParameter.context((String)"ui"), CallbackParameter.context((String)"view"), CallbackParameter.resolved((String)"eventId", (String)"event.id")};
        }

        protected JQueryEvent newEvent() {
            return new DropEvent();
        }
    }

    protected static class OnEventClickAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnEventClickAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"jsEvent"), CallbackParameter.context((String)"view"), CallbackParameter.resolved((String)"eventId", (String)"event.id"), CallbackParameter.resolved((String)"viewName", (String)"view.name")};
        }

        protected JQueryEvent newEvent() {
            return new ClickEvent();
        }
    }

    protected static class OnDayClickAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDayClickAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.converted((String)"date", (String)"date.format()"), CallbackParameter.resolved((String)"allDay", (String)"!date.hasTime()"), CallbackParameter.context((String)"jsEvent"), CallbackParameter.context((String)"view"), CallbackParameter.resolved((String)"viewName", (String)"view.name")};
        }

        protected JQueryEvent newEvent() {
            return new DayClickEvent();
        }
    }

    protected static class OnSelectAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSelectAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.converted((String)"startDate", (String)"startDate.format()"), CallbackParameter.converted((String)"endDate", (String)"endDate.format()"), CallbackParameter.resolved((String)"allDay", (String)"!startDate.hasTime()"), CallbackParameter.context((String)"jsEvent"), CallbackParameter.context((String)"view"), CallbackParameter.resolved((String)"viewName", (String)"view.name")};
        }

        protected JQueryEvent newEvent() {
            return new SelectEvent();
        }
    }
}

