/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.kendo.datetime;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.kendo.KendoAbstractBehavior;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.model.IModel;

public class TimePicker
extends DateTextField
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "kendoTimePicker";
    public static final String DEFAULT_PATTERN = "hh:mm aaa";
    private Options options;

    public TimePicker(String id) {
        this(id, DEFAULT_PATTERN, new Options());
    }

    public TimePicker(String id, Options options) {
        this(id, DEFAULT_PATTERN, options);
    }

    public TimePicker(String id, String pattern) {
        this(id, pattern, new Options());
    }

    public TimePicker(String id, String pattern, Options options) {
        super(id, pattern);
        this.options = options;
    }

    public TimePicker(String id, IModel<Date> model) {
        this(id, model, DEFAULT_PATTERN, new Options());
    }

    public TimePicker(String id, IModel<Date> model, Options options) {
        this(id, model, DEFAULT_PATTERN, options);
    }

    public TimePicker(String id, IModel<Date> model, String pattern) {
        this(id, model, pattern, new Options());
    }

    public TimePicker(String id, IModel<Date> model, String pattern, Options options) {
        super(id, model, pattern);
        this.options = options;
    }

    public final String getTextFormat() {
        return super.getTextFormat();
    }

    public String getModelObjectAsString() {
        Date date = (Date)this.getModelObject();
        if (date != null) {
            return new SimpleDateFormat(this.getTextFormat()).format(date);
        }
        return "";
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    protected void onConfigure(JQueryBehavior behavior) {
        behavior.setOptions(this.options);
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new KendoAbstractBehavior(selector, METHOD){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                TimePicker.this.onConfigure(this);
            }
        };
    }
}

