/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.kendo.combobox;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.kendo.KendoAbstractBehavior;
import com.googlecode.wicket.jquery.ui.kendo.KendoTemplateBehavior;
import com.googlecode.wicket.jquery.ui.kendo.combobox.ComboBoxRenderer;
import com.googlecode.wicket.jquery.ui.template.IJQueryTemplate;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ComboBox<T>
extends TextField<String>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "kendoComboBox";
    private final IModel<List<? extends T>> choices;
    private final ComboBoxRenderer<? super T> renderer;
    private final IJQueryTemplate template;
    private KendoTemplateBehavior templateBehavior = null;

    public ComboBox(String id, List<? extends T> choices) {
        this(id, Model.ofList(choices), new ComboBoxRenderer());
    }

    public ComboBox(String id, List<? extends T> choices, ComboBoxRenderer<? super T> renderer) {
        this(id, Model.ofList(choices), renderer);
    }

    public ComboBox(String id, IModel<List<? extends T>> choices) {
        this(id, choices, new ComboBoxRenderer());
    }

    public ComboBox(String id, IModel<List<? extends T>> choices, ComboBoxRenderer<? super T> renderer) {
        super(id);
        this.choices = choices;
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    public ComboBox(String id, IModel<String> model, List<? extends T> choices) {
        this(id, model, Model.ofList(choices), new ComboBoxRenderer());
    }

    public ComboBox(String id, IModel<String> model, List<? extends T> choices, ComboBoxRenderer<? super T> renderer) {
        this(id, model, Model.ofList(choices), renderer);
    }

    public ComboBox(String id, IModel<String> model, IModel<List<? extends T>> choices) {
        this(id, model, choices, new ComboBoxRenderer());
    }

    public ComboBox(String id, IModel<String> model, IModel<List<? extends T>> choices, ComboBoxRenderer<? super T> renderer) {
        super(id, model);
        this.choices = choices;
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
        if (this.template != null) {
            Behavior[] behaviorArray = new Behavior[1];
            this.templateBehavior = new KendoTemplateBehavior(this.template);
            behaviorArray[0] = this.templateBehavior;
            this.add(behaviorArray);
        }
    }

    protected void onConfigure(JQueryBehavior behavior) {
        if (this.template != null) {
            behavior.setOption("template", (Serializable)((Object)String.format("jQuery('#%s').html()", this.templateBehavior.getToken())));
        }
        behavior.setOption("dataTextField", (Serializable)((Object)Options.asString((String)this.renderer.getTextField())));
        behavior.setOption("dataValueField", (Serializable)((Object)Options.asString((String)this.renderer.getValueField())));
        StringBuilder dataSource = new StringBuilder("[");
        List list = (List)this.choices.getObject();
        if (list != null) {
            for (int index = 0; index < list.size(); ++index) {
                Object object = list.get(index);
                if (index > 0) {
                    dataSource.append(", ");
                }
                dataSource.append("{ ");
                dataSource.append(this.renderer.getTextField()).append(": '").append(this.renderer.getText(object)).append("'");
                dataSource.append(", ");
                dataSource.append(this.renderer.getValueField()).append(": '").append(this.renderer.getValue(object)).append("'");
                if (this.template != null) {
                    for (String property : this.template.getTextProperties()) {
                        dataSource.append(", ");
                        dataSource.append(property).append(": '").append(this.renderer.getText(object, property)).append("'");
                    }
                }
                dataSource.append(" }");
            }
        }
        dataSource.append("]");
        behavior.setOption("dataSource", (Serializable)((Object)dataSource.toString()));
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new KendoAbstractBehavior(selector, METHOD){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                ComboBox.this.onConfigure(this);
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }
}

