/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2.config_browser;

import com.google.code.rees.scope.conversation.configuration.ConversationClassConfiguration;
import com.google.code.rees.scope.conversation.configuration.ConversationConfigurationProvider;
import com.google.code.rees.scope.struts2.ActionUtil;
import com.google.code.rees.scope.struts2.ConversationInterceptor;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ShowConfigAction
extends org.apache.struts2.config_browser.ShowConfigAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ShowConfigAction.class);
    private ConversationConfigurationProvider conversationConfigurationProvider;

    @Inject(value="struts.conversation.configurationProvider")
    public void setConversationConfigurationProvider(ConversationConfigurationProvider conversationConfigurationProvider) {
        this.conversationConfigurationProvider = conversationConfigurationProvider;
    }

    public String execute() throws Exception {
        String paramActionName = this.getActionName();
        if (this.getActionNames().contains("*")) {
            this.setActionName("*");
        }
        String result = super.execute();
        this.setActionName(paramActionName);
        return result;
    }

    public Set<String> getActionNames() {
        String namespace = this.getNamespace();
        TreeSet<String> actionNames = new TreeSet<String>(this.configHelper.getActionNames(this.getNamespace()));
        for (String actionName : actionNames) {
            if (!"*".equals(actionName)) continue;
            ActionConfig actionConfig = this.configHelper.getActionConfig(namespace, actionName);
            try {
                Class<?> actionClass = Class.forName(actionConfig.getClassName());
                actionNames.addAll(ActionUtil.getActions(actionClass));
            }
            catch (ClassNotFoundException e) {
                LOG.error("Could not find action class while trying to obtain Wild Card action methods!", new String[0]);
            }
        }
        return actionNames;
    }

    public Map<String, String> getConversations() throws ClassNotFoundException {
        ActionConfig actionConfig = this.getConfig();
        HashMap<String, String> conversations = new HashMap<String, String>();
        if (this.isConversationInterceptorApplied(actionConfig)) {
            Collection<ConversationClassConfiguration> realConfigs = this.getConversationConfigurations(actionConfig);
            String methodName = this.getMethodName(actionConfig);
            for (ConversationClassConfiguration realConfig : realConfigs) {
                String name = realConfig.getConversationName().replaceFirst("_conversation", "");
                if (realConfig.isBeginAction(methodName)) {
                    conversations.put(name, "Begin");
                    continue;
                }
                if (realConfig.isEndAction(methodName)) {
                    conversations.put(name, "End");
                    continue;
                }
                if (!realConfig.containsAction(methodName)) continue;
                conversations.put(name, "Continue");
            }
        }
        return conversations;
    }

    public Map<String, String> getConversationFields() throws ClassNotFoundException {
        ActionConfig actionConfig = this.getConfig();
        HashMap<String, String> conversationFields = new HashMap<String, String>();
        if (this.isConversationInterceptorApplied(actionConfig)) {
            Collection<ConversationClassConfiguration> realConfigs = this.getConversationConfigurations(actionConfig);
            String methodName = this.getMethodName(actionConfig);
            for (ConversationClassConfiguration realConfig : realConfigs) {
                Map fields;
                if (!realConfig.containsAction(methodName) || (fields = realConfig.getFields()).size() <= 0) continue;
                StringBuilder fieldDisplayBuilder = new StringBuilder();
                for (Map.Entry fieldEntry : fields.entrySet()) {
                    fieldDisplayBuilder.append((String)fieldEntry.getKey()).append(" (").append(((Field)fieldEntry.getValue()).getType().getSimpleName()).append("), ");
                }
                String displayString = fieldDisplayBuilder.substring(0, fieldDisplayBuilder.length() - 2);
                conversationFields.put(realConfig.getConversationName().replaceFirst("_conversation", ""), displayString);
            }
        }
        return conversationFields;
    }

    protected Collection<ConversationClassConfiguration> getConversationConfigurations(ActionConfig actionConfig) throws ClassNotFoundException {
        return this.conversationConfigurationProvider.getConfigurations(Class.forName(actionConfig.getClassName()));
    }

    protected boolean isConversationInterceptorApplied(ActionConfig actionConfig) {
        boolean hasConvoInterceptor = false;
        for (InterceptorMapping interceptorMapping : actionConfig.getInterceptors()) {
            if (!(interceptorMapping.getInterceptor() instanceof ConversationInterceptor)) continue;
            hasConvoInterceptor = true;
            break;
        }
        return hasConvoInterceptor;
    }

    protected String getMethodName(ActionConfig actionConfig) {
        String methodName = actionConfig.getMethodName();
        if (this.getActionNames().contains("*")) {
            methodName = this.getActionName();
        }
        return methodName;
    }
}

