/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.commons.servlet;

import com.googlecode.mycontainer.commons.servlet.ServletOutputStreamWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class EngineResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private PrintWriter writer = null;
    private ServletOutputStream out = null;

    public EngineResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new RuntimeException("getWriter() was called");
        }
        if (this.out == null) {
            this.out = new ServletOutputStreamWrapper(this.buffer);
        }
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.out != null) {
            throw new RuntimeException("getOutputStream() was called");
        }
        if (this.writer == null) {
            String characterEncoding = this.getResponse().getCharacterEncoding();
            OutputStreamWriter wrt = new OutputStreamWriter((OutputStream)this.buffer, characterEncoding);
            this.writer = new PrintWriter(wrt);
        }
        return this.writer;
    }

    public byte[] getBuffer() {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.out != null) {
                this.out.flush();
            }
            return this.buffer.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setContentLength(int len) {
    }
}

