/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.commons.servlet;

import com.googlecode.mycontainer.commons.rhino.DefaultRhinoBoxBuilder;
import com.googlecode.mycontainer.commons.rhino.RhinoBox;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class JSEngineFilter
implements Filter {
    public static final String PATH = JSEngineFilter.class.getName() + ".path";
    public static final String RELOAD = JSEngineFilter.class.getName() + ".reload";

    public RhinoBox getBox() {
        return DefaultRhinoBoxBuilder.getBox();
    }

    public void init(FilterConfig config) throws ServletException {
        String path = config.getInitParameter("script");
        if (path == null) {
            path = "jsengine.rhino.js";
        }
        boolean reload = !"false".equals(config.getInitParameter("reload"));
        ServletContext ctx = config.getServletContext();
        ctx.setAttribute(PATH, (Object)path);
        ctx.setAttribute(RELOAD, (Object)reload);
        this.load(ctx);
    }

    private void load(ServletContext ctx) {
        RhinoBox box = this.getBox();
        String path = (String)ctx.getAttribute(PATH);
        box.enter();
        try {
            URL url = this.getClass().getResource(path);
            if (url == null) {
                url = ctx.getResource(path);
            }
            if (url == null) {
                throw new RuntimeException("path not found: " + path);
            }
            box.source(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        finally {
            box.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        ServletContext ctx = req.getSession().getServletContext();
        Boolean reload = (Boolean)ctx.getAttribute(RELOAD);
        if (reload.booleanValue()) {
            this.load(ctx);
        }
        RhinoBox box = this.getBox();
        box.enter();
        try {
            box.invoke(this.getClass(), "onRequest", new Object[]{request, response, chain});
        }
        finally {
            box.exit();
        }
    }

    public void destroy() {
    }
}

