package com.googlecode.mycontainer.commons.servlet.rhino;

import java.util.Collections;
import java.util.List;

import org.mozilla.javascript.Scriptable;

import com.googlecode.mycontainer.commons.rhino.DefaultRhinoBoxBuilder;
import com.googlecode.mycontainer.commons.rhino.RhinoBox;
import com.googlecode.mycontainer.commons.rhino.RhinoScope;

public class RhinoBoxConsole implements RhinoBoxManager {

	public RhinoBox getBox() {
		return DefaultRhinoBoxBuilder.getBox();
	}

	public List<String> list(String path) {
		RhinoBox box = getBox();
		box.enter();
		try {
			RhinoScope scope = box.getScope();
			if (path == null) {
				path = "this";
			} else {
				path = "this." + path;
			}
			Object obj = box.eval(path, getClass());
			if (!(obj instanceof Scriptable)) {
				return Collections.emptyList();
			}
			scope = new RhinoScope((Scriptable) obj);
			List<String> ret = scope.getKeys();
			Collections.sort(ret);
			return ret;
		} finally {
			box.exit();
		}
	}

	public List<String> list() {
		return list(null);
	}

	public Object eval(String code) {
		RhinoBox box = getBox();
		box.enter();
		try {
			return box.eval(code, getClass());
		} finally {
			box.exit();
		}
	}

}
