package com.googlecode.mycontainer.js.junit;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

import com.googlecode.mycontainer.cpscanner.ClasspathScanner;

public class MyContainerJSRunner extends Runner {

    private Description description;

    private List<JavaScriptTestCase> cases = new ArrayList<JavaScriptTestCase>();

    public MyContainerJSRunner(Class<?> clazz) {
        description = Description.createSuiteDescription(clazz.getName());

        List<URL> urls = findJS(clazz);
        for (URL url : urls) {
            JavaScriptTestCase testCase = new JavaScriptTestCase(url);
            if (!testCase.hasTestUnits()) {
                throw new RuntimeException("empty test file: " + url.getPath());
            }
            cases.add(testCase);
            description.addChild(testCase.getDescription());
        }
    }

    @Override
    public Description getDescription() {
        return description;
    }

    @Override
    public void run(RunNotifier notifier) {
        notifier.fireTestStarted(description);
        try {
            for (JavaScriptTestCase caze : cases) {
                caze.run(notifier);
            }
        } finally {
            notifier.fireTestFinished(description);
        }
    }

    private List<URL> findJS(Class<?> clazz) {
        ClasspathScanner classpathScanner = new ClasspathScanner();
        ListJavaScriptScannerListener listScannerListener = new ListJavaScriptScannerListener();
        classpathScanner.addListener(listScannerListener);

        classpathScanner.scan(clazz);

        List<URL> urls = listScannerListener.getJavaScripts();
        return urls;
    }
}
