package com.googlecode.mycontainer.js.junit;

import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.mozilla.javascript.Function;

import com.googlecode.mycontainer.commons.rhino.RhinoBox;

public class JavaScriptTestUnit {

    private Description description;

    private Function testFunction;

    public JavaScriptTestUnit(String name, String testName, Function testFunction) {
        this.testFunction = testFunction;
        description = Description.createTestDescription(getClass(), testName + "(" + name + ")");
    }

    public Description getDescription() {
        return description;
    }

    public void run(RhinoBox rhinoBox, RunNotifier notifier) {
        notifier.fireTestStarted(description);
        try {
            rhinoBox.invoke(getClass(), testFunction);
        } catch (Exception ex) {
            notifier.fireTestFailure(new Failure(description, ex));
        } finally {
            notifier.fireTestFinished(description);
        }
    }
}
