/*
 * Copyright 2010 Trustees of the University of Pennsylvania Licensed under the
 * Educational Community License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 *
 * http://www.osedu.org/licenses/ECL-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package metridoc.plugins.datasource

import javax.sql.DataSource

class DataSourcePluginUtils {

    /**
     * standardizes all inputs
     *
     * @param args map of parameters to validate and standardize
     */

    static void validateAndFormatArgs(LinkedHashMap args) {
        if(args.jdbcUrl) {
            args.url = args.remove("jdbcUrl")
        }
        if(args.driverClass) {
            args.driver = args.remove("driverClass")
        }
        if(args.driverClassName) {
            args.driver = args.remove("driverClassName")
        }
        if(args.userName) {
            args.user = args.remove("userName")
        }
    }

    static void setProperties(LinkedHashMap args, DataSource dataSource) {
        args.each{key, value ->
            dataSource."${key}" = value
        }
    }
}